---
title: "Service Accounts"
sub_link: "organizations/service-accounts"
meta_title: "Polyaxon management tools and UI - Service Accounts"
meta_description: "Polyaxon managers can create service accounts to issue organization level tokens for CE(Continuous Integration)/CD(Continuous Delivery)/CT(Continuous Training)."
tags:
  - concepts
  - polyaxon
  - management
sidebar: "management"
---

<blockquote class="commercial">This is part of our commercial offering.</blockquote>

Users with the `owner` or `manager` role can create service accounts to issue organization's level tokens for CI(Continuous Integration)/CD(Continuous Delivery)/CT(Continuous Training): 

 * Service accounts are not tied to a specific user and do not use any user's API tokens.
 * Each service account can have one or multiple tokens with different expiration configuration.
 * Each token can be refreshed, regenerated or deleted.
 * All tokens will inherit the same scopes and access rules of the service account they are linked to.
 * All activities generated by the tokens will link back to the service account they belong to in the activity logs or the runs table.

## Create service account

If you have access you can create new service accounts

![sa-create](../../../../content/images/dashboard/sa/create.png)

By default a service account is created with the `admin` role, but the behavior can be altered by selecting the scopes the service account should be initialized with.

![sa-create-scopes](../../../../content/images/dashboard/sa/create-scopes.png)

## Service account's tokens

Once you create a service account a default token will be created

![sa-tokens](../../../../content/images/dashboard/sa/tokens.png)

Users can issue additional tokens related to that specific service account

![sa-token-create](../../../../content/images/dashboard/sa/token-create.png)

All tokens will have the same scopes as the service account

![sa-token-token-scopes](../../../../content/images/dashboard/sa/token-scopes.png)


## Manage service accounts

You can list, review, and manage all service accounts

![sa-manage](../../../../content/images/dashboard/sa/manage.png)

## Service account settings

You can update or delete a service account

![sa-settings](../../../../content/images/dashboard/sa/settings.png)

> **N.B.**: After creating a service account, if the scopes are updated, all tokens related to that services will be patched with the new scopes. 
