---
title: "Management tools"
sub_link: ""
is_index: true
meta_title: "Polyaxon management tools and UI"
meta_description: "Polyaxon UI is a tool for managing organizations, teams, projects, agents, runs..."
tags:
  - concepts
  - polyaxon
  - management
sidebar: "management"
---

## Organizations Management UI

 * Managing organizations, teams, members, projects.
 * Managing agents and queues.
 * Setting permissions and authorizations.
 * Monitoring agents and runs.
 * Profiling runs and connections' access.

## Projects Management UI

 * Managing project access and restrictions.
 * Organizing and monitoring runs.
 * Auditing activities and profiling workloads.

## Runs dashboard

 * Dashboarding capabilities and collaboration.
 * Native visualizations.
 * Custom visualizations with Plotly, Bokeh, Vega.
 * Powerful rendering engine with automatic handling for code files, html, audio, video, ...
 * Lineage view.
 * Flexible comparison table for hyperparameters and metrics with built-in search, query, sort, limit to navigate millions of runs.
 * Native integration with the tracking API.
 * Automate your process from training to deriving insights from results.
 * Collaborative by design.

## Component Hub

Polyaxon Component Hub is a product for managing versioned components, each component can:
 * Have multiple versions.
 * Can be published publicly or privately within your organization.
 * Can define team level permissions.

## Model Registry

Polyaxon Model Registry is a models store and a system that provides:
 * APIs and a UI.
 * It can be used with your teams' configuration and access control settings to enable collaborative model management.
 * Logging and lineage using the experimentation feature.
 * Versioning.
 * Deploying as an internal tool or as a test API using the service abstraction.
 * Agnostic to the model packaging format.
 * Integrations with your favorite serving technologies.

## Artifacts Versioning

Polyaxon Artifacts Versioning is a system to promote runs and version assets, it provides:
 * APIs and a UI.
 * Possibility to attach additional summary and information about the assets.
 * Lineage and locking of the runs generating the data and artifacts versions.
 * Can define team level permissions.
