---
title: "Welcome"
sub_link: ""
meta_title: "Introduction to Polyaxon - Core Concepts"
meta_description: "Polyaxon is an open-source platform for managing deep learning and machine learning lifecycle for teams who need power, flexibility, and performance."
is_index: true
visibility: public
status: published
tags:
  - concepts
  - training
  - scale
  - scheduling
  - platform
  - kubernetes
  - helm
  - containers
  - micro-services
  - deep-learning
  - machine-learning
  - enterprise
sidebar: "intro"
---

Welcome to Polyaxon, a platform for automating and reproducing deep learning and machine learning applications.

Polyaxon deploys into any data center, cloud provider,
or can be hosted and managed by Polyaxon,
and it supports all major deep learning frameworks such as Tensorflow, MXNet, Caffe, Torch, etc.

Polyaxon makes it faster, easier, and more efficient to develop machine learning and deep learning applications.
It is designed for individuals, teams, and organizations who need reproducibility, compliance, power, flexibility, and performance.
It allows workloads scheduling with smart container and node management, and turns GPU servers into shared, self-service resources for your team or organization.

Here you will find comprehensive guides for setting up Polyaxon on your cluster,
and information for training, tracking, monitoring, and managing your data science lifecycle.

We do our best to make this documentation clear and user friendly,
if you see anything that is incorrect or have any questions,
feel free to reach out at the
[issues page](https://github.com/polyaxon/polyaxon/issues),
[forum](/slack/)
or [contact us](mailto:contact@polyaxon.com).

Please check our [quick start guide](/docs/intro/quick-start/) to start training your first experiment.
After finishing the quick-start guide, you can learn about specific aspects of the platform by exploring other introduction guides.

To gain a deeper understanding of how Polyaxon can help you iterate faster with your experimentation process,
please take some time to familiarize yourself with Polyaxon's [concepts](/docs/intro/concepts/organization-concepts/)

## Mission

Polyaxon’s mission is to make machine learning and deep learning simple and accessible to enterprises.

Current advances in machine learning and deep learning have a direct impact on business,
yet few companies are leveraging these latest technologies.
The data science space is still lacking good tooling and best practices
for organizing practitioners' workflows. It's particularly challenging
because of the variety of tools and requirements used to develop production-ready models.

Our goal is to enable Polyaxon's users to use rigorous practices and workflows to
go from reproducible and portable experiments to scalable model deployments.

## How is Polyaxon different?

The first question most people have is, of course, how is Polyaxon different from everything else out there? Here's a quick summary:

 * Allows you to own your data ✅
 * Customizable and extensible ✅
 * Works with any framework or library ✅
 * Integrates with other tools in the community ✅
 * Built-in automation engine ✅
 * Built-in optimization engine ✅
 * Advanced dashboard for insights, collaboration, tracking, comparing, and monitoring  ✅
 * Comprehensive SDK ✅
 * Command Line Interface ✅
 * Native REST API ✅
 * Uses modern technology and is continuously improving ✅
 * Core engine is open-source ✅
 * Fast ✅
 * Reliably secure ✅
 * Made with passion and is here for long ✅
 * Has a sustainable business model with [EE & Cloud versions](/pricing/) ✅

## Ecosystem

There is a broad range of tools, resources, and helpful tutorials for working with Polyaxon available to help you get started.

Before diving into Polyaxon's features in the next section, it's useful to give to get a high-level overview of where to find things!

### The blog

For long-form news and announcements, the best place to keep up to date with everything happening is [our blog](https://polyaxon.com/blog/).
There's an [RSS feed](https://polyaxon.com/blog/rss.xml) and
also [a newsletter](https://polyaxon.us17.list-manage.com/subscribe/post?u=1b6eccb8409861418bcc5dbfc&id=012464842e).

### Community channel

The [Polyaxon community channel](/slack/) is where to find other Polyaxon users.

### Media links

To keep in touch with people directly and give them updates about what's new with Polyaxon.
Here are the easiest ways to keep track of Polyaxon:

- [Github](https://github.com/polyaxon/polyaxon)
- [Twitter](https://twitter.com/polyaxonAI)

### Guides &  Tutorials

We publish some [guides and tutorials](https://polyaxon.com/blog) from time to time to explain or clarify how to use our tools in practical ways.
These guides have tags, you can for instance show all guides for a particular tag to gain deeper knowledge about that area.

### Frequently asked questions

**Don't forget!** If you have any questions or problems the best places to start is the search box on this page, which will immediately return all results from across our documentation and [FAQ](/faq/) archive.


If you have a subscription to one of our enterprise editions (`Cloud` or `EE`),
just drop us an email on `support@polyaxon.com` and we'll be more than happy to help.
