---
title: "Custom Charts"
sub_link: "visualizations"
meta_title: "Visualization in Polyaxon - Experimentation"
meta_description: "Polyaxon comes with a powerful and customizable visualization system for driving visualization in the dashboard or programmatically."
tags:
  - concepts
  - polyaxon
  - experimentation
  - experiments
  - architecture
sidebar: "experimentation"
---

## Overview

Polyaxon comes with a powerful and customizable visualization system for driving insights in the dashboard or programmatically.

Oftentimes users have advance use cases that are not supported by the platform, or they need to integrate visualizations generated by external systems.

Polyaxon can consume any chart specification generated by these libraries:

 * Matplotlib
 * Plotly
 * Bokeh
 * Altair/Vega

## Matplotlib

You can log charts generated by [Matplotlib](https://matplotlib.org/) directly to Polyaxon.

Polyaxon supports two methods for logging matplotlib figures:

 * Logging figures as images
 * Parsing the figures to interactive charts

### Matplotlib static figures

```python
from polyaxon import tracking

figure = ...

tracking.init(...)

tracking.log_mpl_image(figure, name="my-figure", step=12)
```

![run-dashboards-matplotlib-static](../../../../content/images/dashboard/runs/dashboards-matplotlib-static.png)

> More info about [tracking api](/docs/experimentation/tracking/module/#log_mpl_image)

### Matplotlib interactive figures

```python
from polyaxon import tracking

figure = ...

tracking.init(...)

tracking.log_mpl_plotly_chart(figure=figure, name="my-figure", step=12)
```

![run-dashboards-matplotlib-interactive](../../../../content/images/dashboard/runs/dashboards-matplotlib-interactive.png)

> More info about [tracking api](/docs/experimentation/tracking/module/#log_mpl_plotly_chart)

## Plotly

You can log charts generated by [Plotly](https://plotly.com/) directly to Polyaxon.

```python
from polyaxon import tracking

figure = ...

tracking.init(...)

tracking.log_plotly_chart(figure=figure, name="my-figure", step=12)
```

![run-dashboards-plotly](../../../../content/images/dashboard/runs/dashboards-plotly.png)

> More info about [tracking api](/docs/experimentation/tracking/module/#log_plotly_chart)


## Bokeh

You can log charts generated by [Bokeh](https://bokeh.org/) directly to Polyaxon.

```python
from polyaxon import tracking

figure = ...

tracking.init(...)

tracking.log_bokeh_chart(figure=figure, name="my-figure", step=12)
```

![run-dashboards-bokeh](../../../../content/images/dashboard/runs/dashboards-bokeh.png)

> More info about [tracking api](/docs/experimentation/tracking/module/#log_bokeh_chart)

## Altair

You can log charts generated by [Altair](https://altair-viz.github.io) or [vega-light](http://vega.github.io/vega-lite/) directly to Polyaxon

```python
from polyaxon import tracking

figure = ...

tracking.init(...)

tracking.log_altair_chart(figure=figure, name="my-figure", step=12)
```

![run-dashboards-altair](../../../../content/images/dashboard/runs/dashboards-altair.png)

> More info about [tracking api](/docs/experimentation/tracking/module/#log_altair_chart)
