---
title: "Release notes for v2.5"
sub_link: "2-5"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/2-5.md"
meta_title: "Polyaxon release notes for v2.5.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v2.5.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

> **N.B.**: If you are upgrading from polyaxon v1.x, please check the [v2 release notes](/docs/releases/2-0/) and the [migration guide](/docs/resources/migration/#migration-from-v1x-to-v2y).

## V2.5.3

### Core

 * **Enhancement**: Add `--approve-after` / `-aa` to the run command to allow delaying or automatically approving a run after a certain number of seconds.
 * **Enhancement**: Do not raise an error if upload file does not exist.
 * **Enhancement**: Do not raise an error if logs cannot be collected.
 * **Fix**: Issue with scheduling requiring human approval with uploaded artifacts.

### Commercial

 * **Beta**: Add support for single control plane UI and steaming from run's defined agent or default streams url.
 * **Fix**: Issue with the agent reconcile checks for stopping and deleting runs out of sync.

## V2.5.2

### Core

 * **Enhancement**: Automatically cleanup uploads and archives in the streams pod to avoid filling up the disk.
 * **Enhancement**: Add support for `logLevel` in init artifacts containers.
 * **Enhancement**: Do not collect core pods logs in debug mode.
 * **Fix**: Issue with logging in streams pod printing the root path `/` for each thread.

### Agent

 * **Fix**: Issue with agent reconciliation checks.
 * **Fix**: Issue with agent data collection cron.

### Commercial

 * **Fix**: Issue with the members API not returning the full list of users.

## V2.5.1

### Core

 * **Fix**: Fix issue with dashboard and search pages returning request too long on refresh.

### Commercial

 * **Enhancement**: Add stage changes to activity logs.
 * **Fix**: Issue with member restriction component only returning the first 100 users.

## V2.5.0

### Core

 * **Enhancement**: Add support for python 3.12.
 * **Enhancement**: Update fs requirements.
 * **Enhancement**: Add `.venv` to the default ignore list.
 * **Enhancement**: Improve handling of `ttl` and ops reconcile logic.
 * **Fix**: Fix regression with in CE agent.
 * **Fix**: Issue with `last_time`, it should be optional in `query_k8s_pod_logs`.

### CLI

 * **Enhancement**: Do not break CLI if current package cannot be found.

### Deployment

 * **Breaking**: If you use the built-in postgresql, you need to handle data upgrade manually.
 * **Enhancement**: Update deployment chart requirements to use postgresql release 15.5.35.
 * **Enhancement**: Update postgresql image to bitnami/postgresql:16.4.0-debian-12-r11.
 * **Enhancement**: Update deployment chart requirements to use redis release 20.1.5.
 * **Enhancement**: Update redis image to bitnami/redis:7.4-alpine.
 * **Enhancement**: Update base images.
 * **Security**: Fix critical vulnerabilities.

### UI

 * **New**: Add new agent viewer mode for non organization admin users to view agents' stats, status, and scheduling configurations.
 * **New**: Add project kind filter on project list to allow showing component hubs, model registries, ...
 * **Enhancement**: Consolidate runs and analytics to reduce sidebar buttons, users can select analytics from layout.
 * **Enhancement**: Update sidebar to organize all infra views under a single infra section.
 * **Enhancement**: Update sidebar to organize components, models, artifacts under a single versions section.
 * **Enhancement**: Allow customizing the runtimes on project creation.
 * **Enhancement**: Consolidate runtimes and features restrictions in a single tab.
 * **Enhancement**: Improve contributor lists on projects.
 * **Fix**: Issue with quick search (cmd + /) when team space is selected.
 * **Fix**: Issue with restrictions dropdown not loading the full users list.
 * **Fix**: Issue with resizing in analytics charts.

### Commercial

 * **Beta**: Add new notifications/alerts/events layer to the clients to allow sending mid-run events to external systems.
 * **Beta**: Add automation to create a monitoring of conditions and events and trigger actions.
 * **Beta**: Add control plane integrations.
 * **Enhancement**: Allow members to delete experiments they created (users with admin role or above can still delete any experiment).
 * **Enhancement**: Add tags views on teams and projects to only show stats for that entity.
