---
title: "Release notes for v2.3"
sub_link: "2-3"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/2-3.md"
meta_title: "Polyaxon release notes for v2.3.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v2.3.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

> **N.B.**: If you are upgrading from polyaxon v1.x, please check the [v2 release notes](/docs/releases/2-0/) and the [migration guide](/docs/resources/migration/#migration-from-v1x-to-v2y).

## V2.3.3

### Core

 * **Enhancement**: Change default `verify_ssl` value from `True` to `None` for S3 storage to handle clusters with outdated SSL certificates.
 * **Enhancement**: Improve handling of env vars handling for connections.
 * **Fix**: Issue with compiler not respecting the build section's configured queue, namespace, presets, ... in the component version.
 * **Fix**: Issue with compiler not respecting the hook section's configured queue, namespace, presets, ... in the component version.
 * **Fix**: Issue with restarting runs with a hub reference.

### Commercial

 * **Enhancement**: Add possibility to set restrictions on service accounts.

## V2.3.2

### Core

 * **Fix**: FS logic for local storage.

### Operator

 * **Fix**: Regression with operator not detecting pod events correctly in K8S version 1.23 and below.
    * Revert Go version to 1.19 and kube-builder to 3.1.0.
    * Revert k8s.io/apimachinery to v0.26.1.

### UI

 * **Enhancement**: Show x-axis labels on the metrics chart.
 * **Enhancement**: For linebreaks in the input/output's json/yaml view.
 * **Fix**: Regression in IO table's raw mode.

### Commercial

 * **Enhancement**: Add view to show teams a member is part of.
 * **Enhancement**: Improve selection for team members for org roles manager and owner.
 * **Enhancement**: Add selected team route to automatically show on browsing.

## V2.3.1

### Core

 * **Enhancement**: Add a new flag `AWS_ASSUME_ROLE` to allow users to specify whether to assume the role or not.
 * **Fix**: Issue with S3 service automatically trying to assume arn role.

### UI

 * **Fix**: Regression in project's sidebar when the project is only a registry.

### Commercial

 * **Enhancement**: Improve activity logs API performance.
 * **Fix**: Issue with activity logs event type filter.

## V2.3.0

### CLI

 * **Fix**: Regression in authenticating service accounts.

### Operator

  * **Enhancement**: Update Kuberay operator to v1.
  * **Enhancement**: Update Polyaxon operator to use go 1.22 and kubebuilder 4.1.0.
  * **Enhancement**: Update Polyaxon operator to use `OnFailure` as default policy for restarts for KF distributed jobs.
  * **Fix**: Issue with KF operator not propagating labels and annotations for replicas.

### Core

 * **New**: Collect pod events and service events.
 * **Enhancement**: Make `OnFailure` the default restart policy for Kubeflow distributed jobs.
 * **Enhancement**: Add `ExitCode` restart policy for Kubeflow distributed jobs.
 * **Fix**: Regression in query managers.
 * **Fix**: Regression in restart API returning a type instead of value which breaks the client.

### UI

 * **New**: Add possibility to compare cross-project run's metrics.
 * **New**: Add events to pod inspection view.
 * **New**: Add status and conditions to pod inspection view.
 * **Enhancement**: Restore possibility to dock the sidebar.
 * **Enhancement**: Update sidebar to show fewer icons for runs with dropdowns.
 * **Enhancement**: Move selected items actions to the table.
 * **Enhancement**: Add presets, queues, agents, and other resources to the sidebar on projects to show accessible or restricted resources.
 * **Enhancement**: Improve team space sidebar to not show all resources if it has a restriction policy attached.
 * **Enhancement**: Improve input/output's json/yaml view to break lines.
 * **Enhancement**: Improve saved searches.
 * **Enhancement**: Add recommended searches.
 * **Enhancement**: Add current query spec and dashboard spec on save forms.
 * **Enhancement**: Increase pagination size for members table.
 * **Enhancement**: Enable project analytics for CE.
 * **Fix**: Regression in sorting members by name.
 * **Fix**: Regression with Dag/Matrix pipeline and graph views not showing old runs.
 * **Fix**: Regression with run's stats not showing all data.
 * **Fix**: Regression with search editor breaking when pins clicking edit button of pins in chrome.

### Commercial

  * **New**: Add possibility to set default team or organization space.
  * **New**: Add possibility to filter runs, projects, models, artifacts, and components by contributors.
  * **New**: Add possibility to filter activity logs by event type.
  * **New**: Add possibility to show runs table for a specific analytics view.
  * **New**: Allow saving analytics search and dashboard settings.
  * **New**: Allow saving filters on organization and team space levels.
  * **New**: Add filter by event type to the activity logs pages.
  * **Enhancement**: Show projects using a specific preset.
  * **Enhancement**: Expose configuration for cleaning intervals.
  * **Fix**: Issue with the team space stats.
