---
title: "Release notes for v2.1"
sub_link: "2-1"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/2-1.md"
meta_title: "Polyaxon release notes for v2.1.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v2.1.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

> **N.B.**: If you are upgrading from polyaxon v1.x, please check the [v2 release notes](/docs/releases/2-0/) and the [migration guide](/docs/resources/migration/#migration-from-v1x-to-v2y).


## V2.1.8

### UI

 * **Enhancement**: Automatically show/hide sidebar.

### Deployment

 * **Enhancement**: Add annotations for agent scheduling's service accounts.
 * **Enhancement**: Add missing socat package to the deployment.
 * **Enhancement**: Add protocol to proxy configuration.
 * **Enhancement**: Add vim package to base docker images.

## V2.1.7

### CLI

 * **Enhancement**: Add `push` command to sync local artifact/component/model versions with a remote server.
 * **Fix**: Issue with component pull command.

### UI

 * **Enhancement**: Move workload metadata information in run's overview to show agent version and agent host if available.

### Commercial

* **Enhancement**: Add support for agent host setting.

## V2.1.6

### Core

 * **Enhancement**: Update filesystems versions.
 * **Security**: Fix CVE issues.

### Tracking

 * **Enhancement**: Add extension to log_image_with_boxes.

### Deployment

 * **Enhancement**: Add flag to skip mounting volumes, secrets, and configs that are present in multiple connections.

## V2.1.5

### UI

 * **Fix**: Regression in step widget configuration.

### Commercial

  * **Enhancement**: Allow setting console backend for email without debug mode.

## V2.1.4

### Tracking

 * **Enhancement**: Add model extension to keras callback.

### UI

 * **New**: Add dashboard level configuration to set smoothing, x-axis, and other sections and widgets settings.
 * **New**: Add section level configuration to set smoothing, x-axis, and other widgets settings.
 * **New**: Add possibility to freeze widgets and sections settings.
 * **Enhancement**: Improve drag and drop in dashboards.

## V2.1.3

### UI

 * **Enhancement**: Increase offsets for fetching information in several UI components.
 * **Fix**: Issue lineage dropdown limiting the number of artifacts to 100 when promoting a run to a model version or an artifact version.

### Commercial

  * **New**: Add `namespaces` restriction to the project settings.
  * **New**: Add `policies` to create organization level restrictions and reuse them across projects.
  * **Enhancement**: Improve operation namespace resolution.
  * **Fix**: Regression with settings agents restriction in project settings.

## V2.1.2

### Core

 * **Fix**: Regression in deployment CE with scheduler.
 * **Security**: Fix CVE issues.

### Agent

 * **Fix**: Issues with unclosed session warning logs.

### Commercial

  * **Enhancement**: Improve multi-runs deletion process.
  * **Fix**: Issue with deletion of pending runs not being stopped.

## V2.1.1

### Agent

 * **Enhancement**: Improve agent logs collection and streaming.
 * **Enhancement**: Improve agent inspection logic.

### UI

 * **Enhancement**: Enable agent logs viewing and streaming for versions higher than v2.1.
 * **Enhancement**: Enable agent inspection for agents for versions higher than v2.1.



## V2.1.0

### CLI

 * **Enhancement**: Add namespace to polyaxonfile manifests.
 * **Enhancement**: Update k8s manager to support overriding the namespace for deployments with multiple namespaces.

### Core

 * **Enhancement**: Add automated artifacts management to local cron agent for sandbox deployment.
 * **Enhancement**: Update filesystems versions.
 * **Security**: Fix CVE issues.

### Agent

 * **Beta**: Allow multi-namespace management.
 * **Beta**: Add agent reconciliation logic to clean monitored namespaces.
 * **Beta**: Add agent logs collection and streaming.
 * **Beta**: Add agent inspection logic.

### Deployment

 * **Enhancement**: Improve service accounts and roles for deployments.
 * **Fix**: Issue with workers and concurrency deployment config for gateway service.

### Operator

 * **Enhancement**: Add elastic policy and update scheduling policy
 * **Enhancement**: Add watch cluster to operator and agent deployment schema for multi-namespace management.
 * **Enhancement**: Update training operator.

### UI

 * **Enhancement**: Improve raw Json/Yaml viewer.

### Commercial

  * **Enhancement**: Add support for Okta groups.
  * **Enhancement**: Improve hmac logic.
  * **Security**: Fix CVE issues.
