---
title: "Release notes for v1.9"
sub_link: "1-9"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-9.md"
meta_title: "Polyaxon release notes for v1.9.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.9.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.9.6

### UI

 * **Enhancement**: Several improvements.

### CLI

 * **Fix**: Some minor issues.

### Docs

 * **Enhancement**: Add cost estimation and new queueing guides.

## v1.9.5

### CLI

 * **Fix**: CLI does not use correct context path for collecting nested DAG references.

### Core

 * **Enhancement**: Enable templating for `termination` section.


### Operator

 * **Enhancement**: Improve operation's status reconciliation logic.
 * **Fix**: Regression in timeout logic.


### Client

 * **Fix**: Discrepancy in the usage of the `is_offline` flag between the client init and the client decorator.

### Docs

 * **Enhancement**: Consolidate the Python library and tracking intro and quick-start guides.

## v1.9.4

### CLI

 * **Enhancement**: Improve Polyaxonfile checks and error messages.
 * **Enhancement**: Improve build process.
 * **Fix**: Regression when checking for DAG references from `globals` context values.
 * **Fix**: Bug collecting nested DAG references.

### UI

 * **Enhancement**: Improve UUID references to only show 8 characters and copy the full value on click.
 * **Enhancement**: Prevent artifacts from refreshing or re-rendering when the run is the running stage.
 * **Enhancement**: Improve project/component/model cards with long descriptions, names, and/or multiple tags.

### Commercial

 * **Enhancement**: Build and upload not setting the correct lineage information.
 * **Enhancement**: Build deletion does not set the run to `upstream_failed`.
 * **Enhancement**: Improve restart and resume process when an operation has a build section.

## v1.9.3

### Agent

 * **Enhancement**: Add spawner refresh logic to mitigate several issues with AKS's numerous networking problems.

### Core

 * **Fix**: Regression in the parsing logic of null values and IO type string.

### Streams

 * **Enhancement**: Add a new protected read-only artifact API to allow viewing artifacts in separate tabs.

### UI

 * **Enhancement**: Add tags filter and use regex for searching projects/hub/registry/connections/...
 * **Enhancement**: Hide project deletion in Polyaxon CE until the logic for cleaning runs and artifacts is moved to the core repo.

### Deployment & Setup

 * **Enhancement**: Update Kubeflow charts.
 * **Enhancement**: Improve liveness probes for scheduler related deployments.

## v1.9.2

### Core

 * **Enhancement**: Add better handling for the `approval` process when an `upload` and/or a `build` is triggered.
 * **Enhancement**: Preserve the parameter names when converting inputs/outputs to args using `params.NAME.as_args` or `params.as_args` and only change behavior using `argFormat`.

### Deployment & Setup

 * **Enhancement**: Patch Kubeflow charts with `imagePullPolicy: IfNotPresent`

### UI

 * **Enhancement**: Add sidebar link to the build process.
 * **Enhancement**: Allow to manually approve runs pending cache to be scheduled without waiting for the cached results.
 * **Enhancement**: Do not show the graph view for `matrix` runs with random search and grid search.

### Commercial

 * **New**: Add beta support for an automatic build process on the operation level.
   * This feature does not replace the ad-hoc build operations, users can still create independent polyaxonfiles with a kaniko/dockerize hubRef.
   * The no-build requirement that the platform provides does not change, users who have stable pipelines that do not require frequent changes to their images can safely ignore this feature.
   * A new section called `build` allows to define the necessary fields for creating a container as well as other flags for the queue, preset, resources, node selectors, ... specific to the build.
   * An image based on the project and the run's uuid, i.e. `project:build-uuid`, is generated automatically and set on the main containe.
   * Users can provide an alternative destination image and override the generated value.
   * When the build and matrix sections are used together, a single build operation will be scheduled and will be used for all runs.
   * When the build and upload are used together, the uploaded artifacts are initialized in the build run.
 * **Fix**: Regression in Bayes tuner.

## v1.9.1

### CLI

 * **Enhancement**: Relax int type validation to tolerate float values, e.g. `12.` or `1.0`, generated from the `Matrix` section.
 * **Enhancement**: Improve string validation and conversion.
 * **Enhancement**: Add possibility to get all params as arguments without passing one by one: `{{ params.as_args }}`

### Core

 * **New**: Add `plugings.mountArtifactsStore` to simplify and to abstract requesting and mounting the artifacts store in the main container:
   * The context will also expose the `store_path` variable to abstract getting the path instead of using `connections[CONNECTION_NAME].schema`.
 * **Enhancement**: Rename `multi-runs` occurrences to `multi-run`.
 * **Enhancement**: Improve parser engine `map_format` function to allow passing a variable name.
 * **Fix**: Calculation of `wait_time` and `duration` for long running operations.
 * **Fix**: Regression in eager mode.

### Tracking

 * **Enhancement**: Disable `log_importance` on xgboost callback by default.

### UI

 * **Enhancement**: Improve the behavior of the service page to not require a refresh in order to remove the cached error page.

### Docs

 * **Enhancement**: Restructure `quick-start` section into several sub-sections with common themes
   * `quick start` will only introduce the library and the initial setup.
   * `iterative process guides`: will include all tools and concepts that helps a researcher to iterate on their programs.
   * `automation and scaling guides`: will include current Matrix, Dag, Schedule, Hooks, and distributed runs guides, as well as some upcoming DAG tutorials.
   * `serving and apps guides`: Will include an end-to-end tutorial from training to serving an API, serving an app, or creating a custom dashboard/report.
   * `builds guides`: Will include guides on building containers independently, as part of a DAG, using the per-operation build section.
   * `tracking guides`: Will include guides on how to use tracking module and some advanced methods on the run client.
   * `CLI guides`: Will include some CLI guides.
   * `k8s guides`: Will include generic guides on how to interact with raw Kubernetes and Polyaxonfile specification.
 * **Enhancement**: Add integration guide for Flask.
 * **Enhancement**: Add integration guide for FastAPI.
 * **Enhancement**: Improve roadmap and known issues.

### Hub

 * **New**: Add two new versions `:single-run-storepath` and `:multi-run-storepath` which allow to start Tensorboard directly from the artifact store in sync mode.
 * **Enhancement**: Improve Tensorboard component versions to only load tensorboard and not the complete outputs directory.

### Commercial

 * **Fix**: Calculation of `cache.ttl` logic.

## v1.9.0

### CLI

 * **Enhancement**: Improve `polyaxon ops restart --copy` to allow customizing the paths to copy, e.g. `polyaxon ops restart --copy-dir=dir1 --copy-dir=path/dir2 --copy-file=path/dir3/file1`.
 * **Enhancement**: Improve `polyaxon run` command to support both `-u/--upload` and `--eager` for non-managed `Matrix` operations.
 * **Enhancement**: Allow to restart/copy operations with new name, description, tags, and meta-info.
 * **Enhancement**: Add check for legacy CLI package, i.e. `polyaxon-cli`, and raise an error to avoid conflicts.
 * **Enhancement**: Stop distributing tests to reduce package size.
 * **Fix**: Issue with `admin deploy` and debug mode `-v` failing at `get_or_create_namespace` check when the namespace already exists.

### Core

 * **Enhancement**: Improve `RunClient.create` method to correctly resolve references before submitting operations to the API in Polyaxon CE.
 * **Enhancement**: Increase default `requests.memory` for auxiliary containers to prevent scheduling pods on low memory nodes and to prevent impacting other core components.
 * **Enhancement**: Improve restart with upload, currently restarting runs with uploaded artifacts fail because of missing artifacts.
 * **Enhancement**: Improve restart with copy mode, users can provide the paths to copy, by default it will copy all artifacts to preserve the previous behavior.
 * **Enhancement**: Refactor approval process to use a more generic pending logic.
 * **Enhancement**: Improve matrix creation in eager mode and clean-up the matrix run placeholder.
 * **Misc**: Replace `whitelist/WHITELIST` occurrences with `allowed_list/ALLOWED_LIST` to make consist naming with other packages.
 * **Fix**: Deletion of non-managed runs in Polyaxon CE.

### Tracking

 * **Enhancement**: Improve `KerasCallback` with the flag `use_store_path` to enable using the `artifactsStore` path to write the checkpoints and model artifacts.
 * **Enhancement**: Update `get_artifacts_path` and `get_outputs_path` to accept `use_store_path: bool = False` param to return the path relative to the artifacts store path instead of the context.
 * **Fix**: Bug with `RunClient.log_tags` missing a check for the case when tags are initially `None`.
 * **Fix**: Bug with `Run.end` calling `_exit_handler` even when the exist handler is not initialized.

### UI

 * **Enhancement**: Add UI fields to the pass name, description, tags in the restart form.
 * **Enhancement**: Fix the icon used for `Update pipeline concurrency` button in the run's dropdown.

### Deployment & Setup

 * **Enhancement**: Add `options` field to `externalServices.postgresql` to allow passing extra options when configuring API/Scheduler with an external database instance.
   * For example to require ssl, users should add: `options: {'sslmode': 'require'}`

### Docs

 * **Fix**: Docs formatting issues.

### House Keeping

 * **Enhancement**: Upgrade base packages.
 * **Enhancement**: Update tests requirements.

### Commercial

 * **New**: Allow to update connections configuration from UI:
   * Owner/Managers can opt into updating the connections catalog and other configs directly from the UI.
   * This is an opt-in feature and can be reverted to YAML based configuration, in which case a redeploy is required.
   * The `artifactsStore` as well as several required configurations still need to be deployed using the Helm chart.
   * This feature can be enabled on per-agent basis.
 * **New**: Add read-ony table to the agent view to show connections defined by each agent.
 * **Enhancement**: Add `is_promoted` indicator to runs linked to a model version in the model registry to reduce confusion.
 * **Enhancement**: Improve UI pipeline progress indicator.
 * **Enhancement**: Add basic stats to projects and runs overview pages in all plans.
 * **Enhancement**: Add possibility to batch cleaning operations in a single job based on the artifacts store.
   * This should avoid overwhelming cluster(s) where the agent is running.
 * **Enhancement**: Add project runtimes customization to the settings page.
   * Admins can select runtimes to allow on a specific project.
 * **Enhancement**: Speedup bulk insertions and updates.
 * **Enhancement**: Improve audit for archive, restore, support request, and billing actions.
 * **Enhancement**: Improve activity logs for runs to store and show the names at the time of auditing.
 * **Enhancement**: Improve activity logs to always show uuids for entities with a uuid to distinguish resources deleted and recreated with the same name.
 * **Enhancement**: Improve run stopping by using the restorable manager instead of the live manager to handle archived runs.
 * **Enhancement**: Do not allow users to set projects/components/models visibility to public if the organization is private to reduce confusion.
