---
title: "Release notes for v1.8"
sub_link: "1-8"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-8.md"
meta_title: "Polyaxon release notes for v1.8.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.8.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.8.5

### CLI

 * **Enhancement**: Improve `--git-preset` to allow loading customized configuration yaml file.
 * **Fix**: Regression with `polyaxon run ... --git-preset` when the project is initialized with a `connection` and not a `url`

### Docs

 * **Enhancement**: Add new how-to guide to customize the git-preset.
 * **Enhancement**: Add new scheduling guide about organizing environments/machines as a catalog with presets.
 * **Enhancement**: Add new integrations docs.
 * **Enhancement**: Fix several issues with the Markdown documents.

## v1.8.4

### CLI

 * **Enhancement**: Improve error handling of some cache and loader utils functions.
 * **Enhancement**: Add better handling for run with `--git-preset`.

### Core

 * **Enhancement**: Add better error handling for operation patch logic.
 * **Fix**: Regression with `V1ObjectMeta` sanitization.
 * **Fix**: Regression with distributed jobs scheduling.
 * **Fix**: Regression with run deletion in Polyaxon CE.

### UI

 * **Enhancement**: Always show a browser tooltip when hovering a column header in the comparison table.
 * **Fix**: Some typos in forms and modals.
 * **Fix**: Issue in the comparison toolbar.
 * **Fix**: Issue with download CSV not handling dicts and arrays correctly.
 * **Fix**: Regression in opening a component version.
 * **Fix**: Regression in submitting polyaxonfiles containing a component and the predefined version.

### Docs

 * **Enhancement**: Add a matrix table with actions and user' roles to improve understanding of what users can and cannot do.
 * **Enhancement**: Add Plotly Dash example.

### Agent

 * **Enhancement**: Several enhancements plus core fixes.

### Commercial

 * **Enhancement**: Do not restrict joins to finished runs only.
 * **Enhancement**: Add `deletion in progress` indicator to the overview pages to reduce the confusion
    when a user deletes a run or project and then goes again to the overview page of that same entity.
 * **Enhancement**: Add documentation links to the members and teams management modal to allow `Owners` and `Managers` to quickly view what each role can and cannot do.
 * **Enhancement**: Add missing restore buttons on settings page for project/component hub/model registry.
 * **Enhancement**: Add pre-delete check to better handle runs waiting for the cached results and queue them for actual computation.
 * **Enhancement**: Improve caching logic.
 * **Enhancement**: Add Polyaxon support authorization to the organization's settings.
 * **Enhancement**: Add Polyaxon Cloud metadata viewing management to the organization's settings.

## v1.8.3

### Core

 * **Enhancement**: Allow the operation initializer service to accept additional init artifacts.
 * **Enhancement**: Speedup GCS upload and download dirs.
 * **Enhancement**: Update polytune's requirements.

### UI

 * **Enhancement**: Always sort dirs/files in the artifacts tab.
 * **Enhancement**: Improve help links.
 * **Enhancement**: New icon for cached operations awaiting computation.
 * **Fix**: Connections lineage tab was showing the agent name instead of the connection name.

### Docs

 * **Enhancement**: Add new How-Tos and FAQs.
 * **Enhancement**: Update docs for membership.
 * **Fix**: Several typos.

### Agent

 * **Enhancement**: Several improvements based on core updates.

### Commercial

 * **Enhancement**: Add better health check indicator for agents.
 * **Enhancement**: Declare non-executed conditional branches as skipped.
 * **Enhancement**: Add new status `awaiting_cache` to flag runs waiting for a progressing run instead of the current `starting` status.
 * **Fix**: Regression that counts cached runs in the concurrency limit because of the `starting` status.


## v1.8.2

### CLI

 * **Enhancement**: Improve `plx run --help` with examples about `-u-to/--upload-to` and `-u-from/--upload-from`.

### Core

 * **Enhancement**: Speedup GCS deletion.
 * **Enhancement**: Speedup GCS objects listing.
 * **Fix**: Issue with `GCSConnection.list` method not returning the files with size 0.
   * This issue impacts Polyaxon CE and Polyaxon Agent with an artifacts store on GCS.

### UI

 * **Fix**: Issue with infinite refetch when a file is empty.
 * **Fix**: Issue with `approve` button in the run's settings dropdown.

### House Keeping

 * **Enhancement**: Update packages with security issue.
 * **Enhancement**: Update moto version in tests requirements.


### Commercial

 * **Enhancement**: Make `matrix` section work with `-u/--upload`.
 * **Enhancement**: Improve pipelines's deletion in progress process.
 * **Enhancement**: Reduce cron intervals.

## v1.8.1

### CLI

  * **Enhancement**: Improve `IgnoreManager` to always apply a default set of ignore patterns when a user does not properly initialize a `.polyaxonignore` file to avoid uploading `.git` and other large/unnecessary folders.
  * **Fix**: Issue with `IgnoreManager` not respecting the rule "If there is a separator at the end of the pattern then the pattern will only match directories".

### UI

  * **New**: Add automatic Netron rendering in the artifacts tab.
  * **Enhancement**: Do not automatically open unknown extensions to not accidentally load large binary files in the artifacts tab.
  * **Fix**: Raw and Render buttons were inverted.

### Docs

  * **Enhancement**: Move members/users management to its own sub-section under organization.
  * **Enhancement**: Add integration docs to highlight artifacts rendering.

## v1.8.0

### CLI

 * **Enhancement**: Add `--no-purge` flag to `polyaxon config set` to allow reconfiguring the host without removing auth and other options:
   * Useful when users have multiple agents on different hosts/ingresses or when using Polyaxon Agent and Polyaxon CE at the same time.
 * **Enhancement**: Improve missing context (owner/project) in error messages.

### Core

 * **Enhancement**: Add missing `wait_time` and `duration` fields to the query manager, e.g. `query=wait_time:>60,duration:<3600` will return all runs with wait time higher than 60 seconds and a duration of less than an hour.
 * **Enhancement**: Sanitize container names generated based on connections to be valid DNS-1123 labels.
 * **Enhancement**: Improve error responses to be consumed correctly by the operator.
 * **Fix**: Issue with query manager coercing values to string.
 * **Fix**: Issue with resuming runs started with `-u`.
 * **Fix**: Add attempt at fixing `--recurse-submodules` when a revision is provided.
 * **Fix**: Issue `tracking.log_dataframe` using the wrong function signature.

### UI

  * **New**: Add automatic notebook rendering in the artifacts tab.
  * **New**: Add button to switch between raw content and auto-render for HTML/Markdown/Notebook/... files.
  * **Enhancement**: Re-enable table widget in the dashboards tab.
  * **Enhancement**: Reorder flag filters based on their importance.
  * **Enhancement**: Delay tooltips of the buttons (full-screen and flyout) on the comparison table to improve usability.
  * **Enhancement**: Render whitespace correctly in logs viewer.
  * **Enhancement**: Improve refresh logic for service, e.g. notebook, tensorboard, to avoid the cached error page after the service starts running.
  * **Enhancement**: Change job icon.
  * **Enhancement**: Improve statuses page not loading all transitions in some situations.
  * **Enhancement**: Improve default color palette and remove the initial random color selection.

### Docs

 * **Enhancement**: Improve documentation for streamlit, tensorboard, notebook, jupyterlab, vscode.
 * **Enhancement**: Improve documentation for notifications.
 * **Fix**: Broken links.

### Deployment & Setup

 * **Deprecation**: Drop `notificationConnections` and only accept `connections`, please make sure to move all `notificationConnections` to the `connections` catalog.
   * `plugins.notifications` and `notificationConnections` were deprecated since several versions.
   * This change does not break or remove the logic for components using `plugins.notifications`, but the notifier connection is resolved directly from the `connections` catalog.
   * `plugins.notifications` will be completely removed once we push `hooks` to Polyaxon CE.

### Hub

 * **New**: Move notifiers to the public hub.
 * **New**: Move tuners to the public hub.

### Agent

 * **Enhancement**: Improve stopping and archiving agents.

### Commercial

 * **New**: Add graph view for DAGs.
   * Safari still needs some work to display the buttons/icons.
 * **New**: Add new "manager" role, the manager has similar capabilities as the "owner" role but does not have access to the billing view/APIs.
 * **New**: Add possibility to customize the full tuner component in hyper-optimization definition.
 * **New**: Add meta-information lineage tab with data about run's relationships (agent, queue, component version, model versions, ...)
 * **New**: Add custom actions; the possibility to start downstream operations from the UI based on the current run or a selection of runs and a component hub.
 * **New**: Add button to start single run tensorboard from the UI.
 * **New**: Update DAG/Matrix concurrency from the UI using the run's dropdown control.
 * **Enhancement**: Improve cache to consider defined outputs and to include context only params as well, `V1Cache` defines now `io` instead of `inputs` to allow managing all io definitions.
 * **Enhancement**: Add `upstream/downstream` to the `RunQueryManager`
   * To search the upstream/downstream runs `query=upstream:UUID` or `query=downstream:UUID1 | UUID2`.
 * **Enhancement**: Add `queue` field to the hook specification to allow to pass a queue to a hook without requiring a preset for that.
 * **Enhancement**: Improve optimization process to not raise an error if a param cannot be validated against IO, the behavior is now to implicitly convert it to a context only param.
 * **Enhancement**: Update tuners to use joins for querying observations.
 * **Enhancement**: Add upstream lineage between tuners and suggested runs.
 * **Enhancement**: Add badge to runs if they are cached or archived.
 * **Enhancement**: Improve archive/restore runs.
 * **Enhancement**: Improve buttons shown to users for performing actions based on their roles.
 * **Enhancement**: Improve spaces deletion and recovery.
 * **Enhancement**: Improve several admin forms.
 * **Enhancement**: Improve members and teams forms.
 * **Enhancement**: Improve members table actions.
 * **Enhancement**: Add two new tabs to the team details view to show components and models accessible by a team similar to the projects tab.
 * **Enhancement**: Always sync the organization's settings to reduce confusion and avoid manual refresh when performing admin activities on the organization level.
 * **Enhancement**: Resolve tuners and notifiers operations from the public component hub.
 * **Enhancement**: Improve the default notifiers' details.
 * **Enhancement**: Show multi-run actions based on the user's role.
 * **Enhancement**: Add check to prevent DAG and Matrix from starting if an error is raised during the compilation process.
 * **Enhancement**: Improve runs' edges and avoid duplicating edges on resume.
 * **Enhancement**: Improve project/component/model switch and selection to refresh the data if it's missing.
 * **Enhancement**: Improve project/component/model name update by adding a warning and automatically redirecting to the new entity name.
 * **Enhancement**: Re-enable organization name update and add warning about the impact of such change.
 * **Enhancement**: Improve stopping logic for DAG and Matrix runs.
 * **Enhancement**: Improve heartbeat service to clean-up stopping runs.
 * **Fix**: Issue with DAG inputs/outputs validation when the component should be resolved from the component hub.
 * **Fix**: Issue with archive run API erroneously changes the run status.
 * **Fix**: Issue with pipeline progress crashing the flyout view for runs with pipelines.
 * **Fix**: Regression in public organizations not showing the sidebar for non-authenticated users.
 * **Fix**: Regression with queues table when an organization has a single agent.
 * **Fix**: Regression in the user profile page to allow changing the username field.
