---
title: "Release notes for v1.7"
sub_link: "1-7"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-7.md"
meta_title: "Polyaxon release notes for v1.7.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.7.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.7.6

### Commercial

 * **Enhancement**: Several improvements.

## v1.7.5

### CLI

 * **Enhancement**: Improve `--git-preset --git-revision ` logic and error message.

### Core

 * **Fix**: Do not break training if the KerasCallback cannot track a parameter.

### Commercial

 * **Enhancement**: Several improvements.

## v1.7.4

### CLI

 * **Fix**: `polyaxon -h` documentation.

### Core

 * **Fix**: Issue in `container.env` sanitization logic.

### UI

 * **Enhancement**: Use open/closed locks to help distinguish visibility of organizations, projects, models, components.

### Agent

  * **Fix**: Issue in converter.

### Commercial

 * **Enhancement**: Add a note about the expiration date to the invitation email template.
 * **Enhancement**: Extend invitation expiration period from 2 days to 4 days.
 * **Enhancement**: Improve team member and team catalog scopes and permissions.

## v1.7.3

### CLI

 * **Fix**: `polyaxon upgrade` command to download the correct library.

### UI

 * **Enhancement**: Show a link to the tracking docs in the widget form when no event was logged.
 * **Enhancement**: Remove beta badge from `html`, `audio`, and `video` widgets.
 * **Fix**: Issue with Bokeh charts in fullscreen mode not rendering.

### Commercial

 * **Enhancement**: Add select button for dashboard creation to set the view level: `any`, `single`, and `compare`.
 * **Fix**: Typos in the modal forms for deleting dashboards and searches.
 * **Fix**: Issues in clones and streams lineage.

## v1.7.2

### Core

 * **Fix**: Corrupted release package.

## v1.7.1 [deleted]

### CLI

  * **Fix**: Issue with duplicate logs in stream phase.

### Core

  * **Enhancement**: Improve parser's typing system for str types, this should avoid evaluating dumped json string into dicts.
  * **Enhancement**: Improve `RunClient` creation methods to not trigger `sys.exit(1)` and raise an exception instead when used programmatically.
  * **Fix**: Regression with delete not triggering artifacts clean pods in CE when `scheduler` is enabled.

### UI

  * **Enhancement**: Improve `polyaxonfile` tab to make the manifest take the full size of the page.
  * **Enhancement**: Update Bokeh bundle version to render charts generated by new Python versions.
  * **Enhancement**: Allow saving names and descriptions using `ENTER`.
  * **Enhancement**: Improve scroll behavior in flyout mode in chrome and safari.
  * **Fix**: Table loading indicator in safari.

## v1.7.0

### CLI

  * **New**: Add `plx` as a second CLI entrypoint (`plx --help` or `polyaxon --help`).
  * **Enhancement**: `polyaxon create project ... --init` will also create the `.polyaxonignore` file automatically.
  * **Enhancement**: `polyaxon ops get ...` will show the owner and project to reduce user's confusion about the implicit values.
  * **Enhancement**: Add default limit value to the `ls` command to avoid any API regression impacting the behavior of the command.
  * **Enhancement**: Improve pagination metadata and navigation instructions.

### Core

  * **Enhancement**: Reset the default limit for operations list to 20.
  * **Fix**: `patch_strategy` in jsonschema not using camel case.

### UI

  * **New**: Allow to download results as CSV from the comparison table.
  * **Enhancement**: Use read-only editor for rendering Polyaxonfiles to allow folding sections.
  * **Enhancement**: Allow to select hover mode (closest and compare) for line charts.
  * **Enhancement**: Truncate charts legends when using UUIDs to 12 characters.
  * **Enhancement**: Improve scatter plot tooltips.
  * **Enhancement**: Improve dark theme line charts.
  * **Enhancement**: Add error boundary around charts to prevent bad widgets or external configs from taking down the complete UI.
  * **Enhancement**: Improve timeline hover tooltip.

### Tracking

 * **New**: Add new callbacks and logging capabilities.
   * Add scikit tracking integration.
   * Add lightgbm tracking callback.
   * Add xgboost tracking callback.
   * Add PytorchLightning tracking callback.
 * **Enhancement**: Consolidate Keras callbacks into a single callback to track metrics and the model and expose flag to allow enabling and disabling some behaviors.
 * **Enhancement**: Improve tensorflow callback and expose flag to enable tracking of images, histo, ...
 * **Enhancement**: Consolidate naming convention for contrib callbacks/loggers as `PolyaxonCallback` or `polyaxon_callback`.
 * **Enhancement**: Improve `log_dataframe` in the versioned assets interface to persist `csv` or `html` and allow other persisting formats using the manual logging only.
 * **Enhancement**: Sanitize inputs/params and outputs/results keys to fqn.
 * **Enhancement**: Improve artifact/model tracking.
 * **Enhancement**: Improve `log_sklearn_pr_curve` and `log_sklearn_roc_auc_curve` to handle multi-class curves.
 * **Enhancement**: Allow saving single and versioned artifacts and models by passing `versioned=False`.
 * **Enhancement**: Improve `get_artifacts_path` and `get_outputs_path` to handle `rel_path` as well as to ensure that the path exists using `ensure_path=True`.
 * **Enhancement**: Improve sanitization of params and filenames.
 * **Enhancement**: Improve offline mode.

### Operator

 * **Enhancement**: Update CRD to `apiextensions.k8s.io/v1`.
   * The CustomResourceDefinition API type is promoted to `apiextensions.k8s.io/v1` since K8s 1.16.
   * A flag is provided `operator.useCRDV1Beta1` to keep the previous behaviour.

### Docs

 * **Enhancement**: Improve tracking integration docs and add examples.
 * **Enhancement**: Improve visualization libraries integration docs and add examples.
 * **Enhancement**: Add new quick-start guide `iterating with presets`.

### Examples

 * **Enhancement**: Add new examples with the new integrations.
 * **Enhancement**: Fix and improve several examples and polyaxonfile manifests.

### Deployment & Setup

 * **Enhancement**: Add `operator.useCRDV1Beta1` flag to force deploying with v1beta1 and to preserve compatibility with k8s cluster <= 1.15.
 * **Fix**: TFJob deployment chart.

### House Keeping

 * **Enhancement**: Improve tests to avoid persisting events and artifacts during the tests.
 * **Enhancement**: Add ci for Python 3.9.

### Commercial

 * **Enhancement**: Improve hyperparameter tuning pipelines.
 * **Fix**: Some issues in the organizations' cleaning routines.
