---
title: "Release notes for v1.6"
sub_link: "1-6"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-6.md"
meta_title: "Polyaxon release notes for v1.6.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.6.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.6.2

### Core

  * **Enhancement**: Improve tracking interface and artifacts tracking.
  * **Enhancement**: Allow to save extra summary information in the lineage table.
  * **Enhancement**: Allow to persist logs using the JSON format and the compressed (PVS) format.

### UI

  * **Enhancement**: Improve app loading speed and startup time.
  * **Enhancement**: Implement several enhancements to speed rendering.
  * **Enhancement**: Improve scrollbars in run pages and remove the jumpy behavior in some browsers.

### Deployment & Setup

 * **Enhancement**: Add `agent.compressedLogs` flag to disable the compressed format and use the JSON format for persisting logs.

### Docs

  * **Enhancement**: Improve tracking docs.
  * **Fix**: Typos.

### House Keeping

 * **Enhancement**: Relax tests requirements.

### Commercial

  * **Enhancement**: Improve login/signup forms.
  * **Enhancement**: Internal improvements.

## v1.6.1

### Core

  * **Fix**: Issue with streams raising a tokenizing error.

### UI

  * **Enhancement**: Refactor comparison table to avoid triggering useless re-renders.
  * **Fix**: Issue with offline vendor libs.

### Docs

 * **Enhancement**: Add `iterate programmatically` to the intro quick-start.
 * **Enhancement**: Add `enable ml tracking` how-to guide.
 * **Enhancement**: Improve Horovod docs.
 * **Enhancement**: Remove the deprecated in-cluster registry guide.

### House Keeping

 * **Enhancement**: Update tests requirements.

## v1.6.0

### Core

 * **Security**: Upgrade packages with security issues.
 * **New**: Add file initializer:
   * Avoids a clone if only a file or script can be generated before starting a run,
   * Can be used to initialize a python/shell... script that should be executed by the user in another init container or the main container.
   * Can be used to initialize a YAML/Json/... file that can be used by another init container or the main container.
 * **New**: Add completion and validation for Polyaxonfiles in IDEs (VSCode, Pycharm, ...).
 * **Enhancement**: Deprecate `iotype` field in favor of `type`.
 * **Enhancement**: Add missing unique constraint on project names in Polyaxon CE.
 * **Enhancement**: Add missing delete artifacts methods to `RunClient`: `delete_artifact` and `delete_artifacts`.
 * **Enhancement**: Add `upload_artifacts_dir` as a utils function around `upload_artifacts` to streamline crawling files while respecting the ignore patterns.
 * **Enhancement**: Move lifecycle created_at/started_at/finished_at to core.
 * **Enhancement**: Improve logs disk footprint by changing the persistence  format, around `35%`less space.
 * **Enhancement**: Avoid unnecessary API updates syncing old meta info states.
 * **Enhancement**: Avoid unnecessary artifacts store check for temp logs.
 * **Enhancement**: Reduce potential egress by `30% ~ 50%`.
 * **Enhancement**: Add sidecar plugin to allow controlling and overriding the global sidecar definition per operation.
 * **Enhancement**: Improve preset's partial validation to disable required fields on restart/resume operations and presets definitions.
 * **Enhancement**: Sanitize and transform tracking event names to a fully qualified names.
 * **Enhancement**: Allow reading polyaxonfiles without extension as `yaml` by default.
 * **Fix**: Issue with the API host not sanitized when the user configures the CLI with an IP or a host value without a protocol.

### Tracking

  * **New**: Add handling of related runs created in a notebooks/vescode session in-cluster.
  * **New**: Add offline mode tracking:
    * Enables tracking, logging, and generating all assets, events and logs.
    * Passes through all API calls and generates corresponding run manifest as a JSON blob.
    * Enables visualizing offline runs in notebooks.
    * Exposes methods to sync the runs to the metadata API and artifacts store.
  * **Enhancement**: Add `log_model_ref` to allow logging model lineages without the event files.
  * **Enhancement**: Improve debugging API related errors by providing more context about the client configuration, where information was loaded, and path to the local cache if it was used.
  * **Enhancement**: Improve and consolidate all client decorators into a single decorator to improve usage in interactive debuggers.
  * **Enhancement**: Improve manual statuses logging.
  * **Enhancement**: Simplify running and tracking several runs in the same process.
  * **Fix**: Issue with Pytorch Ignite logger.

### CLI

 * **New**: Add `ops sync [-uid] [--all] [--clean]` command to sync offline runs and upload related artifacts.
 * **New**: Add `ops ls --offline --help` command to show all current offline runs.
 * **New**: Add `ops get -uid UUID --offline --help` command to show show information about an offline runs.

### UI

 * **Enhancement**: Improve main container logs detection.
 * **Enhancement**: Change the expansion button's color to highlight the opened run in the comparison table.
 * **Enhancement**: Improve expanded datetime values in comparison table to show a string value with ISO format.
 * **Enhancement**: Improve comparison table's default columns and their initial sizes.
 * **Fix**: Issue with redundant logs requests.
 * **Fix**: Typo in some action forms.
 * **Fix**: Initial min size in visualization mode for jobs.

### Operator

 * **Enhancement**: Improve the operator's syncing logic to perform recurrent checks.
 * **Enhancement**: Always re-sync last state.
 * **Fix**: Issue with `maxConcurrentReconciles` configuration.
 * **Fix**: Regression introduced with the last change with pod's state watch, some jobs were not reporting termination correctly.

### Deployment & Setup

 * **Enhancement**: Update MPIOperator chart to the latest version.
 * **Enhancement**: Update TFJob chart to the latest version.
 * **Enhancement**: Increase API readiness probes timeout.

### House Keeping

 * **Enhancement**: Update testing requirements.
 * **Enhancement**: Update protoc version.

### Docs

 * **Enhancement**: Update types docs with init examples.
 * **Enhancement**: Add docs for enabling IDE completion and validation.
 * **Enhancement**: Add docs for runs  timeline.
 * **Enhancement**: Add quick-start for running inline scripts.
 * **Fix**: Sub-links in releases pages.

### Agent

 * **Enhancement**: Simplify deployment of replica agent by exposing a flag `agent.isReplica`.
 * **Enhancement**: Several enhancements and performance updates.

### Commercial

 * **New**: Add timeline view which shows all runs (jobs/services/matrices/dags) under a pipeline and a Gantt chart.
 * **Enhancement**: Improve updates auditor performance.
 * **Enhancement**: Add missing write actions in activity logs.
 * **Enhancement**: Add several heuristic to improve pipelines performance.
 * **Enhancement**: Automatically increase sidecar sync interval for matrix and DAG operations to reduce API calls and artifacts syncs.
 * **Enhancement**: Do not cascade default user preset/queue deletion.
 * **Enhancement**: Prefix connections lineage with agent name to distinguish same connection names used in multiple agents.
 * **Enhancement**: Send user's role with hub and model versions.
 * **Enhancement**: Hide delete buttons on model version and component version for non admin users.
 * **Enhancement**: Hide edit button on readme for viewer users in the run overview page.
 * **Enhancement**: Add warning when a user lands on a valid project under an organization they have access to but with restrictions.
 * **Enhancement**: Improve some project/component/hub level permissions.
 * **Enhancement**: Improve confusing aspects about team management, e.g. second role promotion on team level.
 * **Enhancement**: Improve spacing in analytics page.
 * **Enhancement**: Improve compilation and access error context information.
 * **Enhancement**: Improve backend monitoring.
 * **Enhancement**: Consolidate all products into a single subscription.
 * **Fix**: Issue with resuming DAG and Matrix runs.
 * **Fix**: Issue with non-managed run deletion.
