---
title: "Release notes for v1.2"
sub_link: "1-2"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-2.md"
meta_title: "Polyaxon release notes for v1.2.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.2.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.2.2

### UI

 * **Fix**: Nested matrices in runs.
 * **Fix**: Queue form not updating concurrency correctly.

### Commercial

 * **Enhancement**: Improve throttling logic to reduce incidences of operations not syncing correctly.
 * **Fix**: DAG pipeline metadata.

## v1.2.1

### CLI

 * **Enhancement**: Create projects with private visibility by default.
 * **Fix**: Default values for cache/nocache flags in CLI.

### Core

 * **Security**: Upgrade base image to remove all critical vulnerabilities.
 * **Enhancement**: Add support for initializing git repos with ssh connections.
 * **Enhancement**: Add support for initializing containers with a custom connections.
 * **Enhancement**: Add support for default mode to connection's secret/configMap schema.
 * **Enhancement**: Add `nil` operator to PQL, users can use filters to check if a field/metric/param is nil/Null/None or not nil/Null/None.
 * **Enhancement**: Allow passing null values as parameters.
 * **Enhancement**: Add initializing and processing statuses.
 * **Enhancement**: Add `iteration`, `analysis`, and `markdown` artifact types.
 * **Enhancement**: Add index for meta kind to improve search response.
 * **Enhancement**: Expose cache hit on the core compiler to allow subclassing and customizing Polyaxon Core.
 * **Enhancement**: Add operation kind to the annotations metadata.
 * **Enhancement**: Improve params `as_str` and `as_arg` modifiers.
 * **Enhancement**: Add `runtime` and `meta_info` to the run filter manager.
 * **Enhancement**: Catch additional errors during the filters parsing or querying.
 * **Enhancement**: Update boto requirements.
 * **Fix**: Issue with search condition errors not raising the correct exception.

### Operator

 * **Enhancement**: Add handling for `not found` and `404` errors to avoid rescheduling reconcile checks

### House Keeping

 * **Enhancement**: Upgrade several packages and utilities to improve linting, build, and tests.

### UI

 * **Enhancement**: Show ongoing duration field for runs not finished yet.
 * **Enhancement**: Allow users to update the finale status of a run.
 * **Enhancement**: Add meta kind/runtime kind to runs' overview and runs table.
 * **Fix**: Issue with runs comparison table breaking in loading state and full screen view.

### Commercial

 * **Enhancement**: Add initial work on pausing and resuming pipelines (hyperparameter tuning and DAGs).
 * **Enhancement**: Allow to view logs related to tuners in hyperparameter tuning.
 * **Enhancement**: Add possibility to update concurrency while a pipeline (hyperparameter tuning and DAG) is running.
 * **Enhancement**: Improve debugging of hyperparameters tuning by showing all information related to iterations, i.e. runs - metrics - configs - suggestions.
 * **Enhancement**: Allow to visualize and compare performance of runs in a specific iteration.
 * **Enhancement**: Add iteration details to runs in hyperparameters tuning.
 * **Enhancement**: Add iteration lineage kind to expose an algorithm's iterations (inputs and outputs) as lineage data,
    this, together with the tuners' logs, will help improve the debugging experience when an optimization fails or when a user tries to use a custom optimization process.
 * **Enhancement**: Improve compilation time when an operation has a cache hit.
 * **Enhancement**: Improve default cache handling, i.e. cache hit checks when the user does not define a cache:
   * Cache will be disabled automatically for independent runs created via CLI/API/UI.
   * Cache will be disabled automatically for restart/resume ops.
   * Cache will be enabled automatically for all ops triggered automatically inside a pipeline (matrix/dag).
   * Cache can be set and enabled/disabled via the cache section, in which case the default behavior is not triggered, and the user's choice is honored.
 * **Enhancement**: Improve stop for pipelines.
 * **Enhancement**: Improve deletion of projects and pipelines.
 * **Enhancement**: Add initial work to allow hyperparameter tuning workflows to seed the initial observation from previous experiments based on a API search instead of random search.
 * **Enhancement**: Consolidate all tuning algorithms to use similar config, change `numIterations` to `maxIterations`.
 * **Fix**: Runs facet when viewing a pipelines (hyperparameter tuning and DAGs).
 * **Fix**: Regression with agents not respecting and resetting the back-off logic.

## v1.2.0

### CLI

 * **Enhancement**: Add note about adding .polyaxon cache to the .gitignore .dockerignore files.
 * **Enhancement**: Add cache flag similar to nocache to allow user to override the default handling.
 * **Enhancement**: Patch git preset with pre_merge strategy instead of post_merge.
 * **Fix**: Improve context only params validation.
 * **Fix**: Improve compatibility issue errors.

### Core

 * **Security**: Update some packages with security issues.
 * **Enhancement**: Add several new filters to the run query manager.
 * **Enhancement**: Improve operation stop on delete to clean the operation before sending the stop signal.
 * **Enhancement**: Add artifacts deletion operation on run's delete.
 * **Fix**: Issue with image logging does not pass rel_path.

### UI

 * **Enhancement**: Improve UI search with quick shortcuts and flags.
 * **Enhancement**: Add dropdowns for filtering by statuses, tags, users, and queues.
 * **Enhancement**: Improve search filters update and management.
 * **Enhancement**: Improve search specification saving and reloading.
 * **Enhancement**: Add possibility to share and pass search specs via query params.
 * **Enhancement**: Add possibility to update table on search changes automatically.
 * **Enhancement**: Improve runs comparison and allow resizing grid/viz mode.
 * **Enhancement**: Improve serving and caching of assets.
 * **Enhancement**: Add runs facet on the table view.
 * **Fix**: Delete dirs paths in the artifacts tab in the UI not closing the modal dialog.
 * **Fix**: Issue with parallelcoords metrics/params field names.
 * **Fix**: Audio widget interruption.
 * **Fix**: Issue with refreshing of artifacts while using the control slider in widgets.
 * **Fix**: Styling issues in firefox.

### Operator

 * **Enhancement**: Remove default retry behavior.

### Deployment & Setup

 * **Enhancement**: Add flag to easily add pod and host IPs to the list of allowed hosts.
 * **Enhancement**: Improve usage of namespace in config maps and partials.
 * **Fix**: Internal token check.

### Docs

 * **Enhancement**: Add new guide on handling termination.

### Commercial

 * **Enhancement**: Move all cleaning and notifier operations to agents.
 * **Enhancement**: Add agent status on the agent table.
 * **Enhancement**: Redirect to user's default org instead of an empty org.
 * **Enhancement**: Add automatic compatible updates to agents.
 * **Enhancement**: Sync agent version and display it in the agents table in UI.
 * **Fix**: Regression in authZ for artifacts deletion.
