---
title: "Release notes for v1.18"
sub_link: "1-18"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-18.md"
meta_title: "Polyaxon release notes for v1.18x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.18.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## V1.18.2

### CLI

 * **Enhancement**: Improve CLI `clean-ops` with shortcuts for `--delete/-d` and `--namespace/-n`.

### UI

 * **Enhancement**: Make run's settings button visible in all tabs.
 * **Enhancement**: Make run's status beacon visible in all tabs.
 * **Enhancement**: Improve run's header and make the name and uuid visible.

### Client

 * **Fix**: Issues in some method's docstring.

## V1.18.1

### CLI

 * **Enhancement**: Ensure CLI is configured on login.

### Core

 * **Enhancement**: Use k8s sdk with support of proxy configuration.

## V1.18.0

### CLI

 * **Enhancement**: Move `clean-ops` under `admin` namespace to allow users to clean stranded operations without exporting any environment variables.
 * **Enhancement**: Extend `clean-ops` with a `--uuids/--uids` to allow filtering for specific operations to force clean/delete.
 * **Enhancement**: Improve statuses watch to refresh the table instead of drawing a new table.
 * **Enhancement**: Improve wait for condition to update the last status in place.
 * **Enhancement**: Add missing `stages` to commands `components`, `artifacts`, and `models` to list stage transitions and conditions.
 * **Enhancement**: Improve pull logic to create a valid structure `/base/path/PROJECT_NAME/runs`, `/base/path/PROJECT_NAME/models`, ...
 * **Enhancement**: Improve overall CLI behavior with better interactive spinner and upload/download progress bar.
 * **Enhancement**: Add rendering for readme section to project, run, component, model, artifact `get` commands.
 * **Enhancement**: Improve download CLI logic to show more meta data about eta and download speed.
 * **Fix**: Issue in completion command.
 * **Fix**: Issue typos in command printed help.

### Core

 * **New**: Add support for annotations and environment variables in the connection's specification.
 * **New**: Allow configuring git credential as volume secret using a git credential.helper store.
 * **Enhancement**: Add handling for more edge cases around git urls.
 * **Enhancement**: Migrate hyperparameter tuning and tracking modules to separate repos.
 * **Enhancement**: Improve query manager to return distinct values.
 * **Enhancement**: Propagate both lower case and upper case proxy env vars to all containers in an operation.

### Client

 * **Beta**: Async client version.
 * **New**: Add promote method to a model version or artifact version directly from the `RunClient`:
   * `RunClient.promote_to_model_version` this is similar to `ProjectClient.register_model_version` but directly from the run client instance.
   * `RunClient.promote_to_artifact_version` this is similar to `ProjectClient.register_artifact_version` but directly from the run client instance.
 * **New**: Add `get_runs_artifacts_lineage` to `RunClient` to allow listing artifacts lineage information from multiple runs under the same project based on a query specification.
 * **New**: Expose new sdks on the client, the new endpoints will only be accessible to users with enough permissions or it will raise 401/403 errors:
    * Allows listing and interacting with agents.
    * Allows listing and interacting with connections.
    * Allows listing projects.
    * Allows listing cross project runs.
 * **Enhancement**: Add retries configuration option.
 * **Enhancement**: Improve issues around `SSL` verification.
 * **Enhancement**: Improve download logic based on a lineage reference.
 * **Enhancement**: Improve wait for condition to be resilient to backend errors.
 * **Enhancement**: Improve client decorator to handle inline configurations in addition to the global settings.

### Operator

 * **Enhancement**: Update training operator to use the newest Kubeflow release.

### Query Language

 * **New**: Allow filtering by connections:
    * By name `connections.name: CONNECTION1 | CONNECTION2`
    * By tag `connections.tags: TAG1 | TAG2`
    * By kind `connections.kind: git`
 * **New**: Allow filtering by artifacts lineage:
    * By name `artifacts.name: LINEAGE1 | LINEAGE2`
    * By kind `artifacts.kind: model`
    * By path `artifacts.path: foo/bar`
    * By state `artifacts.state: STATE`

### Tracking

 * **Enhancement**: Improve scikit-learn classifier tracking.

### Streams

 * **Enhancement**: Improve cache access and optimize artifacts downloads.
 * **Enhancement**: Improve k8s connections and handling.
 * **Enhancement**: Update fs backends.

### UI

 * **New**: Add operation status color indicator to the page's favicon.
 * **New**: Allow selecting the (dark/light) themes in Polyaxon CE.
 * **New**: Allow showing the order in the runs table.
 * **New**: Auto-showing columns with diff.
 * **New**: Auto-showing columns with high variance.
 * **New**: Allow transposing the runs table (by column) to a vertical comparison (by run).
 * **New**: Improve runs table with comparison features natively.
 * **Enhancement**: Simplify themes selection without going to the user profile.
 * **Enhancement**: Update the queues table with a link next to each queue to filter all runs by a specific queue.
 * **Enhancement**: Update the connections table with a link next to each connection to filter all runs by a specific connection.
 * **Enhancement**: Show artifact' state on the lineage tables.
 * **Enhancement**: Keep the configuration of logs, artifacts, and dashboards tabs unchanged when changing tabs of the same run.
 * **Enhancement**: Improve queues usage to remove `.0` in the denominator.
 * **Enhancement**: Improve datetime fields expansion behavior.
 * **Enhancement**: Consolidate Tensorboard actions in the run's dropdown.
 * **Enhancement**: Add Tensorboard action to the runs multi-action button on the table similar to the overview page.
 * **Enhancement**: Optimize screen size for runs table.
 * **Enhancement**: Add a spinner while the UI loads the assets for rendering.
 * **Fix**: Typo in tip for registering component/model/artifact versions.
 * **Fix**: Regression in multi-run scatter plot.
 * **Fix**: Issue with table filter popovers and actions popovers scrolling with pages.
 * **Fix**: Issues in Markdown editor.
 * **Fix**: Issues with resume button not updating the status in of the run in the overview page.

### Hub

 * **New**: Extend the component versions for Tensorboard with a new `plugins` input of type `List[str]` to allow users to install custom plugins.
 * **New**: Extend the component versions for Tensorboard with possibility to use the run names instead of uuids to initialize the paths.

### Docs

 * **Enhancement**: Improve navigation and provide short-cuts.
 * **Enhancement**: Improve `ProjectClient` and `RunClient` reference docs.
 * **Enhancement**: Add new intro tutorial about registering components, models, and artifacts.
 * **Fix**: Edit links to point to the correct code files.

### Deployment

 * **Security**: Fix CVE issues.
 * **Enhancement**: Improve streams deployment to limit the number of workers per core.
 * **Enhancement**: Reduce sql-proxy's logs verbosity.

### Commercial

 * **New**: Add support for readme on component/model/artifact versions.
 * **New**: Allow getting a connection's schema by name.
 * **Enhancement**: Improve operations in DAGs with pending approval and upstream failures.
 * **Enhancement**: Reduce member roles confusion:
   * Add a note to `admin` to emphasize that is a `Project admin`.
   * Add a note to `manager` to emphasize that is a `Organization admin`.
 * **Enhancement**: Improve compilation process to better handle converting artifact lineage, model, and artifact versions references.
