---
title: "Release notes for v1.17"
sub_link: "1-17"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-17.md"
meta_title: "Polyaxon release notes for v1.17.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.17.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## V1.17.3

> **Note**: CLI and Client only release.

### Tracking

 * **Enhancement**: Improve `log_artifact` and `log_model` to correctly log the directory path or the file path.
 * **Enhancement**: Add support for new pytorch-lightning versions and fix issue with [log_hyperparams](https://github.com/PyTorchLightning/pytorch-lightning/commit/115a5d08e8b868109a424af213bd7f23537654f1).

### Commercial

 * **Fix**: Issue with resolving full paths of artifacts edges.
 * **Fix**: Issue with members not able to update/patch dashboards and searches.

## V1.17.2

> **Note**: CLI and Client only release.

### CLI

 * **Enhancement**: Expose `--reason` flag to the stage commands to allow to signal custom reasons for the stage changes:
   * `polyaxon components / models /artifacts -p PROJECT -ver v1 stage -to PRODUCTION --reason GithubAction --message "Automated process, be careful!"`

### Client

 * **Enhancement**: Deconstruct stage condition into params in the `stage_version` methods to simplify programmatic stage changes.
 * **Enhancement**: Allow passing a serialized object or a dict and automatically handle serialization in `register_version` methods to simplify passing meta/content value.

### Docs

 * **Enhancement**: Add client snippets to component hub, model registry, and artifacts versioning to perform various actions.

## V1.17.1

### Agent

 * **Fix**: Regression related to default image pull policy and the new Kubernetes client validation process.

### CLI

 * **New**: Extract model/artifact/component versions CLI logic to callable utility functions to be used programmatically.
 * **New**: Consolidate usage of `--path` and `--path-to` in all commands.

### Client

 * **New**: Expose per kind methods to create, register, patch, pull, transfer, and copy component / model / artifact versions.

### Core

 * **Deprecation**: Remove deprecated storage clients.
 * **Enhancement**: Preserve tags order during validation and uniqueness checks.

### Initializer

 * **Enhancement**: Improve git initializer to report warning when the git clone fails.

### Tracking

 * **Enhancement**: Improve confusion matrix tracking.

### UI

 * **Enhancement**: Maintain order of metrics and params in which they were entered in the chart/graph widgets.
 * **Enhancement**: Add bitbucket connection icon.
 * **Fix**: Issues with Bokeh charts logged with newer library versions.

### Docs

 * **Enhancement**: Add a new `Tracking Metadata & Assets` section in tracking.
 * **Enhancement**: Add a new `Query Metadata and Artifacts` intro tutorial using client, CLI, and UI.
 * **Enhancement**: Add a new `Packging and Pulling a Run` intro tutorial.
 * **Enhancement**: Improve and consolidate Python client, tracking, and CLI sections.

## V1.17.0

### CLI

 * **New**: Add `polyaxon models pull` command to package the full model's metadata, definition, lineage, and assets to a local path.
 * **New**: Add `polyaxon artifacts pull` command to package the full artifact's metadata, definition, lineage, and assets to a local path.
 * **New**: Add `polyaxon ops pull` command to package the full operation's metadata, definition, lineage, and artifacts to a local path.
 * **New**: Add `polyaxon ops push` command to push and sync a local/offline operation's metadata, definition, lineage, and artifacts to a remote server.
 * **Enhancement**: Extend artifacts command with `-l-name/--lineage-name` to `polyaxon ops artifacts --lineage-name artifact-ref1 --lineage-name artifact-ref2` to downland assets based on a lineage reference name.
 * **Enhancement**: Extend artifacts command with `-l-kind/--lineage-kind` to `polyaxon ops artifacts --lineage-kind image` to downland assets based on a lineage reference kind.
 * **Enhancement**: Extend artifacts command with `-f/--file` to `polyaxon ops artifacts -f path/to/file1 -f other/path/to/file2` to accept downloading multiple file paths at once.
 * **Enhancement**: Extend artifacts command with `-d/--dir` to `polyaxon ops artifacts -d path/to/dir1 -d other/path/to/dir2` to accept downloading multiple file paths at once.
 * **Enhancement**: Improve errors message for commands not available in CE.
 * **Enhancement**: Improve `status` column when producing a CSV file  with `polyaxon ops ls ... --to-csv`.

### Core

 * **Deprecation**: Remove usage of deprecated Kubernetes API.
 * **Enhancement**: Improve API uuid serialization for related fields to always return hex format.

### Client

  * **Deprecation**: Removed `versioned` from `log_model` and `log_artifact`, by default these methods will not trigger the versioning behavior unless a step is provided.
  * **New**: Add artifacts lineage `get` method to load lineage information for a run `RunClient.get_artifacts_lineage`.
  * **New**: Add `load_artifacts_lineage` and `load_conditions` flags to `RunClient.refresh_data`.
  * **New**: Add artifacts download based on a lineage reference `RunClient.download_artifact_for_lineage`.
  * **New**: Add project version pull method `ProjectClient.pull_version` to package/download a model version, artifact version, or a component version to a local path.
  * **New**: Improve upload errors when no files are detected or passed.

### Tracking

  * **New**: Add new XGboost callback style.
  * **Enhancement**: Improve Plotly converter for matplotlib version >=3.3.0.
  * **Enhancement**: Improve logging matplotlib as Plotly to fallback to image if plotly fails.
  * **Enhancement**: Improve hash calculation and tracking.
  * **Enhancement**: Improve path validation, calculation, and tracking.
  * **Enhancement**: Improve artifacts summary calculation.
  * **Enhancement**: Improve getting store path.

### Specification

  * **New**: Add `lineageRef` initializer to allow downloading artifacts based on the lineage reference.
  * **New**: Add `init.paths` to simplify initializing artifacts based on paths without specifying files or dirs.

### UI

  * **Enhancement**: Move run's lineage information directly as a section under the info tab.
  * **Enhancement**: Improve datetime range widget.
  * **Enhancement**: Improve download buttons and download filenames in the lineage tables and in the artifacts tab.
  * **Enhancement**: Several UI Improvements.

### Docs

  * **Enhancement**: Add project version query specification.
  * **Enhancement**: Add artifact lineage query specification.

### Commercial

  * **Enhancement**: Improve compiler's error message when a restriction is configured or a missing connection is detected.
  * **Enhancement**: Add logic to delete runs not assigned to any agent or failed during compilation
  * **Enhancement**: Add missing `stage` to the project version query manager.
  * **Fix**: Issue related to switching organization context for users belonging to multiple organizations.
  * **Fix**: Issue related to fetching empty suggestions.
