---
title: "Release notes for v1.15"
sub_link: "1-15"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-15.md"
meta_title: "Polyaxon release notes for v1.15.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.15.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## V1.15.0

### Deployment

 * **New**: Add support for corporate proxies, new `proxy: {}` section was added, e.g:
  ```yaml
  proxy:
    enabled: false
    useInOps: true
    httpProxy: "12.12.12.12:8080"
    httpsProxy: "12.12.12.12:8080"
    noProxy: "12.12.12.12:8080"
    host: "12.12.12.12"
    port: 8080
    kind: transparent or connect
  ```
 * **Security**: Fix critical vulnerabilities.

### Core

 * **Enhancement**: Improve compiler failure message due to sampling errors.
 * **Enhancement**: Improve default ignore manager with common python ignore patterns.
 * **Enhancement**: improve df processing.

### UI

 * **Enhancement**: Update roadmap link in UI.
 * **Enhancement**: Do not minimize new sections when loading all events for a specific kind.
 * **Fix**: Issue in the table search suggestions.
 * **Fix**: Issue in copying query configuration button.

### CLI

 * **Enhancement**: Improve `project ls`.
 * **Enhancement**: Do not purge config when not changing the host value.
 * **Enhancement**: Improve `-o json` with the run url.
 * **Fix**: Issue with `-o json`.
 * **Fix**: `artifacts` and `models` docstrings.

### Docs

 * **Enhancement**: Update ingress documentation for GKE.
 * **Fix**: Wrong documentation for using the artifacts init section.

### Commercial

 * **New**: Add global search `cmd + /` or `ctrl + /`, a single global search field to provide easy access to:
   * Projects
   * Models
   * Components
   * Connections
   * Operations
 * **New**: Provide user's history (recently viewed items) with search.
 * **Enhancement**: Only show the list of projects accessible to users in organizations with restrictions.
 * **Enhancement**: Improve settings page for projects declared as registry or hub.
 * **Enhancement**: Allow promoting model/artifact versions on different projects directly from the run overview or runs table.
 * **Enhancement**: Improve transferring of artifact/model versions.
 * **Enhancement**: Improve agent sync process.
