---
title: "Release notes for v1.13"
sub_link: "1-13"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-13.md"
meta_title: "Polyaxon release notes for v1.13.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.13.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.13.0

### Deployment & Setup

 * **Enhancement**: Drop `ClusterRoleBinding` for single namespace deployments and use `RoleBinding` instead.
 * **Enhancement**: Openshift ready deployment strategy.
 * **Enhancement**: Tighten security of all containers:
   * Drop root by default even without security context enabled.
   * Reconfigure all containers to use the port 8000 instead 80.
   * Add support for pod and container security context (uid, gid, fs, change policy, privilege escalation, non root)
 * **Enhancement**: Use standard security context keys (user -> runAsUser, group -> runAsGroup).

### CLI

 * **New**: Add missing commands for setting/updating the stage of a component/model version.
 * **New**: Add new `-HP` to simplify passing hyper-params similar to `-P`.
 * **Enhancement**: Improve `admin upgrade` command to show more information.
 * **Enhancement**: Error handling and debug instructions.
 * **Fix**: Project update command.

### Core

 * **Fix**: Issues with ignore manager not handling relative paths in some circumstances.

### Tracking

 * **New**: Add support for tracking and auto-syncing local experiments.
 * **New**: Add hugging face logger.
 * **New**: Add confusion matrix tracking.
 * **Enhancement**: Improve several callbacks.
 * **Enhancement**: Improve system tracking.
 * **Enhancement**: Improve `NO_OP` flag.

### UI

 * **New**: Allow setting a column color saturation based on a metric's or a param's trend (increasing/decreasing).
 * **New**: Add per queue usage stats (warning, running, pending) in the queues table.
 * **Enhancement**: Improve timeline view.
 * **Enhancement**: Improve graph view.
 * **Enhancement**: Make artifacts paths and opened files durable using URL query params.
 * **Enhancement**: Make logs search, filters, and options durable using URL query params.
 * **Enhancement**: Add pagination to the resources tab to not load/display all events at the same time.
 * **Enhancement**: Do not show `restart` and `resume` buttons for manually managed runs.
 * **Enhancement**: Show `No actions available` in the dropdown for users with no access rights on specific runs instead of an empty dropdown.
 * **Enhancement**: Do not show delete button on artifacts for users with the viewer role.
 * **Enhancement**: Minimize pagination when the user resizes the table below the minimum required width.
 * **Enhancement**: Do not show suggestions when a run is displayed in flyout mode.
 * **Enhancement**: Merge layout selector and sections selector in a single dropdown.
 * **Enhancement**: Merge generic statuses flags and statuses filters in a single statuses dropdown.
 * **Fix**: Project filter should default to name instead of uuid.
 * **Fix**: Container images in the run inspection page.

### Docs

 * **Enhancement**: Update some old guides and screenshots.
 * **Enhancement**: Add advanced restrictions guide.

### Operator

 * **New**: Add Distributed MXNetJob integration.
 * **New**: Add Distributed XGBoostJob integration.
 * **Enhancement**: Upgrade go version.
 * **Enhancement**: Upgrade controller-runtime.
 * **Enhancement**: Upgrade kubebuiler version.
 * **Enhancement**: Add scheduling policy for Kubeflow distributed jobs.
 * **Enhancement**: Improve distributed jobs reconciliation.
 * **Enhancement**: Deprecate the individual Kubeflow operators in favor of the training operator.

### Commercial

 * **New**: Add possibility to create service accounts to issue org tokens for CI(Continuous Integration)/CD(Continuous Delivery)/CT(Continuous Training).
   * Service accounts are not tied to a specific user and do not use any user's API tokens.
   * Each service account can have one or multiple tokens with different expiration configuration.
   * Each token can be refreshed, regenerated or deleted.
   * All activities generated by the tokens will link back to the service account they belong to in the activity logs or the runs table.
 * **New**: Add possibility to buy read-only seats, with fixed viewer role, to allow org owners to invite other team users to view reports and explore ML Apps, notebooks, ... in read-only mode.
 * **Enhancement**: Allow admins to create presets.
 * **Enhancement**: Improve hyperparameter tuning algorithms.
