---
title: "Release notes for v1.11"
sub_link: "1-11"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-11.md"
meta_title: "Polyaxon release notes for v1.11.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.11.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.11.3

### Sidecar

 * **Fix**: Regression in syncing related runs correctly.

### Core

 * **Enhancement**: Improve artifacts store backends.
 * **Enhancement**: Improve dockerfile init type:
   * Allow copying to custom destination.
   * Add `postRunCopy` to allow adding copy commands after the run commands to leverage the cache.
   * Add `username` to allow customizing the default `polyaxon` username with uid/gid.
 * **Enhancement**: Improve context templating in file init.
 * **Fix**: Regression in lineage/artifacts APIs' pagination logic not returning all information required for creating dashboards and selecting scalar events.

### UI

 * **Enhancement**: Show `dashboards` tab on runs with `service` kind.
 * **Fix**: Issue with confirmation modal dialogs not closing correctly after artifacts deletion.
 * **Fix**: Issue with jumping cells in the table comparison on click events.
 * **Fix**: Y-Axis in analytics graphs.
 * **Fix**: Issue with dashboards loaded from URLs showing wrong inconsistent height/columns in sections.
 * **Fix**: Regression that prevents changing colors or hiding runs when both the comparison table and events dashboard are both enabled.
 * **Fix**: Typos.

### Commercial

 * **Fix**: Issue raised when restarting an operation with copy mode and a reference to a private component.

## v1.11.2

### CLI

 * **Enhancement**: Add CLI flag to trigger human in the loop validation without changing the polyaxonfile, `polyaxon run --approved=y/yes/t/true/1` or `polyaxon run --approved=n/no/f/false/0`.

### Specification

 * **Enhancement**: Add `globals.is_independent` to the context to allow users to detect if a component is running independently or in the context of a pipeline.

### UI

 * **Enhancement**: Add load all events for a specific artifacts type in dashboards.
 * **Enhancement**: Improve dashboard section's dropdown with more informative icons.
 * **Enhancement**: Optimize multi-run events fetching logic.
 * **Enhancement**: Improve table comparison memoization and rendering speed.
 * **Fix**: Regression in statuses error message not applying whitespace pre-wrap in code lines.
 * **Fix**: Regression in visualizations' zoom logic.
 * **Fix**: Regression in additional horizontal scroll in run's info page.
 * **Fix**: Issue with graph view rendering on Safari.
 * **Fix**: Issue with force reloading logs.
 * **Fix**: Issue with lost focus in selections.

### Docs

 * **Enhancement**: Improve contexts docs with recurrent use-cases, e.g. exposing the dag uuid.

### Deployment & Setup

 * **Fix**: Regression when deploying with offline mode.

### Commercial

 * **Enhancement**: Improve resending expired invitations.
 * **Fix**: Regression in hyperopt tuner.

## v1.11.1

### CLI

 * **Fix**: Help text typos.

### UI

 * **New**: Add scatter plot type to single runs.
 * **Enhancement**: Optimize resizing of widgets.
 * **Enhancement**: Auto-generate names for charts/widgets by default, and allow users to set a custom name as an option.
 * **Enhancement**: Add xaxis label to scatter plots.
 * **Enhancement**: Add third dimension (color) to scatter plots.
 * **Enhancement**: Allow turning line charts to area charts.
 * **Enhancement**: Allow turning line charts to stacked charts.
 * **Enhancement**: Improve line charts markers to show lines only, points only, and lines + points.
 * **Enhancement**: Improve graph view rendering speed.
 * **Enhancement**: Improve contour and parallel plots.
 * **Enhancement**: Add orientation for bar chart (horizontal/vertical).
 * **Enhancement**: Add possibility to stack bar chart in comparison mode.
 * **Enhancement**: Improve bar chart legends and grouping in comparison mode.
 * **Enhancement**: allow using mean, median, min, max aggregation in bar plots in addition to last values.
 * **Enhancement**: Allow turning bar charts to box plots or violin charts.
 * **Enhancement**: Add shortcuts menu on hover to bar charts.
 * **Enhancement**: Break widget forms into multiple sections to simplify configuring charts and artifacts viewer.
 * **Enhancement**: Change the default x-axis logic:
   * Use wall time in single run line charts.
   * Use relative time in multi-run comparison line charts.
 * **Enhancement**: Enable automatic updates in the comparison table by default.
 * **Enhancement**: Improve analytics, actions, calendar, trends, and visualization icons.
 * **Enhancement**: Remove sections' form in favor of an inline compressed form per section.
 * **Enhancement**: Add collapse all sections to the dashboard management.
 * **Enhancement**: Add search bar to dashboard to filter widgets.
 * **Enhancement**: Allow configuring additional tooltip information for line charts, curve charts, and scatter charts.
 * **Enhancement**: Move section and widget control into a dropdown.
 * **Enhancement**: Add cloning widgets, adding sections above and below other sections.
 * **Enhancement**: Add dashboard section pagination.
 * **Enhancement**: Improve bokeh rendering and resizing.
 * **Fix**: Regression in memoization of dashboards impacting performance.
 * **Fix**: Regression in run's inputs/outputs table search bar.
 * **Fix**: Regression in the histogram chart under analytics.
 * **Fix**: Regression in Tensorboard icon being cut in Firefox.
 * **Security**: Remove critical vulnerabilities.

## v1.11.0

### Agent

 * **Enhancement**: Several important changes based on Polyaxon core.

### Core

 * **Enhancement**: Always sanitize the artifacts connection's base path.
 * **Enhancement**: Improve file store and file watcher logic.
 * **Enhancement**: Speedup S3 artifacts store backend.
 * **Enhancement**: Improve Polyaxon on Azure.
 * **Enhancement**: Speedup Azure artifacts store backend and add handling for file system variant `wasb`/`azfs`/`abfs`/`https`.
 * **Enhancement**: Avoid re-uploading initialized paths in init containers or from the auto-resume behavior.
 * **Enhancement**: Automatically detect dockerfile kind in file init.
 * **Enhancement**: Add namespace filter.

### Streams

 * **Enhancement**: Improve assets fetching concurrency and blocking behavior.
 * **Enhancement**: Improve events APIs performance using async storage clients.
 * **Enhancement**: Improve streams cache access and logic.
 * **Enhancement**: Improve logs streaming API.

### Sidecar

 * **Enhancement**: Improve sidecar files watcher.
 * **Enhancement**: Improve sidecar sync logic to handle deletion.
 * **Enhancement**: Improve sidecar to reuse clients' connections.

### UI

 * **New**: Add search suggestions in the query editor.
 * **New**: Full inspection of the operation state in the status page.
 * **New**: (Beta) Add new shell tab to enable a smoother debugging experience:
    * Allow users to attach directly to their running containers without distributing kubeconfig.
    * Only users with access rights can see and start a terminal.
    * The tab is available for jobs and services.
 * **Enhancement**: Improve the visualization experience:
    * Add new tooltips options.
    * Allow hiding legends.
    * Allow controlling legends' position.
 * **Enhancement**: Virtualize code-blocks in the artifacts tab to speedup rendering of large text-based artifacts.
 * **Enhancement**: Virtualize cell rendering to speedup rendering of the comparison table with large number of columns and rows.
 * **Enhancement**: Virtualize logs viewer rendering.
 * **Enhancement**: Remove expansion behavior in logs viewer and provide horizontal scrolling for long log lines.
 * **Enhancement**: Enable auto-scroll behavior and remove pagination in the logs viewer.
 * **Enhancement**: Improve logs download logic.
 * **Enhancement**: Add highlighting to log lines with errors or warnings.
 * **Enhancement**: Add logs search matches facet and highlighting.
 * **Enhancement**: Improve search in logs with regex and case sensitivity capabilities.
 * **Enhancement**: Adjust height of the logs and polyaxonfile in full and flyout mode to remove multiple scroll-bars.
 * **Enhancement**: Improve speed, size, positioning, and icons.
 * **Enhancement**: Improve empty dashboard and empty sections.
 * **Enhancement**: Improve charts and widgets in fullscreen modal.
 * **Enhancement**: Improve sections resizing.
 * **Enhancement**: Allow more granular control of the section's height and width.
 * **Enhancement**: Improve the default dashboard with a section for each event detected.
 * **Enhancement**: Improve charts and widgets to adjust on section resize.
 * **Enhancement**: Update refresh button to trigger re-fetching of widgets and charts latest events and artifacts in addition to metadata information.
 * **Enhancement**: Improve spacing between dashboard sections.
 * **Enhancement**: Remove deprecated modules.
 * **Fix**: Regression in the sorting indicator for datetime fields.
 * **Fix**: Datetime columns not adjusting correctly to text density in the comparision table.
 * **Fix**: Empty state for the connections lineage tab.
 * **Fix**: Comparison table schema detection when a field is categorized as string/numeric and might include an object/array in some runs.

### Hub

 * **Fix**: Issue with artifacts store usage in Tensorboard component does not handle trailing slashes gracefully.

### House Keeping

 * **Enhancement**: Upgrade packages with CVE issues and known bugs.

### Commercial

 * **Enhancement**: Add price changes review on the billing page before confirmation.
 * **Enhancement**: simplify filtering by k8s resources format, e.g. 8Gi, currently the query manager requires float values.
