---
title: "Release notes for v1.1"
sub_link: "1-1"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/1-1.md"
meta_title: "Polyaxon release notes for v1.1.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v1.1.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v1.1.9.post1

## Core

 * **Fix**: Regression introduced with the store initializer path namespace, the change was applied also to the default artifacts store.
 * **Fix**: Regression introduced with the converter requested connections, it starts ignoring volumes requested by connections in auxiliary containers.

## v1.1.9

### CLI

 * **New**: Add handling for templates.
 * **New**: Add handling for presets and patch strategies while with the override behavior `-f`.
 * **New**: Add `--git-preset` and `--git-revision` to enable integration and injection of git presets before submitting an operation:
   * `--git-preset` is a flag to enable automatic injection of a git initializer as a preset using the initialized git connection.
   * If `--git-revision` is provided, Polyaxon will use it as a git revision instead of trying to detected and use the latest commit.
     The git revision could be a commit, a branch, or any valid tree-ish.
   * **Note 1**: In order to use this flag, you need to run first `polyaxon init [--git-connection] [--git-url]` and follow the wizard to initialize
     the current workdir with information about the git repo or the git connection to inject automatically in your operations.
   * **Note 2**: Polyaxon CLI will patch the operation with `post_merge` strategy, i.e. it will set/append the git repo initializer to the init definition in the specification.
   * **Note 3**: We recommend using a cheap branch, e.g. `dev`, `experimentation`, or `plx` to allow granular commits, and only merge back to master/main branch when the code is running as expected.
 * **New**: `--ignore-template` flag that allows to ignore template validation in polyaxonfile with template section, and submit the specification to be checked by the platform.
 * **Enhancement**: Add new `--cache-only` flag to `polyaxon config purge` command to allow purging cache configs and preserve CLI and Client configurations.
 * **Enhancement**: Improve commands common arguments and options, and deprecate group arguments.
 * **Enhancement**: Introduce better deprecation handling for specifications.
 * **Enhancement**: Add command help to errors.
 * **Enhancement**: Improve version logging.
 * **Fix**: CLI restart/resume commands to only accept presets.
 * **Fix**: CLI hub get command.
 * **Fix**: CLI context not preserved between run and logs/watch commands.

### Specification

 * **New**: Add template section to provide a simple way to extend errors raised by the CLI/API and prevent submission of incomplete specifications.
 * **New**: Add patch strategies to provide consistent behavior in the CLI, the compiler, and runPatch section:
    * `replace`: to replace all keys with new ones
    * `isnull`: to set new keys only if the key on the main operation is a null value.
    * `post_merge`: to set old and new keys by performing deep update where new values have priority. (default behavior to keep compatibility with previous CLI behavior)
    * `pre_merge`: to set old and new keys by performing deep update where old values have priority.
 * **New**: Add `isPreset` flag to disable validation on required field on the operation specification.
 * **New**: Users can provide `arg_format` for the inputs/outputs, the behavior only inject the representation if the value is not null.
    * `arg_format` is optional, the default behavior is inject the value provided with the parameter.
    * This new key is useful if you want to avoid having empty arguments e.g. `--arg-example=`, by providing the `arg_format: --arg-example={{PARAM_NAME}}`,
      Polyaxon will resolve the representation and inject it in the specification only if the value is not `None` and if the user uses `{params.PARAM_NAME.as_arg}`.
 * **Deprecation**: The modifier `{{params.PARAM_NAME.as_arg}}` the `{{PARAM_NAME}}` will resolve to the param's value instead.

### Core

 * **Enhancement**: Improve parameter types that depend on a connection:
    * these types were used in the init section and were absorbing errors and validation when a connection is provided with bad indentation.
    * there's a new connection and init section in the Param specification to signal to the compiler that a param requests a connection or if it should be injected as an init automatically.
 * **Enhancement**: Update azure storage and google cloud storage dependencies.
 * **Enhancement**: Add better error handling for uploading and syncing logs .
 * **Enhancement**: Restart/Resume/Copy commands accept a full operation preset and show better validation errors.
 * **Enhancement**: Add warning to tracking module when the event logger is not configured correctly.
 * **Enhancement**: Allow to set tags on connections.
 * **Fix**: Raise `404` on status saving if the run's record is deleted from the database:
    * This was preventing the operator from deleting the resource from the cluster when used with a scheduler in CE.
    * The Operator was making unnecessary API calls to EE during the reconciliation loop.
 * **Fix**: Regression in compatibility checks introduced with the minimum interval validation, the infinite value `-1` was ignored.
 * **Fix**: Converter issue with mounting all connections instead of the requested ones only.
 * **Fix**: Issue with artifacts initializer using the root context path instead of a connection specific path

### Tracking

 * **New**: Fastai v2 callback.
 * **Enhancement**: Patch ignite logger to use the new tracking module.
 * **Enhancement**: Add handling for torch tensor in metric collector.
 * **Fix**: Issue that was introduced by the default `flash_seconds=120` which caused delayed syncing of lineage information.

## UI

 * **Enhancement**: Change the behavior of native dashboards to add new widgets/charts first instead adding them last, which should avoid unnecessary scrolling.
 * **Enhancement**: Improve archives page.
 * **Enhancement**: Show icon on both tabs and sidebar for consistency.
 * **Enhancement**: Add resume/restart preset validation.
 * **Enhancement**: Implement closing modal on outside clicks for all modals for consistency.
 * **Enhancement**: Add handling for Yaml validation in Polyaxonfile UI editors.
 * **Enhancement**: Improve color initial state and selection.
 * **Fix**: Remove unused visibility configuration from project creation and settings in Polyaxon CE.

### Hub

 * **Fix**: Streamlit component.
 * **Deprecation**: The `image` type does not accept a connection anymore, it only accepts the destination value as string, see the enhancement in the core section;
    * The `:latest` tag for `Kaniko` and `Dockerizer` will be pointing to the new version, we recommend that users using Polyaxon `<= v1.8` to use the tag `:v1.1`,
      `:latest` will be using the new type starting from `v1.2`.

### Deployment & Setup

 * **Enhancement**: Reduce initial delay to 60 instead of 120.
 * **Enhancement**: Improve deployment and occasional timeout due to the size of the chart.
 * **Enhancement**: Add skipCRD to Kubeflow charts.
 * **Enhancement**: Add namespace to all manifests.
 * **Enhancement**: Add validation for connection uniqueness to prevent wrong deployment configurations.
 * **Fix**: Flower deployment using deprecated api version.
 * **Fix**: MPIJob chart and add missing SA rules.
 * **Fix**: Issues with environment and config map that was not injected in the scheduler and was required for the CE deployment.

### Docs

 * **Enhancement**: Move concepts and quick-start guides to intro section, and reserve core for documentation and specification of core tools.
 * **Enhancement**: Add new guide on iterating with CLI.
 * **Enhancement**: Add docs about using presets in Polyaxon CE.
 * **Enhancement**: Add docs about using using resume and restart behaviors and presets.
 * **Enhancement**: Add guide about deploying a model and creating an interactive ML app as an internal tool.
 * **New**: Add section about how to create and host streamlit apps.
 * **Fix**: Several issues.
 * **Fix**: Dockerfile type docs

### Commercial

 * **Enhancement**: Log the agent's statuses transition with info level.
 * **Enhancement**: Improve cache hit detection in the scheduler.
 * **Enhancement**: Add proper viewer role to avoid repetitive customization.
 * **Enhancement**: Remove some stale configurations and environment subscriptions.
 * **Enhancement**: Improve some email formatting issues.
 * **Enhancement**: Improve archive/delete/restore logic.
 * **Enhancement**: Allow to pass more than one saved preset.
 * **Fix**: Usage of `public_only` access for team outsiders.

## v1.1.8

### Operator

 * **Enhancement**: Log warning issues related to manifest's validation on creation and save warning status condition with details.
 * **Enhancement**: Reduce CRD size.

### CLI

 * **Beta**: Add `--eager` flag to start a hyperparameter tuning or a mapping in eager mode.
   * This mode requires `polyaxon[numpy]` to be installed with the CLI.
   * This mode does not provide concurrency management.
   * Make sure to use proper node scheduling to leverage Kubernetes' default scheduler.
 * **New**: Add `--to-csv` flag to `polyaxon ops ls` command to download the results as a CSV file.
   * Simple example `polyaxon ops ls -io --to-csv --limit=1000`
   * Example with query, sort, restricting the columns, offset, ...: `polyaxon ops ls -io -c finished_at,run_time,status,learning_rate,loss,accuracy -q "status:succeeded" -s loss -l 2000 --offset=1000 --to-csv`
 * **New**: `polyaxon run -l` and `polyaxon ops logs` will show logs from the main container by default.
   * `polyaxon ops logs --all-containers` to show logs from all containers.
   * `polyaxon ops logs --all-info` to show logs from all containers as well as the container names, pod names, and the node names.
 * **Enhancement**: Replace defaults by proper handling of server installation.
 * **Enhancement**: Raise error for commands not available in a distribution instead of failing silently.
 * **Enhancement**: Improve cli config reset/purge process.


### Specification

 * **Beta**: Introduce Grid Search, Random Search, and Parallel Mapping in eager mode.
 * **New**: Add copy mode to restart behavior.
 * **New**: Organize `Action`, `Events`, and `Hooks` on the same levels in the `Operation` spec.
 * **New**: Add cloning kind and original uuid to the contexts if a run is copied or restarted.

### Core

 * **Enhancement**: Show better error message when the user tries to submit a non available runtime instead of raising an exception.
 * **Enhancement**: Remove `get_model_path` which was misleading, users can use the `log_model` function if they want to let Polyaxon handle organizing assets or they can store the model themselves.
 * **Enhancement**: Improve `hooks` with a `runPatch` section to allow modifying the default run configuration, resources, ...
 * **Enhancement**: Set lower timeout to compatibility check API.
 * **Enhancement**: Improve some core errors formatting.
 * **Enhancement**: Improve values sanitizing and parsing of parameters.
 * **Deprecation**: The section `plugins.notifications` will be deprecated in favor of `hooks`.
 * **Deprecation**: `POLYAXON_API_HOST` was renamed to `POLYAXON_HOST` for consistency, `POLYAXON_API_HOST` will be dropped completely post v1.2.
 * **Fix**: Issue in summaries with events without step information.
 * **Fix**: Issue in logging; usage of `%s` and `format`.
 * **Fix**: Issue in sidecar logging causing an error.
 * **Fix**: Regression with S3 service using false as default flag for syncing, it was true before.
 * **Fix**: S3Service logging behavior generating spammy logs.
 * **Fix**: S3/GCS/WASB type schema's string representation.

### UI

 * **New**: Add possibility to copy the full path of an artifact in the artifacts tab.
 * **New**: Add breadcrumbs to show the current dir/path in the artifacts tab.
 * **New**: Add possibility to delete files and subpaths in the artifacts tab.
 * **New**: Add possibility to toggle log scale for line charts.
 * **New**: Add download button to all artifact types in the lineage tab.
 * **New**: Add flag to show/hide logs from auxiliary containers, default behavior is to show the main container's logs only.
 * **Enhancement**: Update UI editors to use tabs with 2 spaces by default.
 * **Enhancement**: Disable logs full screen button in flyout mode.
 * **Enhancement**: Improve table comparison performance by avoiding cell rerendering on pagination and other minor changes.
 * **Enhancement**: Open in full view mode will open in the same tab instead of defaulting to the info tab.
 * **Enhancement**: Hide empty resources section in the overview tab.
 * **Fix**: Issue with the dropdown component's hidden options that became unclickable,
    the issue appeared after upgrading Formik in v1.1.5 which start interfering with the dropdown focus context.

### Deployment & Setup

 * **Enhancement**: Improve scaffolding and improve build process.
 * **Enhancement**: Upgrade all python based containers to use `python:3.8`.
    * N.B.1 this change does not affect users' containers, only Polyaxon containers; e.g. init, sidecar, events, ...
    * N.B.2 CI for python:3.8 has been running for over two months.
 * **Enhancement**: Move metrics external service's options to the secrets section.
 * **Enhancement**: Allow to deploy redis for non broker functions, a `nonBroker` is required to disable the validation.
 * **Enhancement**: Add email from option to deploy manager.
 * **Enhancement**: Rename all instances of `POLYAXON_API_HOST` to `POLYAXON_HOST` for consistency.
 * **Enhancement**: Upgrade Redis chart dependency to use the bitnami repo as part of the [Helm Hub deprecation timeline](https://github.com/helm/charts#deprecation-timeline).
   * N.B. postgres and rabbitmq will be also upgraded in v1.2.
 * **Fix**: Issue with missing vendor for offline mode introduced in v1.1.7.

### Docs

 * **Enhancement**: Add container section to quick-start.
 * **Fix**: Issue in gcs integration.
 * **Fix**: Issue in quick-start iterate.
 * **Fix**: Copy/Paste typos in s3 integration.
 * **Fix**: Issue in Helm install commands to use the Helm v3 format instead of the Helm v2 format in several integrations and guides.

### Hub

 * **Enhancement**: Make `vscode` component more resilient to crashes
   * Add auto-save to outputs
   * Add auto-resume
   * Disable default telemetry behaviour
 * **Enhancement**: `tensorboard` component is now using `tensorflow/tensorflow:2.3.0` as default image for all tags.
 * **Fix**: Use the correct path type for `tensorboard:s3-path`.

### Commercial

 * **New**: Add `newrelic` as a metrics backend option.
 * **New**: Add possibility to restrict organizations for Github auth.
 * **New**: Add possibility to restrict domains for Google auth.
 * **Enhancement**: Consolidate monitoring configuration `tracing` and `metrics`.
 * **Fix**: Several issues related to email delivery.

## v1.1.7.post4

### Core

 * **Fix**: Regression introduced in store manager.

## v1.1.7.post3

### Core

 * **Enhancement**:Improve tracking module handling of filepaths, extensions and base names.
 * **Fix**: Issue with tracking `log_artifact` not handling name from path.

## v1.1.7.post2

### CLI

 * **Enhancement**: Improve CLI `ops artifacts` command with options:
   * `path`: to select a subset of artifacts to download.
   * `no-untar`: to disable the automatic untar behavior.

### Core

 * **Enhancement**: Add `path_to` param to `download_artifact` to override the default tmp archive path.
 * **Fix**: Issue with client `download_artifact` passing the `force` flag to the store manager.

### Docs

 * **Fix**: Client docstring.

## v1.1.7.post1

### Core

 * **Fix**: Issue in GPU resources processor which uses the handler instead of the handler's index for the metrics names.

## v1.1.7

### CLI

 * **Enhancement**: Add `releaseName` support to the deployment manager.
 * **Enhancement**: Add `-p` as a shortcut for the port in `port-forward` command.
 * **Enhancement**: Show the correct `meta-kind`.

### UI

 * **New**: Add resources summary to the run's overview tab.
 * **Enhancement**: Improve collapsed sidebar and reduce tooltips' delay setting; hovering on icons will show the tooltips faster when the sidebar is collapsed.
 * **Enhancement**: Persist docked sidebar state; the state is now preserved when switching pages and also when reloading the dashboard.
 * **Enhancement**: Improve the debugging experience by showing the compiled operation in the dashboard.
 * **Enhancement**: Memoize static elements to boost performance in the table comparison and the logs tab.
 * **Enhancement**: Improve the loading speed of the UI.
 * **Fix**: Regression in the table comparison not adapting to the parent container.
 * **Fix**: Issue with empty logs downloads, the path was changed in streams and was not reflected in the UI.
 * **Fix**: Hide sidebar if an entity is not found.

### Core

 * **New**: Consume operation instance information from annotations.
 * **Enhancement**: Rename runtime column to duration to remove confusion between the component runtime (`jobs`, `services`, `dags`, ...) and time/duration of a run.
 * **Fix**: Issue with some generated labels not respecting the 63 limit in Kubernetes; rfc1035/rfc1123 label (DNS_LABEL).
 * **Fix**: Issue in tracking matplotlib figures as Plotly graphs, matplotlib 3.3.0 dropped `is_frame_like` utils function.
 * **Fix**: Issue in GPU resources processor which uses the handler instead of the handler's index for the metrics names.

### Deployment & Setup

 * **New**: Users can deploy Polyaxon using custom release names without having to use Helm. This change enables better multi-namespace deployment using Polyaxon CLI.
 * **New**: Add flag to skip crd creation in values, Helm `--skip-crds` does not seem to have any effect on namespace level.
 * **Enhancement**: All information about the deployment are now in the deployment config file: namespace, release name, version, deployment type, deployment chart,
 users cannot accidentally introduce errors to their deployments when using the CLI.

### Docs

 * **Enhancement**: Update all docs indices.
 * **Enhancement**: Improve several pages.
 * **Enhancement**: WIP to consolidate guides and blog posts.

### Commercial

 * **New**: Add the possibility to change passwords under the user profile page.
 * **Enhancement**: Move bookmarks to the user profile page.
 * **Enhancement**: Improve tables for dashboards and searches and quick actions to update/promote to the organization level.
 * **Fix**: Some minor issues in the agents/queues settings pages.
 * **Fix**: Issue that prevents users from using email for login. Login should support `email/password`, `username/password`, `token`.

## v1.1.6

### CLI

 * **New**: Add (`-t`, `--deployment-type`) flag to expose a simple deployment experience on Minikube and MikroK8S.
   * `polyaxon admin deploy -t minikube`
   * `polyaxon admin upgrade -t minikube`
   * `polyaxon port-forward -t minikube`
 * **Enhancement**: Improve `polyaxon project ls` with (`-q`, `--query`) and (`-s`, `--sort`) for filter and sorting projects.
 * **Enhancement**: Add `-o` short alias for the `--owner` flag in project commands.
 * **Enhancement**: Improve CLI logs streaming logic.
 * **Enhancement**: Add flag (`-c`, `--columns`) to hide/show columns in CLI list command. e.g. `polyaxon ops ls -io -c finished_at,duration,status,learning_rate,loss,accuracy`

### UI

 * **New**: Add run status in the logs viewer's header to show the state changes without changing tabs.
 * **Enhancement**: Improve logs loading and rendering speed.
 * **Enhancement**: Improve logs search experience.
 * **Enhancement**: Switch logs control from `pause/stream` to `reload` when a run is in a finished state.
 * **Enhancement**: Improve logs streaming, and update the values in-place instead of adding new log lines, e.g. progress bars will keep updating in the same cell.
 * **Enhancement**: Improve several validation forms and widgets.
 * **Enhancement**: Add statuses sorting in UI, users can now see latest statuses first.
 * **Enhancement**: Improve modal dialog closing behavior in statuses conditions and fullscreen widgets.
 * **Enhancement**: Improve CLI tab and enable the tab on all distributions.
 * **Fix**: Issue with logs duplicate values during the streaming phase.
 * **Fix**: Issue with the comparison table not properly showing bool values.
 * **Fix**: Issue when creating scalar widgets without x-axis breaks the dashboard.
 * **Fix**: issue with restart/resume forms not handling api errors.

### Core

 * **New**: Add artifacts deletion APIs.
 * **Enhancement**: Consolidate several k8s and storage APIs.
 * **Enhancement**: Update the testing infra and requirements and fix some warnings.
 * **Enhancement**: Add `monitorLogs` flag to sidecar controller.
 * **Fix**: Some compatibility warning with python 3.8.
 * **Fix**: Issue with randomly missing output artifacts when using the default artifacts context,
    the issue was due to milliseconds and was fixed by introducing better state caching.
 * **Fix**: Issue with config manager not closing files correctly during exceptions.
 * **Fix**: Streams datetimes checks.
 * **Security**: Fix security notice in streams.

### Operator

 * **Enhancement**: Imprive the services' reconciliation logic and state changes.
 * **Enhancement**: Improve heuristic to categorize operations' states without storing every change.
 * **Fix**: Issue with some jobs not transitioning back from warning to running.

### Docs

 * **Enhancement**: Add step to deploy local Polyaxon Cluster to the quick-start.
 * **Enhancement**: Add multiarch deployment guide to deployment strategies.
 * **Enhancement**: Update and move deployment best practices under deployment strategies.

### Commercial

 * **Enhancement**: Improve cluster replication's artifacts storage and management.
 * **Enhancement**: Improve Dark theme and remove the beta status.
 * **Enhancement**: Improve the compatibility API.
 * **Enhancement**: Improve handling and security of sessions.

## v1.1.5

### CLI

 * **Enhancement**: Automatically show dashboard link after submitting a new run.
 * **Fix**: Base config manager.

### UI

 * **Enhancement**: Enable lineage tab for CE UI.
 * **Enhancement**: Move run controls column to the right (leading column) in the comparison table.
 * **Fix**: Widget viewer's step slider.

### Specification

 * **Enhancement**: Add `hostPID` to environment section.

### Core

 * **Enhancement**: Enable regex search for UUID fields.
 * **Enhancement**: Pin Polyboard's dependency on matplotlib to `<3.3.0` to prevent issues with Plotly conversion.
 * **Enhancement**: Improve handling of strict float values, treat nan/Inf/-Inf as null.

### Deployment & Setup

 * **Enhancement**: Add multiarch images.
 * **Enhancement**: Enable health checks (livenessProbe) on all Polyaxon's services.
 * **Enhancement**: Improve all scripts' failure and exit status.
 * **Fix**: Handling of favicon requests.

### Docs

 * **Enhancement**: Add docs for customizing the init and sidecar containers under auxiliary containers section.
 * **Fix**: Several `is_index` metadata breaking links to original content.

### Commercial

 * **New**: Github/Google auth for Cloud clusters, with initial work on adapting SAML to work for Cloud clusters similar to the EE version.
 * **Breaking**: Remove token based authentication from the UI.
   * That authentication method required in any case access to a token with `UI` service and `user` scope through a normal auth flow.

## v1.1.4

### CLI

  * **Enhancement**: Improve CLI errors handling.
  * **Enhancement**: Improve memory consumption.
  * **Enhancement**: Improve completion and execution speed.
  * **Enhancement**: Automatically enable ssl verification when the host has https scheme.
  * **Enhancement**: Re-enable compatibility checks.
  * **Enhancement**: Remove clean_outputs decorator.
  * **Enhancement**: Add flag to disable errors reporting for Polyaxon Cloud version.
  * **Fix**: Dashboard command.
  * **Fix**: Parsing of lists passed as params.

### Hub

  * **Fix**: Kaniko component, it now includes the connection url.

### UI

  * **Breaking**: UI is served with the prefix `ui`.
  * **Enhancement**: Use cursor pointer for the flyout switch.
  * **Enhancement**: Improve some modal dialogs.
  * **Fix**: Some padding/size issues in dropdown lists.

### Core

 * **Enhancement**: Disable browsable API in production and allow Json renderer only.
 * **Enhancement**: Improve errors serving speed.
 * **Enhancement**: Improve security configuration.
 * **Enhancement**: Improve slack notifier.
 * **Fix**: Regression with non-managed operations resolution, they should not expect a DB run.
 * **Fix**: Issue in CE resolver not handling missing connections correctly.
 * **Fix**: Issue in tests connecting to polyaxon cloud by default.

### Deployment & Setup

 * **Breaking**: `adminViewEnabled` is now under `ui` (`ui.adminEnabled`).
 * **Enhancement**: Consolidate usage of UI flags.
 * **Enhancement**: Improve proxies configuration and allow external gateway definition.
 * **Enhancement**: Remove tracker settings since the telemetry was dropped in v0.5.x.
 * **Fix**: Helm deployment notes.

### Docs

 *  **Enhancement**: Improve agent deployment and on-boarding experience.
 *  **Enhancement**: Add tokens management section for user profile docs.
 *  **Enhancement**: Add integration guide for deploying and building container images with an in-cluster docker registry.

### Commercial

 * **New**: Introduce a better tokens management UI and allow to create and manage multiple tokens per user.
 * **New**: Agents' tokens are not tied to an admin user anymore.
 * **New**: Add a new `configure` tab in the agent' settings page to generate a Polyaxon Agent deployment config with: token, info, fields to be customized by the user, and link to the docs.
 * **Enhancement**: It's possible to pass queues with the agent namespace to resolve the issue when several agents have queues with the same name (non-unique queue name by organization.)
   * CLI `--queue=queue-name` the queue is resolved from the default agent or `--queue=agent-name/queue-name` to specify the agent.
   * Spec `--queue: queue-name` the queue is resolved from the default agent or `--queue: agent-name/queue-name` to specify the agent.
 * **Fix**: Compiler does not raise if a project does not set a list of authorized run-profiles (default behavior is to authorize all).
 * **Fix**: Integrity error for agent replicas defining overlapping connections.

## v1.1.3

### Operator

 * **Fix**: Issue with namespace environment parsing.

### UI

 * **Enhancement**: Add warning when viewing heavy components in flyout mode.
 * **Fix**: Issue with flyout mode in full screen.
 * **Fix**: Several issues in floyout mode in artifacts/dashboards tabs.

## v1.1.2

### Upgrade

 * **Note**: Please note that since the gateway deployment was referencing an unnecessary service account,
  the upgrade might show an error, in that case you just need to remove the gateway deployment and execute another `polyaxon admin upgrade`.
  You can also delete the gateway deployment before running the upgrade command.

### CLI

 * **New**: Add flag to check a polyaxonfile spec only (`--lint`) without params validation.
 * **Enhancement**: Improve check command and check logic to return more data from the exception trace.
 * **Enhancement**: Improve usage of default host and port values.
 * **Fix**: Issue with port-forward command params' types.

### Deployment & Setup

 * **Enhancement**: Clean usage of service accounts from containers that should not have access.
 * **Enhancement**: Improve resolution of host and ssl server name.
 * **Enhancement**: Rename `hooks` to `apiHooks` to be consistent with the hooks naming (`tableHooks` and `cleanHooks`) and to remove the container image duplication.
   * Default to `api` image/tag/pullPolicy and customizable under `apiHooks`

### Documentation

 * **Enhancement**: Add guide on how to use `polyaxon/polyaxon-cli` in Github actions for linting polyaxonfile or submitting jobs.
 * **Enhancement**: Add some recurrent questions to the FAQ.

### UI

 * **Enhancement**: Add support for right click and ctrl/cmd click to all links/buttons.
 * **Enhancement**: Move flyout mode to its own button and refactor info column to support order/filter/sort logic on tables.
 * **Fix**: Some border style issues with leading columns in table comparison.

### Commercial

 * **Fix**: Some issues with Agent ssl and host redirection.

## v1.1.1

### CLI

 * **Enhancement**: Consolidate CLI commands on hyphens.
 * **Fix**: Polyaxon admin commands when calling without a config file.

### UI

 * **Enhancement**: Add question mark with link to the query syntax.
 * **Enhancement**: Improve performance of some components.
 * **Fix**: UI commands, use `--help` instead of `-h`.
 * **Fix**: UI typos.

### Core

 * **Enhancement**: Add flag for ssl redirect.
 * **Fix**: Setting of admin enabled view flag.

### Deployment & Setup

 * **New**: Flower deployment for monitoring scheduler.
 * **Enhancement**: Refactor labels and common meta data information.
 * **Enhancement**: Add possibility to provide all secrets environment variables using a secret reference.
 * **Enhancement**: Enable gzip proxied flag.
 * **Enhancement**: Tune nginx timeout and keep alive requests to handle some subtle proxy/LB post requests and timeout race conditions.
 * **Enhancement**: Improve ingress and ssl helm configuration.
 * **Enhancement**: Easier deployment option without a `config.yaml` file.

### Commercial

 * **Enhancement**: Add support for pgbouncer for cloud sql.
 * **Fix**: Issue in Dark theme editors, the editors are now using the `dracula` theme.
 * **Fix**: Login issue and logout state view.

## v1.1.0

### Specification

 * **New**: Packaging format with two main primitives: Components and Operations.
 * **New**: Better composition and inheritance.
 * **New**: Runtime standardization and full support for Kubernetes pod and container configuration.
 * **New**: Native support for Kubeflow Operators.
 * **New**: Support for Kubeflow Pipelines components.
 * **New**: Uniform logic for all operations (jobs, services, distributed jobs, pipelines):
     * Environment - Pod section: service account, image pull secrets, dns, ...
     * Termination logic.
     * Secrets/config-maps/volumes/connections.
     * Initializers/sidecars logic.
     * Logic for notifications and events per operation.
     * Logic for plugins per operation.
 * **New**: Well defined and documented process for resolving and injecting variables in the context.
 * **New**: Multistage compiler for Polyaxonfile.
 * **Enhancement**: Improve compilation time by introducing a caching mechanism for the resolution steps (Latency issue appears when scheduling 20k+ runs simultaneously).

### Notebook integration

 * **New**: Allow to start multiple notebooks per project.
 * **Enhancement**: Integration with Voila and Commuter components to share read-only versions of notebooks.
 * **Enhancement**: Submitting experiments from jupyter notebooks.
 * **Enhancement**: Update notebook components to automatically support versioning and resuming.
 * **Enhancement**: For pushing changes to github, the best way is to declare and inject ssh connections in the notebook.
 * **Fix**: Issues with upload and download in notebooks.

### UI

 * **New**: Fast and clean UI.
 * **New**: Scalable table for comparing runs.
 * **New**: Sort by multiple metrics, params, and fields.
 * **New**: Regexp search bar as well as full support for all query and sort logic in metrics and dashboards.
 * **Enhancement**: Improve projects management.
 * **Enhancement**: UI service tab should wait for running condition before allowing the user to access the dashboard.
 * **Enhancement**: Reduce padding for fullscreen charts and widgets.
 * **Enhancement**: Integrate force flag to force fetch logs and events.
 * **Enhancement**: Download a selection of outputs (or just a sub-folder).
 * **Enhancement**: Disable/Remove non-accessible buttons and ui sections for each dist.
 * **Enhancement**: Improve empty state for tables.
 * **Enhancement**: Improve support for Plotly, Altair/Vega, Bokeh.
 * **Enhancement**: Custom visualization with images.
 * **Fix**: Refresh/apply filters/sorts state inconsistency.
 * **Fix**: Regression in table comparison should reset information when switching between kinds.
 * **Fix**: Regression when sorting by datetime fields in the UI.
 * **Fix**: Issue with hover in small screens.
 * **Fix**: Issue with force-refresh multi-run events.

### CLI

 * **New**: Polyaxon ops service should wait for condition before displaying the url.
 * **New**: Polyaxon ops dashboard to display or redirect to the run's url.
 * **New**: Polyaxon project dashboard to display or redirect to the project's url.
 * **Enhancement**: Add port-forward command to simplify deployment for Polyaxon CE.
 * **Enhancement**: Add `-w` flag to watch statuses.
 * **Fix**: Issue with CLI not considering timezone.
 * **Fix**: polyaxon ops logs should default to the last operation.

### Client

 * **New**: Better story on job submission:
     * from component hub
     * from yaml files
     * from python files
     * using an imperative API `from polyaxon.polyflow import *`
 * **New**: Client can stream logs. (e.g. in notebooks.)
 * **New**: Client can watch conditions. (e.g. in notebooks.)
 * **New**: Client wait for condition to monitor a run and drive dependent workflows. (e.g. in notebooks.)
 * **New**: Client can use polytune for programmatic hyperparameter tuning (e.g. in notebooks.)
 * **New**: Client can use the querying, filtering, sorting and visualization to drive insights.
 * **Enhancement**: Add force flag to high-level clients.

### Core features and improvements

 * **New**: Add language clients: GoLang, Typescript, Python, Javascript, Java.
 * **New**: Connections catalog for handling integration with external systems, databases, blob storage, cloud provides, git providers, container registries.
 * **New**: CLI commands / Client methods to start runs based on: python modules, Yaml/Json files, hub reference.
 * **New**: Support for custom initializers and sidecars.
 * **New**: Uniform streaming and logs storage for all operations: jobs, services, distributed operations, sidecars, and init containers.
 * **New**: Improve Reconciliation process for synchronizing statuses.
 * **New**: Improve querying and sorting in CLI, Client and UI.
 * **New**: Lineage persistence.
 * **Enhancement**: Improve tracking interface and capabilities.
 * **Enhancement**: Introduce force fetch flag for all stream APIs.
 * **Enhancement**: Expose gang scheduling option for distributed training.
 * **Enhancement**: Rework dockerfile generator with initializers.
 * **Enhancement**: Templatize common section to reduce errors due to copy/paste.
 * **Enhancement**: Extend contexts with creation and compilation datetime.
 * **Enhancement**: Extend watch_statuses with stop_condition argument.
 * **Enhancement**: Add wait for condition in Python client.
 * **Enhancement**: Expose termination policy for distributed training.
 * **Enhancement**: Support parallel downloading of directory for all cloud providers.
 * **Enhancement**: Persist monitored resources.
 * **Enhancement**: Allow to define TPU_TF_VERSION by experiment.
 * **Enhancement**: Enrich Functionality of Code Versioning.
 * **Fix**: Issue with lineage concurrency.
 * **Fix**: Support for tensorboard v2.
 * **Fix**: Sort by metrics issue with null values.
 * **Fix**: Filter by metrics issue with floating precision.
 * **Fix**: Tensorboard not launching with S3 (minio).
 * **Fix**: Ghost tensorboards.
 * **Fix**: Downloading csv from TensorBoard.
 * **Fix**: Job's status is scheduled although it's running.
 * **Fix**: Get Job / Experiment Pod events to display in dashboard.
 * **Fix**: Logs are not persisted if experiment fails.

### Public component hub

* **New**: Public reusable and customizable components:
    * aws-cli
    * azure-cli
    * buildah
    * commuter
    * dockerizer
    * gcloud-cli
    * jupyterlab
    * notebook
    * kaniko
    * papermill
    * streamlit
    * tensorboard
    * vscode

### Backwards incompatibilities

 * Remove the built-in docker registry, all registries will be managed in standard way using the connections catalog.
 * Drop support for python 2.
 * Remove user management and support for the basic auth and permissions in Polyaxon CE.
 * Remove `polyaxon-schemas`, `polyaxon-client`, and `polyaxon-cli` in favor of a single library `polyaxon`.
 * Polyaxonfile is now camel case.
 * Use one CLI command `polyaxon ops` and remove:
    * `polyaxon experiment`
    * `polyaxon job`
    * `polyaxon build`

### Deployment & Setup

 * **Enhancement**: Improve deployment story for Polyaxon CE: deployment should take less tan 3 minutes for most cases.
 * **Enhancement**: Reduce inter-dependencies for Polyaxon CLI.
 * **Enhancement**: Add imagePullSecrets to chart deployment.
 * **Enhancement**: Single chart for managing CE and EE.
 * **Enhancement**: Make Celery executor an optional plugin, and disable all non-essential dependencies.
 * **Enhancement**: Add flag to enable ui offline mode.
 * **Enhancement**: Add flag to disable ui if Polyaxon is mainly used for packaging and for experiment submission.
 * **Fix**: Runs cleaning pre-delete hook, no need to use Kubectl anymore.

### Documentation

 * **New**: Add guide for resources scheduling.
 * **Fix**: All integration docs.
 * **Fix**: Add citation link.
 * **Enhancement**: Merge CE and EE docs.
 * **Enhancement**: Move roadmap to Github:
   * milestones will give a quick overview of the prioritized issues and in which version they will land.
 * **Enhancement**: Move known issues to Github:
   * Github projects show issues per version.
   * Github milestones show when they were fixed or when they will be fixed.

### Commercial

 * **Deprecation**: Drop support for Azure auth, SAML will be the supported backend for the full on-prem, in addition to Google, Atlassian, Github, Gitlab.
 * **Enhancement**: Add option to set private sentry key.
 * **Enhancement**: Consolidate monitoring configuration in `externalServices`: `errors`, `tracing`, `metrics`.
