---
title: "Release notes for v0.5"
sub_link: "0-5"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/0-5.md"
meta_title: "Polyaxon release notes for v0.5.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v0.5.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v0.5.6

 * Allow code download based on commit in CLI: `polyaxon project download --commit=...`
 * Allow code download related to an experiment/job/build in CLI: e.g. `polyaxon experiment -xp 123 code`
 * Fix issue with experiment resume cleaning the experiment's outputs.
 * Fix some docs refs and issues.

## v0.5.5

 * Fix regression in last metric saving (Last metric should always output the last metric from all previous steps).
 * Fix regression registering wrong queue for handling remote logs.
 * Fix regression order-by metrics does not proxy to the correct field.
 * Fix issue in Polystores: GCS might include empty blob names.
 * Add eventual pod restart handling for init process.
 * Update deps with security release.
 * Add docs for elastic stack config for on-prem deployments.


## v0.5.4

 * Increase internal API throttling.
 * Make throttle rates configurable.
 * Expose more verbose uwsgi logging for DEBUG and INFO levels.
 * Use monospaced font and correct whitespace in logs viewer.
 * Update notebook spawner to allow downloading artifcats/code: set allow_origin to "*".
 * Expose ingress's path configuration.
 * Remove wrong order check on HP tuning Matrix schemas, should be applied only to ranges and not distributions.
 * Add platform version to footer.
 * Fix bool option's UI dropdown not handling initial state correctly.
 * Fix issue with security context not reflected in the dockerfile template.
 * Fix issue with init container not setting auth context correctly.
 * Fix SSO docs.
 * Fix impersonate urls typos (API and clients).

## v0.5.3

 * Upgrade python to 3.7.4.
 * Update default kaniko image tag to v0.9.0.
 * Add note about using pgbouncer for scaling connexions to DB.
 * Add a conf caching mechanism to prevent hitting the db frequently when requesting config options.
 * Update default admin pages for builds, jobs, experiments, groups, tensorboards, notebooks.
 * Fix issue with registry access update form.
 * Add better handling for refresh auth tokens.
 * Make more defensive confirmation dialog by emphasising entities and actions.
 * Make project deletion harder by requiring the user to enter the project name.
 * Add more CLI checks for dependencies during deployment.
 * Make code path resolving consistent between local run and platform run.
 * Expose `maxConnAge` configuration option for both in-cluster and external postgresql connexion.
 * Force user to re-login when token expires.
 * Make stream API internal.
 * Internal improvements.


## v0.5.2

 * Add asset version context processor.
 * Remove settings dropdown condition on admin interface.
 * Update health and status checks urls to follow best practices.
 * Fix jobs artifacts logging.
 * Fix dockerfile path resolution for local runs.
 * Add a simple way to inject debug mode command (only CLI side).
 * Fix issue displaying artifacts for S3 stores.
 * Add docs for using Minio for logs/data/artifacts.

## v0.5.1

 * Add possibility to specify pod annotations for jobs/experiments/builds/notebooks/tensorboards.
   * By default polyaxon will inject necessary annotations, e.g. when using TPU.
   * Users can now define default annotations for each primitive cluster wide.
   * Polyaxonfile spec allows to override the annotations per run.
 * Add possibility to specify custom pod labels for jobs/experiments/builds/notebooks/tensorboards.
   * By default polyaxon uses recommended k8s labels for all managed resources.
   * Users can now define default custom labels for each primitive cluster wide.
   * Polyaxonfile spec allows to override the labels per run.
   * N.B. The custom labels cannot override Polyaxon's required labels.
 * strengthen statuses check and fall back to db check if keys are evicted.
 * Disable namespace monitoring by default.
 * Disable containers resources monitoring by default.
 * Expose several celery options by worker type.
 * Force rabbitmq confirmation when used as a broker by default.
 * Add gzip to list APIs by default
 * Remove parts requiring privileged mode when deploying Polyaxon.
 * Fix in-cluster redis node scheduling docs: uses master/slave.
 * Fix Helm chart validation when disabling docker-registry.
 * Fix issue detecting some local configs when running polyaxonfiles locally (use_https was not detected correctly).
 * Fix quick creation modes in UI.
 * Fix route for creating Tensorboard in UI.
 * Fix UI issues noticed in offline deployment: self-host all styling requirements.
 * Fix spelling in UI.
 * Fix polyaxonfile spec unable to handle quotes in commands.
 * Update lodash: vulnerability issue.


## v0.5.0

 * Add "Cluster Level Dynamic Configuration":
   * Move scheduling configuration to UI.
   * Move integrations to UI.
   * Move secrets and config maps catalogs to UI.
   * Move github/gitlab/bitbucket/azure authentication setup to UI.
   * Move private repos setup to UI.
   * More hardware accelerator setup to UI.
   * Add possibility to create an access catalog for registries and git repos.
   * Add possibility to create an access catalog for connections, data, logs, outputs.
   * Move kaniko, default tensorboards config, default notebooks config to UI.
 * Introduce security group with optional and configurable user UID and group GID for all Polyaxon services and scheduled runs.
 * Mount all volumes with the proper security context.
 * Add a warning when code is big.
 * Add possibility to specify a service account for jobs/experiments/builds/notebooks/tensorboards.
   * By default polyaxon uses a worker service account.
   * Users can now use a default service account for each primitive cluster wide.
   * Polyaxonfile spec allows to override the service account per run.
 * Add possibility to specify a default resources to use for jobs/experiments/builds/notebooks/tensorboards.
   * By default polyaxon schedules runs without resources.
   * Users can now set default resources to use for each primitive cluster wide.
   * Polyaxonfile spec allows to override the resources per run.
 * Add pod restarts.
   * By default polyaxon schedules runs without pod restarts.
   * Users can now set a default pod restarts to use for each primitive cluster wide.
   * Polyaxonfile spec allows to override the pod restarts per run.
 * Add minimum resources requirement for injected containers (init and sidecar).
   * This will fix the issue in clusters with pod security policy requiring that all pods must specify resources.
 * Update redis chart and support using external/managed redis instance.
 * Update rabbitmq chart and support using external/managed rabbitmq instance.
 * Update docker-registry chart and support using external/managed docker registries.
 * Add possibility to turn-off rabbitmq completely and use Redis as broker instead.
 * Make .polyaxonignore honour .gitignore syntax.
 * Rename declarations section to params.
 * Add typing to Polyaxonfiles and schemas.
 * Extract polyaxon dockerizer logic to reuse in other environments.
 * Add possibility to run polyaxonfiles and update params without changing the yaml files: `polyaxon run -f polyaxonfile.yaml -P param1=value1 -P param2=value2`.
 * Add possibility to run polyaxonfiles locally.
   * Allow to run experiments (non-distributed) locally either by invoking a python code with a conda/pip env or by generating a dockerfile, with out-of-the box tracking if POLYAXON_NO_OP is not set to true.
 * Deprecate docker registry authentication using user/password in favor of credential stores and credential helpers.
 * Add documentation for using ECR as Docker registry.
 * Mark kaniko stable: possibility to pull / push from any docker registry.
 * Mark jupyter lab stable.
 * Add sorting for outputs.
 * Update internal architecture to allow development and extending the platform with internal plugins.
 * Expose one single port for accessing all internal Polyaxon's APIs.
 * Update e2e tests with different deployments configurations.
 * Extend input schema to allow users to easily convert boolean params to flags in polyaxonfiles.
 * Add caching layer when checking statuses.
 * Add encryptor for managing sensitive data in-cluster with future possibility to use vault as a backend, currently the backend uses fernet encryption.
 * Add possibility to search entities by name or description using regex.
 * Improve deployment using CLI, add new command: `polyaxon admin`.
 * Extend build kind with `lang_env` to easily export language environment.
 * Add initial work on early stopping policies for hyperparameter tuning.
 * Add possibility to install auto-completion for polyaxon CLI.
 * Add possibility to invalidate individual builds and builds under a project.
 * Update API logic to save raw content to post-resolve contexts.
 * Add admin deploy/upgrade --dry-run commands for debugging purposes.
 * Add alpha version of Polyaxon on docker-compose.
 * Allow verify_ssl to be turned on via the CLI.
 * Improve init container stability by introducing retry on ConnectionError.
 * Improve docs for ingress's annotations.
 * Fix issues in log_artifact and log_artifacts.
 * Fix issue with default ssl path: SSL with node port service should not mount certs in /etc/ssl by default.
 * Fix issue when updating the internal API port.
 * Fix issue when using S3 as outputs storage.
 * Fix issue with the Helm chart not working correctly when RBAC is disabled (This is issue was noticed in Minikube with RBAC disabled).
 * Fix issue preventing to install Polyaxon with the latest helm version.
 * Fix issue with default build backend being ignored in some instances.
 * Fix issue breaking Jupyter lab theme in some recent versions.
 * Fix issue with scheduling S3 credentials for tensorboards.
 * Fix Experiment restart --copy creating additional folder.
 * Fix restart and resume experiments in groups not adding the new experiment to the same group.
 * Add resume button to UI.
 * Add tensorflow tracking to contrib.
 * Improve keras tracking.
 * Add fastai tracking to contrib.
 * Remove several dependencies and replace with simple utils functions.
 * Add initial data/artifacts/logs stores and catalogs.
 * Add initial documentation for Polyflow: an actions/events pipeline engine for creating and automating machine learning workflows.
   * Allow to run ops in parallel while respecting concurrency in pipelines.
   * Allow to run pipelines following schedules: 2 interfaces intervals and crons.
   * Allow to run pipelines with complex ops dependencies as DAGs.
   * All to resolve ops' definitions, from inline templates, local templates, registries of actions/events.
   * Add initial work on supporting airflow out-of-the-box or possibility to easily port ops to Polyaxon to run container-native operations.
 * Add templating for operationalizing and reusing Polyaxon's experiments and jobs.
