---
title: "Release notes for v0.4"
sub_link: "0-4"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/0-4.md"
meta_title: "Polyaxon release notes for v0.4.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v0.4.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## 0.4.4

This is a patch release on top of 0.4.3/0.4.2 containing no breaking changes., this version has no data or db migrations.

 * Fix issue with IntegrityError when creating large number of experiments.
 * Add error validation and redirection when creating experiments selection.
 * Add alpha version of configurable security context.
 * Update Polyaxon deploy to handle Minikube and MicroK8S.
 * Optimize and reduce size of official images.
 * Add dockgen package and initial work on local run mode.
 * Add docs for Polyaxon Client authentication options.
 * Update `log_artifact` and `log_artifacts` methods on the Experiment tracking API as an alternative to `experiment.outputs_stores.upload_file/dir`.
 * Fix Polyaxon Chart ingress issues and typos.

## 0.4.3

 * Re-enable possibility to create projects from dashboard.
 * Add possibility to create experiments, groups, jobs, and builds from dashboard
   * Different creation modes
   * Creation from current project or from top level by choosing a project
 * Add possibility to start notebooks for projects and tensorboards for projects, experiments, groups from the dashboard.
 * Add possibility to restart experiments from the dashboard.
 * Add tables for notebooks and tensorboards on the dashboard to easily see which tensorboards/notebooks are running or failing and their statuses.
 * Add possibility to stop notebooks and tensorboards from dashboard without going to the individual experiment/group/project.
 * Add support for multiple secrets in ingress TLS.
 * Add support for Custom Cluster DNS resolvers.
 * Add support for any DNS backend, users deploying Polyaxon on Kubernetes created by Kubespray won't have to switch DNS from CoreDNS to KubeDNS anymore.
 * Add error handling for searches and metric views creation on dashboard.
 * Add proper error handling for dashboard forms and search UIs, show errors generated by frontend validation and server side validation.
 * Add loading indicators to differentiate between non-found entities and fetch in-progress.
 * Add notebooks and tensorboards search APIs.
 * Add several new fields to the search managers.
 * Move NFS-Provisioner from Polyaxon Chart to a separate repo, users can use the NFS-PROVISIONER maintained Helm chart
   to deploy an NFS server to create MultiReadWrite volumes to use with Polyaxon.
 * Add documentation on how to use the Provisioner for different aspects of the platform, i.e. data, logs, outputs, ...
 * Remove NGINX Ingress from Polyaxon chart, and create documentation on how to use setup an NGINX Ingress from the stable chart.
   Users can also bring their own Ingress controller to use with the ingress resource provided in the chart. Polyaxon should work any ingress controller,
   and docs will be updated to show how to use the major ones.
 * Add missing fields to the polyaxon deploy spec validation.
 * Add `polyaxon deploy` to deployment docs as it is now stable.
 * Add alpha version for parcoords visualization to experiment groups.
 * Add proper editor to show configs, dockerfiles, polyaxonfiles on the dashboard.
 * Update searches and add some default searches (running, succeeded, and failed), more work to improve UI for creating searches and filters in the upcoming versions.
 * Fix issue with Docker client unable to authenticate to private DockerHub registries.
 * Add new docs section to show specific params needed to use private images on DockerHub.
 * Add SSL docs.
 * Add better handling for creating searches with similar names.
 * Update streams errors handling.
 * Fix some encoding issues and auth error handling in CLI.
 * Add docs/refs url shortcuts on the dashboard header.
 * Update some packages that have some security and deprecation problems.
 * Remove `eventMonitors` from list of services to scale to prevent duplication of monitored cluster events,
   and set it to a singleton on the chart to prevent other users from changing the value.
 * Several other internal fixes and improvements.
 * Fix issue requiring users to manually invalidate browser cache.


## 0.4.2

 * Add support of native Horovod experiments.
 * Add new fields for experiments: backend and framework.
   * Framework can be used for any experiment as a special field/tag.
   * When using distributed experiments, some frameworks are recognized and will trigger a particular behavior.
   * Default backend is `native`, i.e. Polyaxon's native behavior for spawning experiments,
   additionally users can start distributed experiments on Kubeflow, by changing the backend field to `kubeflow`.
 * Add helm charts to easily deploy TFJob, PytorchJob, and MPIJob without requiring the user to install a full Kubeflow deployment.
 * Add spawners for distributed experiments on Kubeflow's operators: TFJob, PytorchJob, MPIJob.
 * Update distributed experiments logs handling
   * Streaming experiment's logs show all logs.
   * User can stream specific job's logs.
   * Experiment UI shows default job's logs + user can check specific logs of each job.
 * Update schema validation: now extra values or wrong values, even in nested sub-schemas, will raise a validation error.
 * Update icons version.
 * Polyaxon deploy is now in public beta and will be the recommended way to deploy/upgrade the platform.
 * Extend the build subsection behavior to accepts an environment as well, now users can set the build resources and selectors for the build inside jobs and experiments.
 * Add possibility to download individual outputs files.
 * Fix a regression when downloading outputs from GCS.
 * Fix some issues with outputs tree view.
 * Fix some log formatting issues.
 * Fix readme style issues.
 * Fix some UI issues.
 * Fix some edge cases discovered when using Hyperband.
 * Fix an issue related to pending and initializing statuses not recognised correctly.
 * Several misc regressions fixed and internal enhancements.


## 0.4.1

 * Add UI for experiment jobs (overview, logs, statuses).
 * Improve logging and logs archiving of distributed experiments.
 * Improve the header's tooltip behavior.
 * Improve experiment UI by reducing number of tabs.
 * Improve a couple of queries resulting in large memory consumption.
 * Improve CI sync function to handle:
   * Updating access tokens.
   * Force push mechanism.
   * Fetching of new branches
 * Fix build branch and commit handling, remove `ref` and add a more explicit fields: `commit` and `branch`.
 * Fix regression in distributed experiments.
 * Fix an issue with experiment job's statuses creation dates.
 * Fix readme editor styles.
 * Fix charts UI adjustment.
 * Fix issue scheduling notebook on TPU.
 * Fix some issues related to corrupted UI state resulting in UI crashing.
 * Update dependencies exposing security vulnerabilities.
 * Update several libraries to newer version.

## 0.4.0

 * Add configuration to set a default notebook image.
 * Add configuration to set the default notebook backend.
 * Add support for conda environments.
 * Add a first version Polyaxon CI.
 * Add a new status `stopping` for experiment groups to indicate that the scheduler is stopping experiments in the group and prevent others from starting.
 * Attempt solving an issue of high idle cpu usage caused by rabbitmq container.
 * Fix issues due to concurrency for handling and setting correct statuses for experiment jobs.
 * Fix regression in native build failed status.
 * Fix some issues related to concurrency.
 * Fix some issues when handling files are not found on buckets.
 * Fix updating unique names.
 * Fix several UI typos.
