---
title: "Release notes for v0.3"
sub_link: "0-3"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/0-3.md"
meta_title: "Polyaxon release notes for v0.3.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v0.3.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v0.3.9

 * **important** This version supports only one outputs (either a store or a volume), to simplify deployment of the CE version and reduce confusion.
 * Refactor build process to support plugins and several backends
 * Make native builder lighter.
 * Add support for building containers with Kaniko as a backend in Beta.
 * Add possibility to use own dockerfile to build containers.
 * Add possibility to use contexts to only mount sub-folders in a repo for specific tasks (e.g. mount /code/processing module for data extraction in job, and /code/training for training in experiments).
 * Add support for running Jupyter Labs in addition to Jupyter notebooks.
 * Allow in-cluster authentication when using notebooks (users can create experiment and track metrics/tags/params in notebooks created by Polyaxon seamlessly).
 * Improve jobs'/experiments' authentications.
 * Disable creation of polyaxonfile.yaml by default on `init` commands to allow users to put their polyaxonfiles wherever they want.
 * Improve usage of external repos (add support for using an access token or user/password).
 * Enable project to either use in-cluster code tracking or code on github/bitbucket/gitlab.
 * Update several internal components handling fetching, extracting and archiving external repos.
 * Improve notebooks build process: Current version only allows serverless notebooks (mounting in-cluster code will be re-enabled later).
 * Add several checks to Experiment Group Studies to prevent non-ending groups on errors.
 * Handle missing experiments in suggestion algorithms gracefully.
 * Enable logs on buckets (GCS/S3/Azure).
 * Re-enable tensorboards to continuously add experiments in project/groups as they output values.
 * Improve and separate deletion/archiving of projects/groups/experiments/jobs, and extend UI to support it.
 * Make default tensorboard image configurable.
 * Make all components' logging level configurable with `logLevel`.
 * Extend `polyaxon run` to switch project context and run a config on any project, e.g. `polyaxon run -p projectA -f /polyaxonfiles/config1.yaml`.
 * Allow users to either upload code `polyaxon upload` or set external repo `polyaxon project git --url=https//... --private`,
 so that code tracking can be either in-cluster or on external repos, next version will be introducing github/gitlab hooks to automate pushing to training.
 * Add `polyaon deploy` and `polyaxon teardown` to check a config deployment file, deploy a cluster, upgrade, or teardown in Beta.
 * Allow to customize TPU scheduling: default tensorflow version and resource key.
 * Improve installing cloud stores dependencies with polyaxon-client: `polyaxon-client[gcs]`, `polyaxon-client[s3]`, `polyaxon-client[azure]`.
 * Improve tracking of experiments logs running outside of Polyaxon.
 * Fix TPU scheduling.
 * Fix some issues preventing stopping unschedulable notebooks/tensorboards.
 * Fix detection of warning pod statuses.
 * Fix handling of k8s issues with wrong/bad annotation.
 * Fix issue with platform version returning inverted version values.
 * Fix issues interacting with cloud storages and handling of exceptions.
 * Fix some cli encoding issues in python2.x.
 * Several internal enhancements.

## v0.3.8

 * Fix an issue with a cron job that handles the deletion of archived projects/jobs/experiments/builds.
 * Update ingress to allow users to create an ingress with an IP only without requiring a host.
 * Add `POLYAXON_NO_OP` option to the client/tracking api (polyaxon tracking operation will be ignored),
 to allow users to perform a dry-run of their code when used outside of a Polyaxon context without crashing.
 * Add possibility to disable verify ssl for Polyaxon client and Polyaxon cli.
 * Update default rabbitmq image version.
 * Several internal enhancements.

## v0.3.7

 * Add possibility to collect logs to a cloud storage bucket (S3/GCS/Azure storage).
 * Add keras callback for tracking metrics.
 * Add possibility to read client config from `.polyaxonclient` file as well as from env vars.
 * Add validation for values containing lists.
 * Add copy-to-clipboard to preserve configuration yaml structure when copying from browser.
 * Add confirmation dialogue before deleting/stopping entities on Dashborad.
 * Add better logs handling for in-cluster jobs and experiments running on other platforms.
 * Enable admin view by default with useful models only.
 * Enhance statuses watch.
 * Add gzip decorator for some endpoints.
 * Enhance stores and options management (internal improvements).
 * Add external registries for managing build images (Beta).
 * Add graceful Handling of wrongly detected gpu nodes.
 * Fix token auto-refresh.
 * Fix user deletion from admin UI.
 * Fis issue with declarations of type list not being handled correctly on dashboard.
 * Fix issue relates to `ls` on GCS.
 * Fix some issues related to detecting changes on Azure.
 * Fix error when the command `config --list` when the cli configuration is not initialized.
 * Extend in-cluster examples.
 * Add examples for tracking experiments outside of Polyaxon.
 * Introduce Polyaxon deployment lifecycle management (Beta).

## v0.3.5

 * Update logging logic, logs are now collected lazily.
 * Use k8s logs timestamps to avoid lags between Polyaxon and k8s.
 * Expose pod name on experiments jobs, jobs, builds, tensorboards in UI & CLI.
 * Update sidecar logic, first step to implement a collector sidecar logic for artifacts/outputs.
 * Deletion of `projects`, `experiment groups`, `experiments`, `jobs`, is now asynchronous, and results in archiving the entity for a certain period.
 * Add archiving period, configurable with `cleaningIntervals.archived` default 7 days, to allow users to recover deleted entities, otherwise, archived entities older than this interval get cleaned.
 * Add support for TPU scheduling.
 * Fix study groups issue related to creating chunks of serializable numpy suggestions.
 * Schedule configmap and secret refs for builds created by experiments/jobs/notebooks.
 * [Security, XSS fixes] Update: bootstrap 3.4.0.
 * Update service account usage for workers to get less permissions.
 * Calculate run time based on running status instead of starting status, the reason is that an experiment can be sent to k8s scheduler, hence it can wait for some time for resources before it starts actually running.
 * Fix UI issue in the job overview tab.
 * Fix smoothing algorithm, was dropping the first metric resulting in wrong visualization, now the smoothing has similar behavior to the Tensorboard's.
 * Disable ingress by default, and use LoadBalancer as default value for charts.
 * Add host list directly on ingress to use when tls is not enabled.
 * Remove deprecated `polyaxon-logs` service.
 * Use ocular for monitoring statuses.
 * Use polystores for managing stores.


## v0.3.4

 * Add new statuses: "warning" and "unschedulable".
 * Extend specification to allow `run` to accept multiple commands in polyaxonfiles.
 * Add details information when an experiment is stopped by the system.
 * Allow to edit entities' names from the UI for group/experiment/job/build.
 * Display the name given by the user by default and fall back to the unique name generated by the platform.
 * Add UI meta info about the restarted/resumed/copied jobs/experiments and add ref to the original entity.
 * Add termination reason/status code to failed runs.
 * Fix issue with resumed experiments' outputs getting wrong artifacts.
 * Update statuses logging logic to not drop past events caused by concurrency.
 * Always insert statuses while respecting the state machine before the event was detected.
 * Remove default value for jobs cloning strategy (was added by mistake).
 * Fix issue fetching experiments' declarations in groups' metrics.
 * Fix an issue with stop job api.
 * Fix issue in sidecar monitor.
 * Fix bookmark tooltip style issue.
 * Update some UI styles.

## v0.3.3

 * Add download button for logs.
 * Add download button for outputs.
 * Make ephemeral tokens ttl a configurable param.
 * Optimize experiment group studies.
 * Extend specification to accept registries with port numbers in the build section.

## v0.3.2

 * Add `--init` option to `polyaxon create` to allow users to create and initialize a project at the same time.
 * Use `done` instead of `succeeded` for experiment groups status.
 * Upgrade image and python to 3.6.
 * Update the registration's validation.
 * Update smoothing algorithm: move from spline to moving average.
 * Add search algorithm to group schemas and to cli `polyaxon group get`.
 * Update heartbeat logic: start logic from running status instead of scheduled.
 * Update heartbeat logic: lower check frequency.
 * Move some abstractions from EE to CE.
 * Update error handling for download requests in client.
 * Update token with scopes and refresh mechanism.
 * Improve some apis.
 * Add mechanism to ensure CSRFToken refresh on page refresh.
 * Update Kubernetes client.
 * Add dockerizer pull policy.
 * Fix nested outputs relative paths.
 * Fix tabs css behavior outlining clicks.
 * Fix admin readonly mixin.
 * Fix issues with the ui client POST/DELETE/PATH requests.
 * Fix notebook UI actions.
 * Fix admin styles regression.

## v0.3.1

 * (Security) Add IPs/Hosts whitelist configuration.
 * (Security) Make admin view configurable and disable it by default.
 * Add api host/ip configuration to send emails/slack/notifications/integrations with clickable links.
 * Add more validation and edge cases handling for outputs apis.
 * Add loading indicator for dashboard.
 * Add migration to prepare for auth/permission plugins and extensions for the community version (Phase 1).
 * Remove experiment group schemas patch.
 * Minify styles.
 * Fix UI alignment and usability issues.
 * Fix an issue with groups' type not created for studies.

## v0.3.0

 * Add experiment selection groups: Users can now compare 2 (or more) experiments by adding them to a selection.
 * Add possibility to visualize metrics and to start a tensorboard for any selection of experiments.
 * Add outputs/artifacts tree view.
 * Add outputs/artifacts files (text/code/images) previewing.
 * Add tensorboard support for events on cloud storage (S3 and GCS).
 * Add refresh button to avoid reloading the whole page (first step to better UX, next step is real-time updates or polling).
 * Extend tensorboard behavior to show events from different backend storages (e.g. one experiment persisting events to S3 and another to GCS)
 * Add possibility to delete and stop multiple experiments at once.
 * Allow to configure heartbeat timeout.
 * Allow to support commands with `&&` without the need to create a script.
 * Connect gaps in charts, an issue happens when only a data point is created at a time.
 * Extend Groups Component to show the group type (study & selection).
 * Extend private registries to accept dictionaries as well as uri specs.
 * Open access for private repos to public beta.
 * Add help text to indicate that names must be slugs (a better error handling for the dashboard is needed).
 * Add default node scheduling for tensorboards.
 * Upgrade security warning packages.
 * Enhance cloud storages management.
 * Fix an issue not showing all error logs of builds.
 * Fix an issue with cli existing if both `--past` and `--follow` are passed, and `past api` returns a 404.
 * Fix issues copy/restart experiment from a group.
