---
title: "Release notes for v0.2"
sub_link: "0-2"
code_link: "https://github.com/polyaxon/polyaxon/blob/master/releases/0-2.md"
meta_title: "Polyaxon release notes for v0.2.x - Polyaxon Releases"
meta_description: "Polyaxon release notes, migrations, and deprecation notes for v0.2.x."
visibility: public
status: published
tags:
  - reference
sidebar: "releases"
---

## v0.2.9

 * Add Azure Storage to public beta.
 * Update SSO behavior to create users inactive by default.
 * Add support for external public repos.
 * Add support for external private repos (beta).
 * Extend build specification with commit/branch(treeish) for both internal and external repos.
 * Update and extract sidecar logic to independent service.
 * Add support for external experiment logging.
 * Update and enhance store management.
 * Trigger single build process for experiment groups.
 * Update behavior of `latest` docker tag, default to not always pull, add configuration to set it up to True.
 * Update and fix several docs issues.
 * Add port forwarding command docs
 * Add workload heartbeat tracking, jobs/experiments not reporting will be marked as Zombie runs.
 * Enhance internal events management, default is async now.
 * Add possibility to stop tensorboards/notebooks from dashboard.
 * Force experiment statuses to respect the transition matrix.
 * Update logging to track timestamps as well, cli logs commands have option to hide timestamps.
 * Extend health check logic with disk, memory, cache, ...
 * Extract common utils.
 * Remove external repos management.
 * Fix issue with client not reporting correctly last metrics (worker dies before finishing the request).
 * Fix issue with cli outdated param (async).
 * Fix issues related to image builds.
 * Fix some ui issues on safari.

## v0.2.8

 * Seamless integration of S3 and GCS is now in public beta,
   users can load data from cloud storages as well as from persistent volumes and host nodes,
   they can also manage their outputs and artifacts using these storages,
   tensorflow's integration is seamless as well for model and checkpoints logging.
 * Fix some issues with Azure Storage (still in private beta).
 * Add support for user's custom secrets and config maps,
   users can extend Polyaxon runs and workloads with extra environment and secrets.
 * Improve experiments' metrics API by using a queue for frequent updates.
 * Increase throttling rate for metrics reporting.
 * Add possibility to edit charts.
 * Add more automation to chart titles based on metrics/params.
 * Add periodic worker to improve performance.
 * Add cleaning crons to remove old notifications and logs.
 * Add streams health status.
 * Add extra config and annotation to prevent IOError in long running requests.
 * Add draft for out-cluster logging.
 * Fix validation issue related to gitlab usernames containing dots.
 * Fix issue with re-enabling previously disabled nodes.
 * Fix issues related to artifacts management and absolute paths on users machines.
 * Fix filtering typo for `id` dropdown.

## v0.2.7

 * Add experiment groups' metrics/visualizations.
 * Add experiments' metrics comparison.
 * Add readme and note taking on project/group/experiment/job's overviews.
 * (`Data Migration`) Update Experiment's last metric, it will include all values even if they were not reported at the current step. This is a new behavior to allow user to aggregate and have an overview over
 all values reported from previous steps/epochs' metrics.
 * Add tags editing from dashboard.
 * Add description editing from dashboard.
 * Add health status endpoint.
 * Add tracking API documentation.
 * Fix issue with hyperparameter tuning; experiment groups are stuck trying to sample new values when user requests larger number of experiments than the provided space (happens only when using discrete distributions).
 * Add is_continuous property to space values.
 * Fix issue with cli upload large files.
 * Fix issue with cli losing connection due to timeout.
 * Update annotation for mounting volumes with read-only option, the read-only is now applied to both the volume and the persistence claim.
 * Update error message for cli upload.
 * Fix `notebook -u` command, an old keyword was still being passed.
 * Update static files caching options.
 * Attempt to stabilize connection to broker(better solution is required).
 * Upgraded requirements.
 * Removed unused frontend dependencies.
 * Update throttling behavior for some endpoints.

## v0.2.6

This is a patch release on top of 0.2.3 containing no breaking changes.

 * For issues in NodePort deployments: an issue arises with builds and with overall internal connection to api.
 * Improved response time for project/group/experiment detail apis (removed query annotations).
 * Fix some db warnings related to Jsonb default values.

## v0.2.5

This is a patch release on top of 0.2.3 containing no breaking changes.

 * Add `-l` option to `polyaxon run` to start log automatically after run command
 * Keep stream connection alive for logs (fix issue with ending sessions)

## v0.2.4

This is a patch release on top of 0.2.3 containing no breaking changes.

 * Update client auth: persist token after ephemeral login

## v0.2.3

 * Fix one major issue with events getting dropped, which led to experiments getting stuck in scheduled status.
 * Add out cluster tracking and instrumentation, users can now track experiment outside of Polyaxon and compare the experiments in Polyaxon.
 * Add possibility to create experiment and experiment groups without polyaxon specification, to allow users to run custom hyperparameter tuning.
 * Add ttl and debug mode for runs.
 * Add customizable charts.
 * Add chart views saving functionality.
 * Add metrics views.
 * Extend query spec api to save metrics/params columns.
 * Add group metrics visualization and analysis [Beta].
 * Improve stability of experiment groups (some issues are still under investigation).
 * filter disabled nodes out from cluster api end points.
 * Add possibility to use GCE/S3/Azure as an outputs and artifact storage [Beta].
 * Update handling of internal tokens to increase job/experiment security and scoping.
 * Add traceback to the failure event status to get more context.
 * Add code reference endpoint for jobs and experiments.
 * Add data references tracking and extend experiment details api.
 * Add run environment tracking and extend experiment details api.
 * Add handling for evicted pods.
 * Init should not reinitialize ignore files and other cli config files.
 * Introduce ephemeral auth for experiment and jobs.
 * Update code reference to include branch, url, is_dirty.
 * Add possibility to merge-update tags and params/declarations.
 * Extract env var handling and typing.
 * Fix group stats (counts of experiments in different stages)
 * Fix a UI issue with flexbox in last chrome

## v0.2.2

This is a patch release on top of 0.2.0 containing only bug fixes and no breaking changes or features.

 * Fix issue with web hooks not serializing events correctly

## v0.2.1

This is a patch release on top of 0.2.0 containing only bug fixes and no breaking changes or features.

 * Fix issue with serializing experiment jobs' tolerations

## v0.2.0

 * Enhance filtering and sorting: better UI and dropdown with filter/sort options
 * Add saved queries
 * Experiments table dashboard can include optional columns: metrics and declarations/params. This will allow to compare experiments in one table.
 * Update log stream to show phase changes instead of disconnecting the session (now you can run and log without providing any id or checking the build)
 * Add REST API docs
 * Include bookmark indicator in dashboard lists
 * Refetch on tab changes to get latest updates
 * Remove some javascript dependencies and reduce bundle size
 * Add cli install to `install.polyaxon.com`
 * Add exception handling for actions, errors were preventing experiments/jobs from running
 * Lint helm chart
 * Add helm chart CI
 * Fix an issue with csrf token collection
 * Fix issue in reducer that made the state inconsistent
 * Fix an issue with dashboard pagination
 * Fix issue with bookmark page not loading experiments, and only loading when navigating tabs
 * Fix a bug that made loading experiments slow
