# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ..core.unchecked_base_model import UncheckedBaseModel


class ToolCallDelta(UncheckedBaseModel):
    """
    Contains the chunk of the tool call generation in the stream.
    """

    name: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Name of the tool call
    """

    index: typing.Optional[float] = pydantic_v1.Field(default=None)
    """
    Index of the tool call generated
    """

    parameters: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Chunk of the tool parameters
    """

    text: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    Chunk of the tool plan text
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
