# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ..core.unchecked_base_model import UncheckedBaseModel


class DatasetPart(UncheckedBaseModel):
    id: str = pydantic_v1.Field()
    """
    The dataset part ID
    """

    name: str = pydantic_v1.Field()
    """
    The name of the dataset part
    """

    url: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    The download url of the file
    """

    index: typing.Optional[int] = pydantic_v1.Field(default=None)
    """
    The index of the file
    """

    size_bytes: typing.Optional[int] = pydantic_v1.Field(default=None)
    """
    The size of the file in bytes
    """

    num_rows: typing.Optional[int] = pydantic_v1.Field(default=None)
    """
    The number of rows in the file
    """

    original_url: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    The download url of the original file
    """

    samples: typing.Optional[typing.List[str]] = pydantic_v1.Field(default=None)
    """
    The first few rows of the parsed file
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
