# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ..core.unchecked_base_model import UncheckedBaseModel
from .classify_response_classifications_item_classification_type import (
    ClassifyResponseClassificationsItemClassificationType,
)
from .classify_response_classifications_item_labels_value import ClassifyResponseClassificationsItemLabelsValue


class ClassifyResponseClassificationsItem(UncheckedBaseModel):
    id: str
    input: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    The input text that was classified
    """

    prediction: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    The predicted label for the associated query (only filled for single-label models)
    """

    predictions: typing.List[str] = pydantic_v1.Field()
    """
    An array containing the predicted labels for the associated query (only filled for single-label classification)
    """

    confidence: typing.Optional[float] = pydantic_v1.Field(default=None)
    """
    The confidence score for the top predicted class (only filled for single-label classification)
    """

    confidences: typing.List[float] = pydantic_v1.Field()
    """
    An array containing the confidence scores of all the predictions in the same order
    """

    labels: typing.Dict[str, ClassifyResponseClassificationsItemLabelsValue] = pydantic_v1.Field()
    """
    A map containing each label and its confidence score according to the classifier. All the confidence scores add up to 1 for single-label classification. For multi-label classification the label confidences are independent of each other, so they don't have to sum up to 1.
    """

    classification_type: ClassifyResponseClassificationsItemClassificationType = pydantic_v1.Field()
    """
    The type of classification performed
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
