# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from .chat_document import ChatDocument
from .chat_search_result import ChatSearchResult
from .chat_stream_event import ChatStreamEvent


class ChatSearchResultsEvent(ChatStreamEvent):
    search_results: typing.Optional[typing.List[ChatSearchResult]] = pydantic_v1.Field(default=None)
    """
    Conducted searches and the ids of documents retrieved from each of them.
    """

    documents: typing.Optional[typing.List[ChatDocument]] = pydantic_v1.Field(default=None)
    """
    Documents fetched from searches or provided by the user.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
