# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ..core.unchecked_base_model import UncheckedBaseModel
from .chat_search_query import ChatSearchQuery
from .chat_search_result_connector import ChatSearchResultConnector


class ChatSearchResult(UncheckedBaseModel):
    search_query: typing.Optional[ChatSearchQuery] = None
    connector: ChatSearchResultConnector = pydantic_v1.Field()
    """
    The connector from which this result comes from.
    """

    document_ids: typing.List[str] = pydantic_v1.Field()
    """
    Identifiers of documents found by this search query.
    """

    error_message: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    An error message if the search failed.
    """

    continue_on_failure: typing.Optional[bool] = pydantic_v1.Field(default=None)
    """
    Whether a chat request should continue or not if the request to this connector fails.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
