# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from ..core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ..core.unchecked_base_model import UncheckedBaseModel


class ChatConnector(UncheckedBaseModel):
    """
    The connector used for fetching documents.
    """

    id: str = pydantic_v1.Field()
    """
    The identifier of the connector.
    """

    user_access_token: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    When specified, this user access token will be passed to the connector in the Authorization header instead of the Cohere generated one.
    """

    continue_on_failure: typing.Optional[bool] = pydantic_v1.Field(default=None)
    """
    Defaults to `false`.
    
    When `true`, the request will continue if this connector returned an error.
    """

    options: typing.Optional[typing.Dict[str, typing.Any]] = pydantic_v1.Field(default=None)
    """
    Provides the connector with different settings at request time. The key/value pairs of this object are specific to each connector.
    
    For example, the connector `web-search` supports the `site` option, which limits search results to the specified domain.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
