# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ....core.unchecked_base_model import UncheckedBaseModel
from .base_model import BaseModel
from .hyperparameters import Hyperparameters


class Settings(UncheckedBaseModel):
    """
    The configuration used for fine-tuning.
    """

    base_model: BaseModel = pydantic_v1.Field()
    """
    The base model to fine-tune.
    """

    dataset_id: str = pydantic_v1.Field()
    """
    The data used for training and evaluating the fine-tuned model.
    """

    hyperparameters: typing.Optional[Hyperparameters] = pydantic_v1.Field(default=None)
    """
    Fine-tuning hyper-parameters.
    """

    multi_label: typing.Optional[bool] = pydantic_v1.Field(default=None)
    """
    read-only. Whether the model is single-label or multi-label (only for classification).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
