# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ....core.unchecked_base_model import UncheckedBaseModel
from .settings import Settings
from .status import Status


class FinetunedModel(UncheckedBaseModel):
    """
    This resource represents a fine-tuned model.
    """

    id: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    read-only. FinetunedModel ID.
    """

    name: str = pydantic_v1.Field()
    """
    FinetunedModel name (e.g. `foobar`).
    """

    creator_id: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    read-only. User ID of the creator.
    """

    organization_id: typing.Optional[str] = pydantic_v1.Field(default=None)
    """
    read-only. Organization ID.
    """

    settings: Settings = pydantic_v1.Field()
    """
    FinetunedModel settings such as dataset, hyperparameters...
    """

    status: typing.Optional[Status] = pydantic_v1.Field(default=None)
    """
    read-only. Current stage in the life-cycle of the fine-tuned model.
    """

    created_at: typing.Optional[dt.datetime] = pydantic_v1.Field(default=None)
    """
    read-only. Creation timestamp.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic_v1.Field(default=None)
    """
    read-only. Latest update timestamp.
    """

    completed_at: typing.Optional[dt.datetime] = pydantic_v1.Field(default=None)
    """
    read-only. Timestamp for the completed fine-tuning.
    """

    last_used: typing.Optional[dt.datetime] = pydantic_v1.Field(default=None)
    """
    read-only. Timestamp for the latest request to this fine-tuned model.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        kwargs_with_defaults_exclude_none: typing.Any = {"by_alias": True, "exclude_none": True, **kwargs}

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset), super().dict(**kwargs_with_defaults_exclude_none)
        )

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
