# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .. import core
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.client_closed_request_error import ClientClosedRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.gateway_timeout_error import GatewayTimeoutError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..errors.not_implemented_error import NotImplementedError
from ..errors.service_unavailable_error import ServiceUnavailableError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.client_closed_request_error_body import ClientClosedRequestErrorBody
from ..types.dataset_type import DatasetType
from ..types.dataset_validation_status import DatasetValidationStatus
from ..types.gateway_timeout_error_body import GatewayTimeoutErrorBody
from ..types.not_implemented_error_body import NotImplementedErrorBody
from ..types.too_many_requests_error_body import TooManyRequestsErrorBody
from ..types.unprocessable_entity_error_body import UnprocessableEntityErrorBody
from .types.datasets_create_response import DatasetsCreateResponse
from .types.datasets_get_response import DatasetsGetResponse
from .types.datasets_get_usage_response import DatasetsGetUsageResponse
from .types.datasets_list_response import DatasetsListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DatasetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        dataset_type: typing.Optional[str] = None,
        before: typing.Optional[dt.datetime] = None,
        after: typing.Optional[dt.datetime] = None,
        limit: typing.Optional[float] = None,
        offset: typing.Optional[float] = None,
        validation_status: typing.Optional[DatasetValidationStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetsListResponse:
        """
        List datasets that have been created.

        Parameters
        ----------
        dataset_type : typing.Optional[str]
            optional filter by dataset type

        before : typing.Optional[dt.datetime]
            optional filter before a date

        after : typing.Optional[dt.datetime]
            optional filter after a date

        limit : typing.Optional[float]
            optional limit to number of results

        offset : typing.Optional[float]
            optional offset to start of results

        validation_status : typing.Optional[DatasetValidationStatus]
            optional filter by validation status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsListResponse
            A successful response.

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.datasets.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "datasets",
            method="GET",
            params={
                "datasetType": dataset_type,
                "before": serialize_datetime(before) if before is not None else None,
                "after": serialize_datetime(after) if after is not None else None,
                "limit": limit,
                "offset": offset,
                "validationStatus": validation_status,
            },
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsListResponse, construct_type(type_=DatasetsListResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        *,
        name: str,
        type: DatasetType,
        data: core.File,
        keep_original_file: typing.Optional[bool] = None,
        skip_malformed_input: typing.Optional[bool] = None,
        keep_fields: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        optional_fields: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        text_separator: typing.Optional[str] = None,
        csv_delimiter: typing.Optional[str] = None,
        dry_run: typing.Optional[bool] = None,
        eval_data: typing.Optional[core.File] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetsCreateResponse:
        """
        Create a dataset by uploading a file. See ['Dataset Creation'](https://docs.cohere.com/docs/datasets#dataset-creation) for more information.

        Parameters
        ----------
        name : str
            The name of the uploaded dataset.

        type : DatasetType
            The dataset type, which is used to validate the data. Valid types are `embed-input`, `reranker-finetune-input`, `single-label-classification-finetune-input`, `chat-finetune-input`, and `multi-label-classification-finetune-input`.

        data : core.File
            See core.File for more documentation

        keep_original_file : typing.Optional[bool]
            Indicates if the original file should be stored.

        skip_malformed_input : typing.Optional[bool]
            Indicates whether rows with malformed input should be dropped (instead of failing the validation check). Dropped rows will be returned in the warnings field.

        keep_fields : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of names of fields that will be persisted in the Dataset. By default the Dataset will retain only the required fields indicated in the [schema for the corresponding Dataset type](https://docs.cohere.com/docs/datasets#dataset-types). For example, datasets of type `embed-input` will drop all fields other than the required `text` field. If any of the fields in `keep_fields` are missing from the uploaded file, Dataset validation will fail.

        optional_fields : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of names of fields that will be persisted in the Dataset. By default the Dataset will retain only the required fields indicated in the [schema for the corresponding Dataset type](https://docs.cohere.com/docs/datasets#dataset-types). For example, Datasets of type `embed-input` will drop all fields other than the required `text` field. If any of the fields in `optional_fields` are missing from the uploaded file, Dataset validation will pass.

        text_separator : typing.Optional[str]
            Raw .txt uploads will be split into entries using the text_separator value.

        csv_delimiter : typing.Optional[str]
            The delimiter used for .csv uploads.

        dry_run : typing.Optional[bool]
            flag to enable dry_run mode

        eval_data : typing.Optional[core.File]
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsCreateResponse
            A successful response.

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.datasets.create(
            name="name",
            type="embed-input",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "datasets",
            method="POST",
            params={
                "name": name,
                "type": type,
                "keep_original_file": keep_original_file,
                "skip_malformed_input": skip_malformed_input,
                "keep_fields": keep_fields,
                "optional_fields": optional_fields,
                "text_separator": text_separator,
                "csv_delimiter": csv_delimiter,
                "dry_run": dry_run,
            },
            data={},
            files={"data": data, "eval_data": eval_data},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsCreateResponse, construct_type(type_=DatasetsCreateResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_usage(self, *, request_options: typing.Optional[RequestOptions] = None) -> DatasetsGetUsageResponse:
        """
        View the dataset storage usage for your Organization. Each Organization can have up to 10GB of storage across all their users.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsGetUsageResponse
            A successful response.

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.datasets.get_usage()
        """
        _response = self._client_wrapper.httpx_client.request(
            "datasets/usage", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsGetUsageResponse, construct_type(type_=DatasetsGetUsageResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DatasetsGetResponse:
        """
        Retrieve a dataset by ID. See ['Datasets'](https://docs.cohere.com/docs/datasets) for more information.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsGetResponse
            A successful response.

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.datasets.get(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"datasets/{jsonable_encoder(id)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsGetResponse, construct_type(type_=DatasetsGetResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Any]:
        """
        Delete a dataset by ID. Datasets are automatically deleted after 30 days, but they can also be deleted manually.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Any]
            A successful response.

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.datasets.delete(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"datasets/{jsonable_encoder(id)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(typing.Dict[str, typing.Any], construct_type(type_=typing.Dict[str, typing.Any], object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncDatasetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        dataset_type: typing.Optional[str] = None,
        before: typing.Optional[dt.datetime] = None,
        after: typing.Optional[dt.datetime] = None,
        limit: typing.Optional[float] = None,
        offset: typing.Optional[float] = None,
        validation_status: typing.Optional[DatasetValidationStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetsListResponse:
        """
        List datasets that have been created.

        Parameters
        ----------
        dataset_type : typing.Optional[str]
            optional filter by dataset type

        before : typing.Optional[dt.datetime]
            optional filter before a date

        after : typing.Optional[dt.datetime]
            optional filter after a date

        limit : typing.Optional[float]
            optional limit to number of results

        offset : typing.Optional[float]
            optional offset to start of results

        validation_status : typing.Optional[DatasetValidationStatus]
            optional filter by validation status

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsListResponse
            A successful response.

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.datasets.list()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "datasets",
            method="GET",
            params={
                "datasetType": dataset_type,
                "before": serialize_datetime(before) if before is not None else None,
                "after": serialize_datetime(after) if after is not None else None,
                "limit": limit,
                "offset": offset,
                "validationStatus": validation_status,
            },
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsListResponse, construct_type(type_=DatasetsListResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        *,
        name: str,
        type: DatasetType,
        data: core.File,
        keep_original_file: typing.Optional[bool] = None,
        skip_malformed_input: typing.Optional[bool] = None,
        keep_fields: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        optional_fields: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        text_separator: typing.Optional[str] = None,
        csv_delimiter: typing.Optional[str] = None,
        dry_run: typing.Optional[bool] = None,
        eval_data: typing.Optional[core.File] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DatasetsCreateResponse:
        """
        Create a dataset by uploading a file. See ['Dataset Creation'](https://docs.cohere.com/docs/datasets#dataset-creation) for more information.

        Parameters
        ----------
        name : str
            The name of the uploaded dataset.

        type : DatasetType
            The dataset type, which is used to validate the data. Valid types are `embed-input`, `reranker-finetune-input`, `single-label-classification-finetune-input`, `chat-finetune-input`, and `multi-label-classification-finetune-input`.

        data : core.File
            See core.File for more documentation

        keep_original_file : typing.Optional[bool]
            Indicates if the original file should be stored.

        skip_malformed_input : typing.Optional[bool]
            Indicates whether rows with malformed input should be dropped (instead of failing the validation check). Dropped rows will be returned in the warnings field.

        keep_fields : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of names of fields that will be persisted in the Dataset. By default the Dataset will retain only the required fields indicated in the [schema for the corresponding Dataset type](https://docs.cohere.com/docs/datasets#dataset-types). For example, datasets of type `embed-input` will drop all fields other than the required `text` field. If any of the fields in `keep_fields` are missing from the uploaded file, Dataset validation will fail.

        optional_fields : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of names of fields that will be persisted in the Dataset. By default the Dataset will retain only the required fields indicated in the [schema for the corresponding Dataset type](https://docs.cohere.com/docs/datasets#dataset-types). For example, Datasets of type `embed-input` will drop all fields other than the required `text` field. If any of the fields in `optional_fields` are missing from the uploaded file, Dataset validation will pass.

        text_separator : typing.Optional[str]
            Raw .txt uploads will be split into entries using the text_separator value.

        csv_delimiter : typing.Optional[str]
            The delimiter used for .csv uploads.

        dry_run : typing.Optional[bool]
            flag to enable dry_run mode

        eval_data : typing.Optional[core.File]
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsCreateResponse
            A successful response.

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.datasets.create(
            name="name",
            type="embed-input",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "datasets",
            method="POST",
            params={
                "name": name,
                "type": type,
                "keep_original_file": keep_original_file,
                "skip_malformed_input": skip_malformed_input,
                "keep_fields": keep_fields,
                "optional_fields": optional_fields,
                "text_separator": text_separator,
                "csv_delimiter": csv_delimiter,
                "dry_run": dry_run,
            },
            data={},
            files={"data": data, "eval_data": eval_data},
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsCreateResponse, construct_type(type_=DatasetsCreateResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_usage(self, *, request_options: typing.Optional[RequestOptions] = None) -> DatasetsGetUsageResponse:
        """
        View the dataset storage usage for your Organization. Each Organization can have up to 10GB of storage across all their users.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsGetUsageResponse
            A successful response.

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.datasets.get_usage()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "datasets/usage", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsGetUsageResponse, construct_type(type_=DatasetsGetUsageResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DatasetsGetResponse:
        """
        Retrieve a dataset by ID. See ['Datasets'](https://docs.cohere.com/docs/datasets) for more information.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DatasetsGetResponse
            A successful response.

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.datasets.get(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"datasets/{jsonable_encoder(id)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DatasetsGetResponse, construct_type(type_=DatasetsGetResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Any]:
        """
        Delete a dataset by ID. Datasets are automatically deleted after 30 days, but they can also be deleted manually.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Any]
            A successful response.

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.datasets.delete(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"datasets/{jsonable_encoder(id)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(typing.Dict[str, typing.Any], construct_type(type_=typing.Dict[str, typing.Any], object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
