# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.client_closed_request_error import ClientClosedRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.gateway_timeout_error import GatewayTimeoutError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..errors.not_implemented_error import NotImplementedError
from ..errors.service_unavailable_error import ServiceUnavailableError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.client_closed_request_error_body import ClientClosedRequestErrorBody
from ..types.create_connector_o_auth import CreateConnectorOAuth
from ..types.create_connector_response import CreateConnectorResponse
from ..types.create_connector_service_auth import CreateConnectorServiceAuth
from ..types.delete_connector_response import DeleteConnectorResponse
from ..types.gateway_timeout_error_body import GatewayTimeoutErrorBody
from ..types.get_connector_response import GetConnectorResponse
from ..types.list_connectors_response import ListConnectorsResponse
from ..types.not_implemented_error_body import NotImplementedErrorBody
from ..types.o_auth_authorize_response import OAuthAuthorizeResponse
from ..types.too_many_requests_error_body import TooManyRequestsErrorBody
from ..types.unprocessable_entity_error_body import UnprocessableEntityErrorBody
from ..types.update_connector_response import UpdateConnectorResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConnectorsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        limit: typing.Optional[float] = None,
        offset: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListConnectorsResponse:
        """
        Returns a list of connectors ordered by descending creation date (newer first). See ['Managing your Connector'](https://docs.cohere.com/docs/managing-your-connector) for more information.

        Parameters
        ----------
        limit : typing.Optional[float]
            Maximum number of connectors to return [0, 100].

        offset : typing.Optional[float]
            Number of connectors to skip before returning results [0, inf].

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListConnectorsResponse
            OK

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.connectors.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "connectors", method="GET", params={"limit": limit, "offset": offset}, request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(ListConnectorsResponse, construct_type(type_=ListConnectorsResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        *,
        name: str,
        url: str,
        description: typing.Optional[str] = OMIT,
        excludes: typing.Optional[typing.Sequence[str]] = OMIT,
        oauth: typing.Optional[CreateConnectorOAuth] = OMIT,
        active: typing.Optional[bool] = OMIT,
        continue_on_failure: typing.Optional[bool] = OMIT,
        service_auth: typing.Optional[CreateConnectorServiceAuth] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateConnectorResponse:
        """
        Creates a new connector. The connector is tested during registration and will cancel registration when the test is unsuccessful. See ['Creating and Deploying a Connector'](https://docs.cohere.com/docs/creating-and-deploying-a-connector) for more information.

        Parameters
        ----------
        name : str
            A human-readable name for the connector.

        url : str
            The URL of the connector that will be used to search for documents.

        description : typing.Optional[str]
            A description of the connector.

        excludes : typing.Optional[typing.Sequence[str]]
            A list of fields to exclude from the prompt (fields remain in the document).

        oauth : typing.Optional[CreateConnectorOAuth]
            The OAuth 2.0 configuration for the connector. Cannot be specified if service_auth is specified.

        active : typing.Optional[bool]
            Whether the connector is active or not.

        continue_on_failure : typing.Optional[bool]
            Whether a chat request should continue or not if the request to this connector fails.

        service_auth : typing.Optional[CreateConnectorServiceAuth]
            The service to service authentication configuration for the connector. Cannot be specified if oauth is specified.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateConnectorResponse
            OK

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.connectors.create(
            name="name",
            url="url",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "connectors",
            method="POST",
            json={
                "name": name,
                "description": description,
                "url": url,
                "excludes": excludes,
                "oauth": oauth,
                "active": active,
                "continue_on_failure": continue_on_failure,
                "service_auth": service_auth,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(CreateConnectorResponse, construct_type(type_=CreateConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetConnectorResponse:
        """
        Retrieve a connector by ID. See ['Connectors'](https://docs.cohere.com/docs/connectors) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectorResponse
            OK

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.connectors.get(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(GetConnectorResponse, construct_type(type_=GetConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeleteConnectorResponse:
        """
        Delete a connector by ID. See ['Connectors'](https://docs.cohere.com/docs/connectors) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteConnectorResponse
            OK

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.connectors.delete(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DeleteConnectorResponse, construct_type(type_=DeleteConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        url: typing.Optional[str] = OMIT,
        excludes: typing.Optional[typing.Sequence[str]] = OMIT,
        oauth: typing.Optional[CreateConnectorOAuth] = OMIT,
        active: typing.Optional[bool] = OMIT,
        continue_on_failure: typing.Optional[bool] = OMIT,
        service_auth: typing.Optional[CreateConnectorServiceAuth] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateConnectorResponse:
        """
        Update a connector by ID. Omitted fields will not be updated. See ['Managing your Connector'](https://docs.cohere.com/docs/managing-your-connector) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to update.

        name : typing.Optional[str]
            A human-readable name for the connector.

        url : typing.Optional[str]
            The URL of the connector that will be used to search for documents.

        excludes : typing.Optional[typing.Sequence[str]]
            A list of fields to exclude from the prompt (fields remain in the document).

        oauth : typing.Optional[CreateConnectorOAuth]
            The OAuth 2.0 configuration for the connector. Cannot be specified if service_auth is specified.

        active : typing.Optional[bool]

        continue_on_failure : typing.Optional[bool]

        service_auth : typing.Optional[CreateConnectorServiceAuth]
            The service to service authentication configuration for the connector. Cannot be specified if oauth is specified.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateConnectorResponse
            OK

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.connectors.update(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "url": url,
                "excludes": excludes,
                "oauth": oauth,
                "active": active,
                "continue_on_failure": continue_on_failure,
                "service_auth": service_auth,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(UpdateConnectorResponse, construct_type(type_=UpdateConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def o_auth_authorize(
        self,
        id: str,
        *,
        after_token_redirect: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OAuthAuthorizeResponse:
        """
        Authorize the connector with the given ID for the connector oauth app. See ['Connector Authentication'](https://docs.cohere.com/docs/connector-authentication) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to authorize.

        after_token_redirect : typing.Optional[str]
            The URL to redirect to after the connector has been authorized.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OAuthAuthorizeResponse
            OK

        Examples
        --------
        from cohere.client import Client

        client = Client(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        client.connectors.o_auth_authorize(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}/oauth/authorize",
            method="POST",
            params={"after_token_redirect": after_token_redirect},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(OAuthAuthorizeResponse, construct_type(type_=OAuthAuthorizeResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncConnectorsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        limit: typing.Optional[float] = None,
        offset: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListConnectorsResponse:
        """
        Returns a list of connectors ordered by descending creation date (newer first). See ['Managing your Connector'](https://docs.cohere.com/docs/managing-your-connector) for more information.

        Parameters
        ----------
        limit : typing.Optional[float]
            Maximum number of connectors to return [0, 100].

        offset : typing.Optional[float]
            Number of connectors to skip before returning results [0, inf].

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListConnectorsResponse
            OK

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.connectors.list()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "connectors", method="GET", params={"limit": limit, "offset": offset}, request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(ListConnectorsResponse, construct_type(type_=ListConnectorsResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        *,
        name: str,
        url: str,
        description: typing.Optional[str] = OMIT,
        excludes: typing.Optional[typing.Sequence[str]] = OMIT,
        oauth: typing.Optional[CreateConnectorOAuth] = OMIT,
        active: typing.Optional[bool] = OMIT,
        continue_on_failure: typing.Optional[bool] = OMIT,
        service_auth: typing.Optional[CreateConnectorServiceAuth] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateConnectorResponse:
        """
        Creates a new connector. The connector is tested during registration and will cancel registration when the test is unsuccessful. See ['Creating and Deploying a Connector'](https://docs.cohere.com/docs/creating-and-deploying-a-connector) for more information.

        Parameters
        ----------
        name : str
            A human-readable name for the connector.

        url : str
            The URL of the connector that will be used to search for documents.

        description : typing.Optional[str]
            A description of the connector.

        excludes : typing.Optional[typing.Sequence[str]]
            A list of fields to exclude from the prompt (fields remain in the document).

        oauth : typing.Optional[CreateConnectorOAuth]
            The OAuth 2.0 configuration for the connector. Cannot be specified if service_auth is specified.

        active : typing.Optional[bool]
            Whether the connector is active or not.

        continue_on_failure : typing.Optional[bool]
            Whether a chat request should continue or not if the request to this connector fails.

        service_auth : typing.Optional[CreateConnectorServiceAuth]
            The service to service authentication configuration for the connector. Cannot be specified if oauth is specified.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateConnectorResponse
            OK

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.connectors.create(
            name="name",
            url="url",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "connectors",
            method="POST",
            json={
                "name": name,
                "description": description,
                "url": url,
                "excludes": excludes,
                "oauth": oauth,
                "active": active,
                "continue_on_failure": continue_on_failure,
                "service_auth": service_auth,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(CreateConnectorResponse, construct_type(type_=CreateConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetConnectorResponse:
        """
        Retrieve a connector by ID. See ['Connectors'](https://docs.cohere.com/docs/connectors) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectorResponse
            OK

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.connectors.get(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}", method="GET", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(GetConnectorResponse, construct_type(type_=GetConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteConnectorResponse:
        """
        Delete a connector by ID. See ['Connectors'](https://docs.cohere.com/docs/connectors) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteConnectorResponse
            OK

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.connectors.delete(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}", method="DELETE", request_options=request_options
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(DeleteConnectorResponse, construct_type(type_=DeleteConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        url: typing.Optional[str] = OMIT,
        excludes: typing.Optional[typing.Sequence[str]] = OMIT,
        oauth: typing.Optional[CreateConnectorOAuth] = OMIT,
        active: typing.Optional[bool] = OMIT,
        continue_on_failure: typing.Optional[bool] = OMIT,
        service_auth: typing.Optional[CreateConnectorServiceAuth] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateConnectorResponse:
        """
        Update a connector by ID. Omitted fields will not be updated. See ['Managing your Connector'](https://docs.cohere.com/docs/managing-your-connector) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to update.

        name : typing.Optional[str]
            A human-readable name for the connector.

        url : typing.Optional[str]
            The URL of the connector that will be used to search for documents.

        excludes : typing.Optional[typing.Sequence[str]]
            A list of fields to exclude from the prompt (fields remain in the document).

        oauth : typing.Optional[CreateConnectorOAuth]
            The OAuth 2.0 configuration for the connector. Cannot be specified if service_auth is specified.

        active : typing.Optional[bool]

        continue_on_failure : typing.Optional[bool]

        service_auth : typing.Optional[CreateConnectorServiceAuth]
            The service to service authentication configuration for the connector. Cannot be specified if oauth is specified.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateConnectorResponse
            OK

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.connectors.update(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "url": url,
                "excludes": excludes,
                "oauth": oauth,
                "active": active,
                "continue_on_failure": continue_on_failure,
                "service_auth": service_auth,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(UpdateConnectorResponse, construct_type(type_=UpdateConnectorResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def o_auth_authorize(
        self,
        id: str,
        *,
        after_token_redirect: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OAuthAuthorizeResponse:
        """
        Authorize the connector with the given ID for the connector oauth app. See ['Connector Authentication'](https://docs.cohere.com/docs/connector-authentication) for more information.

        Parameters
        ----------
        id : str
            The ID of the connector to authorize.

        after_token_redirect : typing.Optional[str]
            The URL to redirect to after the connector has been authorized.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OAuthAuthorizeResponse
            OK

        Examples
        --------
        from cohere.client import AsyncClient

        client = AsyncClient(
            client_name="YOUR_CLIENT_NAME",
            token="YOUR_TOKEN",
        )
        await client.connectors.o_auth_authorize(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connectors/{jsonable_encoder(id)}/oauth/authorize",
            method="POST",
            params={"after_token_redirect": after_token_redirect},
            request_options=request_options,
        )
        if 200 <= _response.status_code < 300:
            return typing.cast(OAuthAuthorizeResponse, construct_type(type_=OAuthAuthorizeResponse, object_=_response.json()))  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 401:
            raise UnauthorizedError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 403:
            raise ForbiddenError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 404:
            raise NotFoundError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 422:
            raise UnprocessableEntityError(
                typing.cast(UnprocessableEntityErrorBody, construct_type(type_=UnprocessableEntityErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 429:
            raise TooManyRequestsError(
                typing.cast(TooManyRequestsErrorBody, construct_type(type_=TooManyRequestsErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 499:
            raise ClientClosedRequestError(
                typing.cast(ClientClosedRequestErrorBody, construct_type(type_=ClientClosedRequestErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 500:
            raise InternalServerError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 501:
            raise NotImplementedError(
                typing.cast(NotImplementedErrorBody, construct_type(type_=NotImplementedErrorBody, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 503:
            raise ServiceUnavailableError(
                typing.cast(typing.Any, construct_type(type_=typing.Any, object_=_response.json()))  # type: ignore
            )
        if _response.status_code == 504:
            raise GatewayTimeoutError(
                typing.cast(GatewayTimeoutErrorBody, construct_type(type_=GatewayTimeoutErrorBody, object_=_response.json()))  # type: ignore
            )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
