# GODAVD - GO essential webDAV server

[![Go Reference](https://pkg.go.dev/badge/github.com/pirmd/godavd.svg)](https://pkg.go.dev/github.com/pirmd/godavd)
[![Go Report Card](https://goreportcard.com/badge/github.com/pirmd/godavd)](https://goreportcard.com/report/github.com/pirmd/godavd)

`godavd` is a CGI application that implements essential webdav functionalities.

`godavd` is intentionally kept as minimal as possible, leaving most of the heavy
work to whatever battle-tested http stack you want to use to deploy it. 

`godavd` simply glues together [webdav package](https://pkg.go.dev/golang.org/x/net/webdav) with
[standard's library CGI module](http://pkg.go.dev/net/http/cgi).

## INSTALLATION

CGI application can be generated by running `make build`. Resulting static
binary can then be deployed to whatever location your CGI-aware http server is
expecting to find it.

## CONFIGURATION

Configuration is done using environment variables:
- `GODAV_DIR`: directory that shall be exposed through WebDAV server. Default to DOCUMENT_ROOT;
- `GODAV_URL_PREFIX`: URL prefix. Default to SCRIPT_NAME.

## CONTRIBUTION

If you feel like to contribute, just follow github guidelines on
[forking](https://help.github.com/articles/fork-a-repo/) then [send a pull
request](https://help.github.com/articles/creating-a-pull-request/)


[modeline]: # ( vim: set fenc=utf-8 spell spl=en: )
