import { FilteredMap } from '@pinpoint-fe/constants';

export const prevNode = {
  key: 'key',
  applicationName: 'application',
  category: 'UNAUTHORIZED',
  serviceType: 'UNAUTHORIZED',
  serviceTypeCode: 1007,
  isWas: true,
  isQueue: false,
  isAuthorized: false,
  totalCount: 0,
  errorCount: 0,
  slowCount: 0,
  hasAlert: false,
  responseStatistics: {
    Tot: 0,
    Sum: 0,
    Avg: 0,
    Max: 0,
  },
  histogram: {
    '1s': 0,
    '3s': 0,
    '5s': 0,
    Slow: 0,
    Error: 0,
  },
  apdexScore: 0,
  apdexFormula: {
    satisfiedCount: 0,
    toleratingCount: 0,
    totalSamples: 0,
  },
  agentHistogram: {},
  agentResponseStatistics: {},
  timeSeriesHistogram: [
    {
      key: '1s',
      values: [],
    },
    {
      key: '3s',
      values: [],
    },
    {
      key: '5s',
      values: [],
    },
    {
      key: 'Slow',
      values: [],
    },
    {
      key: 'Error',
      values: [],
    },
    {
      key: 'Avg',
      values: [],
    },
    {
      key: 'Max',
      values: [],
    },
    {
      key: 'Sum',
      values: [],
    },
    {
      key: 'Tot',
      values: [],
    },
  ],
  agentTimeSeriesHistogram: {},
  instanceCount: 1,
  instanceErrorCount: 0,
  agentIds: ['UNAUTHORIZED_AGENT'],
  agentIdNameMap: {
    UNAUTHORIZED_AGENT: null,
  },
  serverList: {
    UNAUTHORIZED_AGENT: {
      name: 'UNAUTHORIZED_AGENT',
      status: null,
      linkList: [],
      instanceList: {
        UNAUTHORIZED_AGENT: {
          hasInspector: true,
          name: 'UNAUTHORIZED_AGENT',
          agentName: null,
          serviceType: 'UNAUTHORIZED',
          status: {
            code: -1,
            desc: 'Unknown',
          },
        },
      },
    },
  },
};

export const newNode = {
  key: 'key',
  applicationName: 'application',
  category: 'UNAUTHORIZED',
  serviceType: 'UNAUTHORIZED',
  serviceTypeCode: 1007,
  isWas: true,
  isQueue: false,
  isAuthorized: false,
  totalCount: 0,
  errorCount: 0,
  slowCount: 0,
  hasAlert: false,
  responseStatistics: {
    Tot: 0,
    Sum: 0,
    Avg: 0,
    Max: 0,
  },
  histogram: {
    '1s': 0,
    '3s': 0,
    '5s': 0,
    Slow: 0,
    Error: 0,
  },
  apdexScore: 0,
  apdexFormula: {
    satisfiedCount: 0,
    toleratingCount: 0,
    totalSamples: 0,
  },
  agentHistogram: {},
  agentResponseStatistics: {},
  timeSeriesHistogram: [
    {
      key: '1s',
      values: [],
    },
    {
      key: '3s',
      values: [],
    },
    {
      key: '5s',
      values: [],
    },
    {
      key: 'Slow',
      values: [],
    },
    {
      key: 'Error',
      values: [],
    },
    {
      key: 'Avg',
      values: [],
    },
    {
      key: 'Max',
      values: [],
    },
    {
      key: 'Sum',
      values: [],
    },
    {
      key: 'Tot',
      values: [],
    },
  ],
  agentTimeSeriesHistogram: {},
  instanceCount: 1,
  instanceErrorCount: 0,
  agentIds: ['UNAUTHORIZED_AGENT'],
  agentIdNameMap: {
    UNAUTHORIZED_AGENT: null,
  },
  serverList: {
    UNAUTHORIZED_AGENT: {
      name: 'UNAUTHORIZED_AGENT',
      status: null,
      linkList: [],
      instanceList: {
        UNAUTHORIZED_AGENT: {
          hasInspector: true,
          name: 'UNAUTHORIZED_AGENT',
          agentName: null,
          serviceType: 'UNAUTHORIZED',
          status: {
            code: -1,
            desc: 'Unknown',
          },
        },
      },
    },
  },
};

export const resultNode = {
  key: 'key',
  applicationName: 'application',
  category: 'UNAUTHORIZED',
  serviceType: 'UNAUTHORIZED',
  serviceTypeCode: 1007,
  isWas: true,
  isQueue: false,
  isAuthorized: false,
  totalCount: 0,
  errorCount: 0,
  slowCount: 0,
  hasAlert: false,
  responseStatistics: {
    Tot: 0,
    Sum: 0,
    Avg: 0,
    Max: 0,
  },
  histogram: {
    '1s': 0,
    '3s': 0,
    '5s': 0,
    Slow: 0,
    Error: 0,
  },
  apdexScore: 0,
  apdexFormula: {
    satisfiedCount: 0,
    toleratingCount: 0,
    totalSamples: 0,
  },
  agentHistogram: {},
  agentResponseStatistics: {},
  timeSeriesHistogram: [
    {
      key: '1s',
      values: [],
    },
    {
      key: '3s',
      values: [],
    },
    {
      key: '5s',
      values: [],
    },
    {
      key: 'Slow',
      values: [],
    },
    {
      key: 'Error',
      values: [],
    },
    {
      key: 'Avg',
      values: [],
    },
    {
      key: 'Max',
      values: [],
    },
    {
      key: 'Sum',
      values: [],
    },
    {
      key: 'Tot',
      values: [],
    },
  ],
  agentTimeSeriesHistogram: {},
  instanceCount: 1,
  instanceErrorCount: 0,
  agentIds: ['UNAUTHORIZED_AGENT'],
  agentIdNameMap: {
    UNAUTHORIZED_AGENT: null,
  },
  serverList: {
    UNAUTHORIZED_AGENT: {
      name: 'UNAUTHORIZED_AGENT',
      status: null,
      linkList: [],
      instanceList: {
        UNAUTHORIZED_AGENT: {
          hasInspector: true,
          name: 'UNAUTHORIZED_AGENT',
          agentName: null,
          serviceType: 'UNAUTHORIZED',
          status: {
            code: -1,
            desc: 'Unknown',
          },
        },
      },
    },
  },
};

export const prevLink: FilteredMap.LinkData = {
  key: 'key',
  from: 'fromApp',
  to: 'toApp^UNAUTHORIZED',
  fromAgent: ['fromAgent', 'toAgent'],
  toAgent: ['UNAUTHORIZED_AGENT'],
  fromAgentIdNameMap: {
    fromAgent: '',
    toAgent: '',
  },
  toAgentIdNameMap: {
    UNAUTHORIZED_AGENT: null,
  },
  sourceInfo: {
    applicationName: 'app3',
    serviceType: 'VERTX',
    serviceTypeCode: 1050,
    isWas: true,
  },
  targetInfo: {
    applicationName: 'toApp',
    serviceType: 'UNAUTHORIZED',
    serviceTypeCode: 1007,
    isWas: true,
  },
  filterApplicationName: 'app3',
  filterApplicationServiceTypeCode: 1050,
  filterApplicationServiceTypeName: 'VERTX',
  filterTargetRpcList: [],
  totalCount: 1,
  errorCount: 0,
  slowCount: 0,
  responseStatistics: {
    Tot: 1,
    Sum: 41,
    Avg: 41,
    Max: 41,
  },
  histogram: {
    '1s': 1,
    '3s': 0,
    '5s': 0,
    Slow: 0,
    Error: 0,
  },
  timeSeriesHistogram: [
    {
      key: '1s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 1],
      ],
    },
    {
      key: '3s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: '5s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Slow',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Error',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Avg',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 41],
      ],
    },
    {
      key: 'Max',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 41],
      ],
    },
    {
      key: 'Sum',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 41],
      ],
    },
    {
      key: 'Tot',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 1],
      ],
    },
  ],
  sourceHistogram: {},
  targetHistogram: {},
  sourceTimeSeriesHistogram: {},
  sourceResponseStatistics: {},
  targetResponseStatistics: {},
  hasAlert: false,
};
export const newLink = {
  key: 'key',
  from: 'fromApp',
  to: 'toApp^UNAUTHORIZED',
  fromAgent: ['fromAgent', 'toAgent'],
  toAgent: ['UNAUTHORIZED_AGENT'],
  fromAgentIdNameMap: {
    fromAgent: '',
    toAgent: '',
  },
  toAgentIdNameMap: {
    UNAUTHORIZED_AGENT: null,
  },
  sourceInfo: {
    applicationName: 'app3',
    serviceType: 'VERTX',
    serviceTypeCode: 1050,
    isWas: true,
  },
  targetInfo: {
    applicationName: 'toApp',
    serviceType: 'UNAUTHORIZED',
    serviceTypeCode: 1007,
    isWas: true,
  },
  filterApplicationName: 'app3',
  filterApplicationServiceTypeCode: 1050,
  filterApplicationServiceTypeName: 'VERTX',
  filterTargetRpcList: [],
  totalCount: 2,
  errorCount: 0,
  slowCount: 0,
  responseStatistics: {
    Tot: 2,
    Sum: 54,
    Avg: 27,
    Max: 28,
  },
  histogram: {
    '1s': 2,
    '3s': 0,
    '5s': 0,
    Slow: 0,
    Error: 0,
  },
  timeSeriesHistogram: [
    {
      key: '1s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 2],
        [1699604400000, 0],
      ],
    },
    {
      key: '3s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: '5s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Slow',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Error',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Avg',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 27],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Max',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 28],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Sum',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 54],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Tot',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 2],
        [1699604400000, 0],
      ],
    },
  ],
  sourceHistogram: {},
  targetHistogram: {},
  sourceTimeSeriesHistogram: {},
  sourceResponseStatistics: {},
  targetResponseStatistics: {},
  hasAlert: false,
};
export const resultLink = {
  key: 'key',
  from: 'fromApp',
  to: 'toApp^UNAUTHORIZED',
  fromAgent: ['fromAgent', 'toAgent'],
  toAgent: ['UNAUTHORIZED_AGENT'],
  fromAgentIdNameMap: {
    fromAgent: '',
    toAgent: '',
  },
  toAgentIdNameMap: {
    UNAUTHORIZED_AGENT: null,
  },
  sourceInfo: {
    applicationName: 'app3',
    serviceType: 'VERTX',
    serviceTypeCode: 1050,
    isWas: true,
  },
  targetInfo: {
    applicationName: 'toApp',
    serviceType: 'UNAUTHORIZED',
    serviceTypeCode: 1007,
    isWas: true,
  },
  filterApplicationName: 'app3',
  filterApplicationServiceTypeCode: 1050,
  filterApplicationServiceTypeName: 'VERTX',
  filterTargetRpcList: [],
  totalCount: 3,
  errorCount: 0,
  slowCount: 0,
  responseStatistics: {
    Tot: 3,
    Sum: 95,
    Avg: 31,
    Max: 41,
  },
  histogram: {
    '1s': 3,
    '3s': 0,
    '5s': 0,
    Slow: 0,
    Error: 0,
  },
  timeSeriesHistogram: [
    {
      key: '1s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 2],
        [1699604400000, 1],
      ],
    },
    {
      key: '3s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: '5s',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Slow',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Error',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 0],
        [1699604400000, 0],
      ],
    },
    {
      key: 'Avg',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 27],
        [1699604400000, 41],
      ],
    },
    {
      key: 'Max',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 28],
        [1699604400000, 41],
      ],
    },
    {
      key: 'Sum',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 54],
        [1699604400000, 41],
      ],
    },
    {
      key: 'Tot',
      values: [
        [1699604100000, 0],
        [1699604160000, 0],
        [1699604220000, 0],
        [1699604280000, 0],
        [1699604340000, 2],
        [1699604400000, 1],
      ],
    },
  ],
  sourceHistogram: {},
  targetHistogram: {},
  sourceTimeSeriesHistogram: {},
  sourceResponseStatistics: {},
  targetResponseStatistics: {},
  hasAlert: false,
};
