import { ComponentStory, ComponentMeta } from '@storybook/react';

import { LoadChart } from './LoadChart';

export default {
  title: 'PINPOINT/Component/Charts/LoadChart',
  component: LoadChart,
  argTypes: {
    backgroundColor: { control: 'color' },
  },
} as ComponentMeta<typeof LoadChart>;

const Template: ComponentStory<typeof LoadChart> = (args) => <LoadChart {...args} />;

export const Default = Template.bind({});
Default.args = {
  datas: {
    dates: [
      1679546760000, 1679546820000, 1679546880000, 1679546940000, 1679547000000, 1679547060000,
    ],
    '1s': [30, 30, 30, 30, 30, 30],
    '3s': [20, 10, 1, 0, 0, 0],
    '5s': [10, 5, 0, 0, 0, 0],
    Slow: [0, 0, 0, 0, 0, 0],
    Error: [0, 0, 0, 0, 0, 0],
  },
  colors: {
    '1s': 'rgba(52, 185, 148, 0.5)',
    '3s': 'rgba(81, 175, 223, 0.5)',
    '5s': 'rgba(255, 186, 0, 0.5)',
    Error: 'rgba(233, 84, 89, 0.5)',
    Slow: 'rgba(230, 127, 34, 0.5)',
  },
};

export const AvgMax = Template.bind({});
AvgMax.args = {
  datas: {
    dates: [
      1679528700000, 1679529000000, 1679529300000, 1679529600000, 1679529900000, 1679530200000,
      1679530500000, 1679530800000, 1679531100000, 1679531400000, 1679531700000, 1679532000000,
      1679532300000, 1679532600000, 1679532900000, 1679533200000, 1679533500000, 1679533800000,
      1679534100000, 1679534400000, 1679534700000, 1679535000000, 1679535300000, 1679535600000,
      1679535900000, 1679536200000, 1679536500000, 1679536800000, 1679537100000, 1679537400000,
      1679537700000, 1679538000000, 1679538300000, 1679538600000, 1679538900000, 1679539200000,
      1679539500000, 1679539800000, 1679540100000, 1679540400000, 1679540700000, 1679541000000,
      1679541300000, 1679541600000, 1679541900000, 1679542200000, 1679542500000, 1679542800000,
      1679543100000, 1679543400000, 1679543700000, 1679544000000, 1679544300000, 1679544600000,
      1679544900000, 1679545200000, 1679545500000, 1679545800000, 1679546100000, 1679546400000,
      1679546700000, 1679547000000, 1679547300000, 1679547600000, 1679547900000, 1679548200000,
      1679548500000, 1679548800000, 1679549100000, 1679549400000, 1679549700000, 1679550000000,
      1679550300000,
    ],
    Avg: [
      4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
      4, 4, 4, 4, 4, 4, 4, 4, 4, 9, 4,
    ],
    max: [
      0, 0, 0, 0, 0, 0, 1, 1, 4, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 5, 4, 3, 2, 1,
    ],
  },
  colors: {
    Avg: 'rgb(151,227,134)',
    Max: 'rgb(19,182,231)',
  },
};

export const NoData = Template.bind({});
NoData.args = {};
