import {Injectable} from '@angular/core';
import {HttpClient} from '@angular/common/http';
import {Observable} from 'rxjs';

export interface IInstallationData {
    code: number;
    message: {
        downloadUrl: string,
        installationArgument: string,
        version: string
    };
}

@Injectable()
export class ConfigurationInstallationDataService {
    private dataRequestURL = 'api/getAgentInstallationInfo';

    constructor(
        private http: HttpClient
    ) {
    }

    getData(): Observable<IInstallationData> {
        return this.http.get<IInstallationData>(this.dataRequestURL);
    }
}
