package com.navercorp.pinpoint.pinot.datasource;

import org.apache.pinot.client.base.AbstractBaseStatement;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public class StatementWrapper extends AbstractBaseStatement {

    private final Connection connection;
    private final ResultSet resultSet;

    private boolean close;

    public StatementWrapper(Connection connection, ResultSet resultSet) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.resultSet = Objects.requireNonNull(resultSet, "resultSet");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        this.close = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return resultSet;
    }


    /**
     * org.apache.ibatis.executor.resultset.DefaultResultSetHandler#getNextResultSet(Statement)
     */
    @Override
    public Connection getConnection() throws SQLException {
        // stmt.getConnection().getMetaData().supportsMultipleResultSets()
        return connection;
    }


    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return execute(sql);
    }


    @Override
    public boolean isClosed() throws SQLException {
        return close;
    }

    @Override
    protected void validateState() throws SQLException {
        if (isClosed()) {
            throw new SQLException("Statement is already closed!");
        }
    }
}
