package com.navercorp.pinpoint.pinot.datasource;

import org.apache.commons.codec.binary.Hex;
import org.apache.pinot.client.PreparedStatement;
import org.apache.pinot.client.base.AbstractBasePreparedStatement;
import org.apache.pinot.client.utils.DateTimeUtils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;

public class ParameterRecorder extends AbstractBasePreparedStatement {
    private PreparedStatement preparedStatement;

    public ParameterRecorder(PreparedStatement preparedStatement) {
        this.preparedStatement = Objects.requireNonNull(preparedStatement, "preparedStatement");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, "NULL");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, String.valueOf(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        preparedStatement.setInt(parameterIndex - 1, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        preparedStatement.setInt(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        preparedStatement.setLong(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        preparedStatement.setFloat(parameterIndex - 1, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        preparedStatement.setDouble(parameterIndex - 1, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, x.toString());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, Hex.encodeHexString(x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, DateTimeUtils.dateToString(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, DateTimeUtils.timeToString(x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, DateTimeUtils.timeStampToString(x));
    }


    @Override
    public void clearParameters() throws SQLException {

    }


    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        preparedStatement.setString(parameterIndex - 1, "NULL");
    }


    @Override
    protected void validateState() throws SQLException {
    }



    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }


    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }


    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }


    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

}
