/*
 * Copyright 2019 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.plugin.config.PluginLoadingConfig;

import java.util.List;
import java.util.Objects;

/**
 * @author Woonduk Kang(emeroad)
 */
public class DefaultPluginFilterFactory implements PluginFilterFactory {

    private final List<String> disabledPlugins;

    public DefaultPluginFilterFactory(PluginLoadingConfig pluginLoadingConfig) {
        Objects.requireNonNull(pluginLoadingConfig, "pluginLoadingConfig");

        this.disabledPlugins = pluginLoadingConfig.getDisabledPlugins();
    }

    @Override
    public PluginFilter newPluginFilter() {
        if (CollectionUtils.isEmpty(disabledPlugins)) {
            return new JavaVersionFilter();
        }

        PluginFilter javaVersionFilter = new JavaVersionFilter();
        PluginFilter disabledPluginFilter = new DisabledPluginFilter(disabledPlugins);
        return new PluginFilters(disabledPluginFilter, javaVersionFilter);
    }
}
