/*
 * Copyright 2017 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.profiler.monitor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author Taejin Koo
 */
public class DisabledDeadlockMonitor implements DeadlockMonitor {

    private final Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public void start() {
        logger.info("DeadlockMonitor not started. caused profiler.monitor.deadlock.enable=false.");
    }

    @Override
    public void stop() {
    }

}
