/*
 * Copyright 2019 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.profiler.context.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentInfoMapper;
import com.navercorp.pinpoint.profiler.metadata.AgentInfo;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;

import java.util.Objects;

/**
 * @author Woonduk Kang(emeroad)
 */
public class GrpcAgentInfoMessageConverter implements MessageConverter<MetaDataType, GeneratedMessageV3> {
    private final AgentInfoMapper mapper;

    public GrpcAgentInfoMessageConverter(AgentInfoMapper agentInfoMapper) {
        this.mapper = Objects.requireNonNull(agentInfoMapper, "agentInfoMapper");
    }

    @Override
    public GeneratedMessageV3 toMessage(MetaDataType message) {
        if (message instanceof AgentInfo) {
            final AgentInfo agentInfo = (AgentInfo) message;
            return mapper.map(agentInfo);
        }
        return null;
    }
}
