/*
 * Copyright 2019 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.profiler.context.id.TraceRoot;

import java.util.List;
import java.util.Objects;

/**
 * @author Woonduk Kang(emeroad)
 */
public class DefaultAsyncSpanChunk extends DefaultSpanChunk implements AsyncSpanChunk {

    private final LocalAsyncId localAsyncId;

    public DefaultAsyncSpanChunk(TraceRoot traceRoot, List<SpanEvent> spanEventList, LocalAsyncId localAsyncId) {
        super(traceRoot, spanEventList);
        this.localAsyncId = Objects.requireNonNull(localAsyncId, "localAsyncId");
    }

    @Override
    public LocalAsyncId getLocalAsyncId() {
        return localAsyncId;
    }

    @Override
    public String toString() {
        return "DefaultAsyncSpanChunk{" +
                "localAsyncId=" + localAsyncId +
                "} " + super.toString();
    }
}
