package com.navercorp.pinpoint.plugin.spring.web.jakarta.interceptor;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.common.util.ArrayArgumentUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.plugin.spring.web.SpringWebMvcConstants;
import jakarta.servlet.ServletRequest;

public class ProcessRequestInterceptor implements AroundInterceptor {
    private final PluginLogger logger = PluginLogManager.getLogger(getClass());
    private final boolean isDebug = logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final Boolean uriStatUseUserInput;

    public ProcessRequestInterceptor(final TraceContext traceContext, Boolean uriStatUseUserInput) {
        this.traceContext = traceContext;
        this.uriStatUseUserInput = uriStatUseUserInput;
    }

    @Override
    public void before(Object target, Object[] args) {
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (Boolean.FALSE == uriStatUseUserInput) {
            return;
        }

        final Trace trace = traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }

        try {
            final ServletRequest request = ArrayArgumentUtils.getArgument(args, 0, ServletRequest.class);
            if (request != null) {
                final String uri = ServletRequestAttributeUtils.extractAttribute(request, SpringWebMvcConstants.SPRING_MVC_URI_USER_INPUT_ATTRIBUTE_KEYS);

                if (isDebug) {
                    logger.debug("Attempt recording URI with template: {}", uri);
                }

                if (StringUtils.hasLength(uri)) {
                    final SpanRecorder spanRecorder = trace.getSpanRecorder();
                    spanRecorder.recordUriTemplate(uri, true);
                }
            }
        } catch (Throwable th) {
            if (logger.isWarnEnabled()) {
                logger.warn("AFTER error. Caused:{}", th.getMessage(), th);
            }
        }
    }
}
