/*
 * Copyright 2018 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package test.pinpoint.plugin.rabbitmq;

import java.nio.charset.StandardCharsets;

/**
 * @author HyunGil Jeong
 */
public interface MessageConverter<T> {
    T convertMessage(byte[] messageBody);

    MessageConverter<String> FOR_TEST = new MessageConverter<String>() {
        @Override
        public String convertMessage(byte[] messageBody) {
            return new String(messageBody, StandardCharsets.UTF_8);
        }
    };
}
