/*
 * Copyright 2022 NAVER Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.navercorp.pinpoint.bootstrap.plugin.reactor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;

public class MockAsyncContextAndReactorContextImpl implements AsyncContextAccessor, ReactorContextAccessor {
    private AsyncContext asyncContext;
    private AsyncContext reactorContext;

    @Override
    public void _$PINPOINT$_setAsyncContext(AsyncContext asyncContext) {
        this.asyncContext = asyncContext;
    }

    @Override
    public AsyncContext _$PINPOINT$_getAsyncContext() {
        return asyncContext;
    }

    @Override
    public void _$PINPOINT$_setReactorContext(AsyncContext reactorContext) {
        this.reactorContext = reactorContext;
    }

    @Override
    public AsyncContext _$PINPOINT$_getReactorContext() {
        return reactorContext;
    }
}
