/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.mesos;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging$;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import com.adobe.api.platform.runtime.mesos.Bridge$;
import com.adobe.api.platform.runtime.mesos.CommandDef;
import com.adobe.api.platform.runtime.mesos.CommandDef$;
import com.adobe.api.platform.runtime.mesos.Constraint;
import com.adobe.api.platform.runtime.mesos.DeleteTask;
import com.adobe.api.platform.runtime.mesos.HealthCheckConfig;
import com.adobe.api.platform.runtime.mesos.Host$;
import com.adobe.api.platform.runtime.mesos.Network;
import com.adobe.api.platform.runtime.mesos.Running;
import com.adobe.api.platform.runtime.mesos.SubmitTask;
import com.adobe.api.platform.runtime.mesos.TaskDef;
import com.adobe.api.platform.runtime.mesos.User;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.LoggingMarkers$;
import org.apache.openwhisk.common.MetricEmitter$;
import org.apache.openwhisk.common.StartMarker;
import org.apache.openwhisk.common.TransactionId$;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.containerpool.Container;
import org.apache.openwhisk.core.containerpool.ContainerAddress;
import org.apache.openwhisk.core.containerpool.ContainerId;
import org.apache.openwhisk.core.entity.ByteSize;
import org.apache.openwhisk.core.entity.size$;
import org.apache.openwhisk.core.mesos.MesosConfig;
import org.apache.openwhisk.core.mesos.MesosTask;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class MesosTask$ {
    public static MesosTask$ MODULE$;
    private final String LAUNCH_CMD;
    private final String KILL_CMD;

    static {
        new MesosTask$();
    }

    public String LAUNCH_CMD() {
        return this.LAUNCH_CMD;
    }

    public String KILL_CMD() {
        return this.KILL_CMD;
    }

    public Future<Container> create(ActorRef mesosClientActor, MesosConfig mesosConfig, Function0<String> taskIdGenerator, TransactionMetadata transid, String image, boolean userProvidedImage, ByteSize memory, int cpuShares, Map<String, String> environment, String network, Seq<String> dnsServers, Option<String> name, Map<String, Set<String>> parameters, Seq<Constraint> constraints, ExecutionContext ec, Logging log, ActorSystem as) {
        TransactionMetadata tid = transid;
        double mesosCpuShares = (double)cpuShares / 1024.0;
        int mesosRam = (int)memory.toMB();
        String taskId = (String)taskIdGenerator.apply();
        String lowerNetwork = network.toLowerCase();
        String string = lowerNetwork;
        Object object = "bridge".equals(string) ? Bridge$.MODULE$ : ("host".equals(string) ? Host$.MODULE$ : new User(network));
        Bridge$ taskNetwork = object;
        Map dnsOrEmpty = dnsServers.nonEmpty() ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dns"), (Object)dnsServers.toSet())})) : Predef$.MODULE$.Map().empty();
        Option healthCheckConfig = mesosConfig.healthCheck().map((Function1 & Serializable & scala.Serializable)c -> new HealthCheckConfig(c.portIndex(), (double)c.delay().toSeconds(), (double)c.interval().toSeconds(), (double)c.timeout().toSeconds(), (double)c.gracePeriod().toSeconds(), c.maxConsecutiveFailures()));
        TaskDef task = new TaskDef(taskId, (String)name.getOrElse((Function0 & Serializable & scala.Serializable)() -> image), image, mesosCpuShares, mesosRam, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8080})), healthCheckConfig, false, (Network)taskNetwork, (Map)dnsOrEmpty.$plus$plus(parameters, Map$.MODULE$.canBuildFrom()), (Option)new Some((Object)new CommandDef(environment, CommandDef$.MODULE$.apply$default$2())), constraints.toSet());
        Timeout taskLaunchTimeout = new Timeout(mesosConfig.timeouts().taskLaunch());
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.INVOKER_MESOS_CMD(this.LAUNCH_CMD()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("launching mesos task for taskid ").append(taskId).append(" (image:").append(image).append(", mem: ").append(mesosRam).append(", cpu: ").append(mesosCpuShares).append(") (timeout: ").append(taskLaunchTimeout).append(")").toString(), Logging$.MODULE$.InfoLevel(), log);
        ActorRef qual$1 = package$.MODULE$.ask(mesosClientActor);
        SubmitTask x$2 = new SubmitTask(task);
        Timeout x$3 = taskLaunchTimeout;
        ActorRef x$4 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$2);
        Future launched = AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)x$2, x$3, x$4).mapTo(ClassTag$.MODULE$.apply(Running.class));
        return launched.andThen((PartialFunction)new scala.Serializable(mesosClientActor, mesosConfig, transid, ec, log, tid, taskId, start){
            public static final long serialVersionUID = 0L;
            private final ActorRef mesosClientActor$1;
            private final MesosConfig mesosConfig$1;
            private final TransactionMetadata transid$1;
            private final ExecutionContext ec$1;
            private final Logging log$1;
            private final TransactionMetadata tid$1;
            private final String taskId$1;
            private final StartMarker start$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Try<Running>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<BoxedUnit> future;
                boolean bl = false;
                Failure failure = null;
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    Running taskDetails = (Running)success.value();
                    TransactionId$.MODULE$.finished$extension(this.transid$1, MesosTask$.MODULE$, this.start$1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("launched task ").append($this.taskId$1).append(" at ").append(taskDetails.hostname()).append(":").append(taskDetails.hostports().apply(0)).toString(), Logging$.MODULE$.InfoLevel(), TransactionId$.MODULE$.finished$default$5$extension(this.transid$1), this.log$1);
                    future = BoxedUnit.UNIT;
                    return (B1)future;
                }
                if (A1 instanceof Failure) {
                    bl = true;
                    failure = (Failure)A1;
                    Throwable ate = failure.exception();
                    if (ate instanceof AskTimeoutException) {
                        AskTimeoutException askTimeoutException = (AskTimeoutException)ate;
                        TransactionId$.MODULE$.failed$extension(this.transid$1, MesosTask$.MODULE$, this.start$1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("task launch timed out ").append(askTimeoutException.getMessage()).toString(), Logging$.MODULE$.ErrorLevel(), this.log$1);
                        MetricEmitter$.MODULE$.emitCounterMetric(LoggingMarkers$.MODULE$.INVOKER_MESOS_CMD_TIMEOUT(MesosTask$.MODULE$.LAUNCH_CMD()), MetricEmitter$.MODULE$.emitCounterMetric$default$2());
                        future = MesosTask$.MODULE$.org$apache$openwhisk$core$mesos$MesosTask$$destroy(this.mesosClientActor$1, this.mesosConfig$1, this.taskId$1, this.tid$1, this.log$1, this.ec$1);
                        return (B1)future;
                    }
                }
                if (bl) {
                    Throwable t = failure.exception();
                    MesosTask$.MODULE$.org$apache$openwhisk$core$mesos$MesosTask$$destroy(this.mesosClientActor$1, this.mesosConfig$1, this.taskId$1, this.tid$1, this.log$1, this.ec$1);
                    TransactionId$.MODULE$.failed$extension(this.transid$1, MesosTask$.MODULE$, this.start$1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("task launch failed ").append(t.getMessage()).toString(), Logging$.MODULE$.ErrorLevel(), this.log$1);
                    future = BoxedUnit.UNIT;
                    return (B1)future;
                }
                future = function1.apply(x1);
                return (B1)future;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Try<Running> x1) {
                boolean bl = false;
                Failure failure = null;
                Try<Running> try_ = x1;
                if (try_ instanceof Success) {
                    return true;
                }
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable ate = failure.exception();
                    if (ate instanceof AskTimeoutException) {
                        return true;
                    }
                }
                if (!bl) return false;
                return true;
            }
            {
                this.mesosClientActor$1 = mesosClientActor$1;
                this.mesosConfig$1 = mesosConfig$1;
                this.transid$1 = transid$1;
                this.ec$1 = ec$1;
                this.log$1 = log$1;
                this.tid$1 = tid$1;
                this.taskId$1 = taskId$1;
                this.start$1 = start$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.openwhisk.core.mesos.MesosTask$$anonfun$create$5 com.adobe.api.platform.runtime.mesos.Running ), $anonfun$applyOrElse$2(akka.pattern.AskTimeoutException ), $anonfun$applyOrElse$3(java.lang.Throwable )}, serializedLambda);
            }
        }, ec).map((Function1 & Serializable & scala.Serializable)taskDetails -> {
            String taskHost = taskDetails.hostname();
            int taskPort = BoxesRunTime.unboxToInt((Object)taskDetails.hostports().apply(0));
            ContainerAddress containerIp = new ContainerAddress(taskHost, taskPort);
            ContainerId containerId = new ContainerId(taskId);
            return new MesosTask(containerId, containerIp, ec, log, as, taskId, mesosClientActor, mesosConfig);
        }, ec);
    }

    public boolean create$default$6() {
        return false;
    }

    public ByteSize create$default$7() {
        return size$.MODULE$.SizeInt(256).MB();
    }

    public int create$default$8() {
        return 0;
    }

    public Map<String, String> create$default$9() {
        return Predef$.MODULE$.Map().empty();
    }

    public String create$default$10() {
        return "bridge";
    }

    public Seq<String> create$default$11() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<String> create$default$12() {
        return None$.MODULE$;
    }

    public Map<String, Set<String>> create$default$13() {
        return Predef$.MODULE$.Map().empty();
    }

    public Seq<Constraint> create$default$14() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Future<BoxedUnit> org$apache$openwhisk$core$mesos$MesosTask$$destroy(ActorRef mesosClientActor, MesosConfig mesosConfig, String taskId, TransactionMetadata transid, Logging logging, ExecutionContext ec) {
        Timeout taskDeleteTimeout = new Timeout(mesosConfig.timeouts().taskDelete());
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.INVOKER_MESOS_CMD(this.KILL_CMD()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("killing mesos taskid ").append(taskId).append(" (timeout: ").append(taskDeleteTimeout).append(")").toString(), Logging$.MODULE$.InfoLevel(), logging);
        ActorRef qual$2 = package$.MODULE$.ask(mesosClientActor);
        DeleteTask x$5 = new DeleteTask(taskId);
        Timeout x$6 = taskDeleteTimeout;
        ActorRef x$7 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$2, (Object)x$5);
        return AskableActorRef$.MODULE$.ask$extension1(qual$2, (Object)x$5, x$6, x$7).andThen((PartialFunction)new scala.Serializable(transid, logging, start){
            public static final long serialVersionUID = 0L;
            private final TransactionMetadata transid$2;
            private final Logging logging$1;
            private final StartMarker start$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Failure failure = null;
                A1 A1 = x2;
                if (A1 instanceof Success) {
                    MesosTask$ x$8 = MesosTask$.MODULE$;
                    StartMarker x$9 = this.start$2;
                    int x$10 = Logging$.MODULE$.InfoLevel();
                    Function0 & Serializable & scala.Serializable x$11 = (Function0 & Serializable & scala.Serializable)() -> TransactionId$.MODULE$.finished$default$3$extension($this.transid$2);
                    Instant x$12 = TransactionId$.MODULE$.finished$default$5$extension(this.transid$2);
                    TransactionId$.MODULE$.finished$extension(this.transid$2, x$8, x$9, (Function0<String>)x$11, x$10, x$12, this.logging$1);
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                if (A1 instanceof Failure) {
                    bl = true;
                    failure = (Failure)A1;
                    Throwable ate = failure.exception();
                    if (ate instanceof AskTimeoutException) {
                        AskTimeoutException askTimeoutException = (AskTimeoutException)ate;
                        TransactionId$.MODULE$.failed$extension(this.transid$2, MesosTask$.MODULE$, this.start$2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("task destroy timed out ").append(askTimeoutException.getMessage()).toString(), Logging$.MODULE$.ErrorLevel(), this.logging$1);
                        MetricEmitter$.MODULE$.emitCounterMetric(LoggingMarkers$.MODULE$.INVOKER_MESOS_CMD_TIMEOUT(MesosTask$.MODULE$.KILL_CMD()), MetricEmitter$.MODULE$.emitCounterMetric$default$2());
                        object = BoxedUnit.UNIT;
                        return (B1)object;
                    }
                }
                if (bl) {
                    Throwable t = failure.exception();
                    TransactionId$.MODULE$.failed$extension(this.transid$2, MesosTask$.MODULE$, this.start$2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("task destroy failed ").append(t.getMessage()).toString(), Logging$.MODULE$.ErrorLevel(), this.logging$1);
                    object = BoxedUnit.UNIT;
                    return (B1)object;
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Try<Object> x2) {
                boolean bl = false;
                Failure failure = null;
                Try<Object> try_ = x2;
                if (try_ instanceof Success) {
                    return true;
                }
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable ate = failure.exception();
                    if (ate instanceof AskTimeoutException) {
                        return true;
                    }
                }
                if (!bl) return false;
                return true;
            }
            {
                this.transid$2 = transid$2;
                this.logging$1 = logging$1;
                this.start$2 = start$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.openwhisk.core.mesos.MesosTask$$anonfun$org$apache$openwhisk$core$mesos$MesosTask$$destroy$1 ), $anonfun$applyOrElse$5(akka.pattern.AskTimeoutException ), $anonfun$applyOrElse$6(java.lang.Throwable )}, serializedLambda);
            }
        }, ec).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            MesosTask$.$anonfun$destroy$2(x$1);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public static final /* synthetic */ void $anonfun$destroy$2(Object x$1) {
    }

    private MesosTask$() {
        MODULE$ = this;
        this.LAUNCH_CMD = "launch";
        this.KILL_CMD = "kill";
    }
}

