/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.entity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openwhisk.core.entity.ByteSize;
import org.apache.openwhisk.core.entity.SizeUnits;
import org.apache.openwhisk.core.entity.SizeUnits$BYTE$;
import org.apache.openwhisk.core.entity.SizeUnits$KB$;
import org.apache.openwhisk.core.entity.SizeUnits$MB$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class ByteSize$
implements Serializable {
    public static ByteSize$ MODULE$;
    private final Pattern regex;
    private final String formatError;

    static {
        new ByteSize$();
    }

    private Pattern regex() {
        return this.regex;
    }

    public String formatError() {
        return this.formatError;
    }

    public ByteSize fromString(String sizeString) {
        SizeUnits.Unit unit;
        long size2;
        Matcher matcher = this.regex().matcher(sizeString);
        if (matcher.matches()) {
            size2 = new StringOps(Predef$.MODULE$.augmentString(matcher.group(1))).toLong();
            char c = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(matcher.group(2).charAt(0)));
            switch (c) {
                case 'B': {
                    unit = SizeUnits$BYTE$.MODULE$;
                    break;
                }
                case 'K': {
                    unit = SizeUnits$KB$.MODULE$;
                    break;
                }
                case 'M': {
                    unit = SizeUnits$MB$.MODULE$;
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                }
            }
        } else {
            throw new IllegalArgumentException(this.formatError());
        }
        SizeUnits.Unit unit2 = unit;
        return new ByteSize(size2, unit2);
    }

    public ByteSize apply(long size2, SizeUnits.Unit unit) {
        return new ByteSize(size2, unit);
    }

    public Option<Tuple2<Object, SizeUnits.Unit>> unapply(ByteSize x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)x$0.size()), (Object)x$0.unit()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ByteSize$() {
        MODULE$ = this;
        this.regex = new StringOps(Predef$.MODULE$.augmentString("(?i)\\s?(\\d+)\\s?(MB|KB|B|M|K)\\s?")).r().pattern();
        this.formatError = "Size Unit not supported. Only \"B\", \"K[B]\" and \"M[B]\" are supported.";
    }
}

