/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.database.memory;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.ContentType;
import akka.stream.ActorMaterializer;
import akka.stream.Materializer;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteStringBuilder;
import java.io.Serializable;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.LoggingMarkers$;
import org.apache.openwhisk.common.StartMarker;
import org.apache.openwhisk.common.TransactionId$;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.database.AttachResult;
import org.apache.openwhisk.core.database.AttachmentStore;
import org.apache.openwhisk.core.database.NoDocumentException;
import org.apache.openwhisk.core.database.StoreUtils$;
import org.apache.openwhisk.core.database.memory.MemoryAttachmentStore$Attachment$;
import org.apache.openwhisk.core.entity.DocId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u0001=\u0011Q#T3n_JL\u0018\t\u001e;bG\"lWM\u001c;Ti>\u0014XM\u0003\u0002\u0004\t\u00051Q.Z7pefT!!\u0002\u0004\u0002\u0011\u0011\fG/\u00192bg\u0016T!a\u0002\u0005\u0002\t\r|'/\u001a\u0006\u0003\u0013)\t\u0011b\u001c9f]^D\u0017n]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!aD!ui\u0006\u001c\u0007.\\3oiN#xN]3\t\u0011m\u0001!\u0011!Q\u0001\nq\ta\u0001\u001a2OC6,\u0007CA\u000f%\u001d\tq\"\u0005\u0005\u0002 %5\t\u0001E\u0003\u0002\"\u001d\u00051AH]8pizJ!a\t\n\u0002\rA\u0013X\rZ3g\u0013\t)cE\u0001\u0004TiJLgn\u001a\u0006\u0003GIA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006Y!K\u0001\u0007gf\u001cH/Z7\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013!B1di>\u0014(\"\u0001\u0018\u0002\t\u0005\\7.Y\u0005\u0003a-\u00121\"Q2u_J\u001c\u0016p\u001d;f[\"A!\u0007\u0001B\u0001B\u0003-1'A\u0004m_\u001e<\u0017N\\4\u0011\u0005Q:T\"A\u001b\u000b\u0005YB\u0011AB2p[6|g.\u0003\u00029k\t9Aj\\4hS:<\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b1B\u001e\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u0011\u0005qzT\"A\u001f\u000b\u0005yj\u0013AB:ue\u0016\fW.\u0003\u0002A{\t\t\u0012i\u0019;pe6\u000bG/\u001a:jC2L'0\u001a:\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\t!%\n\u0006\u0003F\u000f\"K\u0005C\u0001$\u0001\u001b\u0005\u0011\u0001\"\u0002\u0015B\u0001\bI\u0003\"\u0002\u001aB\u0001\b\u0019\u0004\"\u0002\u001eB\u0001\bY\u0004\"B\u000eB\u0001\u0004a\u0002\u0002\u0003'\u0001\u0005\u0004%\u0019FB'\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0013\u0012AC2p]\u000e,(O]3oi&\u00111\u000b\u0015\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDa!\u0016\u0001!\u0002\u0013q\u0015!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u0019!q\u000b\u0001#Y\u0005)\tE\u000f^1dQ6,g\u000e^\n\u0005-BIF\f\u0005\u0002\u00125&\u00111L\u0005\u0002\b!J|G-^2u!\t\tR,\u0003\u0002_%\ta1+\u001a:jC2L'0\u00192mK\"A\u0001M\u0016BK\u0002\u0013\u0005\u0011-A\u0003csR,7/F\u0001c!\t\u0019g-D\u0001e\u0015\t)W&\u0001\u0003vi&d\u0017BA4e\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\tSZ\u0013\t\u0012)A\u0005E\u00061!-\u001f;fg\u0002BQA\u0011,\u0005\u0002-$\"\u0001\u001c8\u0011\u000554V\"\u0001\u0001\t\u000b\u0001T\u0007\u0019\u00012\t\u000fA4\u0016\u0011!C\u0001c\u0006!1m\u001c9z)\ta'\u000fC\u0004a_B\u0005\t\u0019\u00012\t\u000fQ4\u0016\u0013!C\u0001k\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001<+\u0005\t<8&\u0001=\u0011\u0005etX\"\u0001>\u000b\u0005md\u0018!C;oG\",7m[3e\u0015\ti(#\u0001\u0006b]:|G/\u0019;j_:L!a >\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0004Y\u000b\t\u0011\"\u0011\u0002\u0006\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017bA\u0013\u0002\f!I\u0011q\u0003,\u0002\u0002\u0013\u0005\u0011\u0011D\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00037\u00012!EA\u000f\u0013\r\tyB\u0005\u0002\u0004\u0013:$\b\"CA\u0012-\u0006\u0005I\u0011AA\u0013\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\n\u0002.A\u0019\u0011#!\u000b\n\u0007\u0005-\"CA\u0002B]fD!\"a\f\u0002\"\u0005\u0005\t\u0019AA\u000e\u0003\rAH%\r\u0005\n\u0003g1\u0016\u0011!C!\u0003k\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0001b!!\u000f\u0002@\u0005\u001dRBAA\u001e\u0015\r\tiDE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA!\u0003w\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u000b2\u0016\u0011!C\u0001\u0003\u000f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\ny\u0005E\u0002\u0012\u0003\u0017J1!!\u0014\u0013\u0005\u001d\u0011un\u001c7fC:D!\"a\f\u0002D\u0005\u0005\t\u0019AA\u0014\u0011%\t\u0019FVA\u0001\n\u0003\n)&\u0001\u0005iCND7i\u001c3f)\t\tY\u0002C\u0005\u0002ZY\u000b\t\u0011\"\u0011\u0002\\\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\b!I\u0011q\f,\u0002\u0002\u0013\u0005\u0013\u0011M\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u00131\r\u0005\u000b\u0003_\ti&!AA\u0002\u0005\u001dr!CA4\u0001\u0005\u0005\t\u0012BA5\u0003)\tE\u000f^1dQ6,g\u000e\u001e\t\u0004[\u0006-d\u0001C,\u0001\u0003\u0003EI!!\u001c\u0014\u000b\u0005-\u0014q\u000e/\u0011\r\u0005E\u0014q\u000f2m\u001b\t\t\u0019HC\u0002\u0002vI\tqA];oi&lW-\u0003\u0003\u0002z\u0005M$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9!)a\u001b\u0005\u0002\u0005uDCAA5\u0011)\tI&a\u001b\u0002\u0002\u0013\u0015\u00131\f\u0005\u000b\u0003\u0007\u000bY'!A\u0005\u0002\u0006\u0015\u0015!B1qa2LHc\u00017\u0002\b\"1\u0001-!!A\u0002\tD!\"a#\u0002l\u0005\u0005I\u0011QAG\u0003\u001d)h.\u00199qYf$B!a$\u0002\u0016B!\u0011#!%c\u0013\r\t\u0019J\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005]\u0015\u0011RA\u0001\u0002\u0004a\u0017a\u0001=%a!I\u00111\u0014\u0001C\u0002\u0013%\u0011QT\u0001\fCR$\u0018m\u00195nK:$8/\u0006\u0002\u0002 B1\u0011\u0011UAS91l!!a)\u000b\u0007E\u000bY$\u0003\u0003\u0002(\u0006\r&a\u0002+sS\u0016l\u0015\r\u001d\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002 \u0006a\u0011\r\u001e;bG\"lWM\u001c;tA!I\u0011q\u0016\u0001A\u0002\u0013%\u0011\u0011W\u0001\u0007G2|7/\u001a3\u0016\u0005\u0005%\u0003\"CA[\u0001\u0001\u0007I\u0011BA\\\u0003)\u0019Gn\\:fI~#S-\u001d\u000b\u0005\u0003s\u000by\fE\u0002\u0012\u0003wK1!!0\u0013\u0005\u0011)f.\u001b;\t\u0015\u0005=\u00121WA\u0001\u0002\u0004\tI\u0005\u0003\u0005\u0002D\u0002\u0001\u000b\u0015BA%\u0003\u001d\u0019Gn\\:fI\u0002B\u0011\"a2\u0001\u0005\u0004%\t%!\u0002\u0002\rM\u001c\u0007.Z7f\u0011!\tY\r\u0001Q\u0001\n\u0005\u001d\u0011aB:dQ\u0016lW\r\t\u0005\t\u0003\u001f\u0004A\u0011\u000b\u0004\u0002R\u00061\u0011\r\u001e;bG\"$\"\"a5\u0002l\u0006m\u0018q B\f)\u0011\t).!9\u0011\u000b=\u000b9.a7\n\u0007\u0005e\u0007K\u0001\u0004GkR,(/\u001a\t\u0004/\u0005u\u0017bAAp\t\ta\u0011\t\u001e;bG\"\u0014Vm];mi\"A\u00111]Ag\u0001\b\t)/A\u0004ue\u0006t7/\u001b3\u0011\u0007Q\n9/C\u0002\u0002jV\u0012Q\u0002\u0016:b]N\f7\r^5p]&#\u0007\u0002CAw\u0003\u001b\u0004\r!a<\u0002\u000b\u0011|7-\u00133\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gT1!!>\u0007\u0003\u0019)g\u000e^5us&!\u0011\u0011`Az\u0005\u0015!unY%e\u0011\u001d\ti0!4A\u0002q\tAA\\1nK\"A!\u0011AAg\u0001\u0004\u0011\u0019!A\u0006d_:$XM\u001c;UsB,\u0007\u0003\u0002B\u0003\u0005'i!Aa\u0002\u000b\t\t%!1B\u0001\u0006[>$W\r\u001c\u0006\u0005\u0005\u001b\u0011y!\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r\u0011\t\"L\u0001\u0005QR$\b/\u0003\u0003\u0003\u0016\t\u001d!aC\"p]R,g\u000e\u001e+za\u0016D\u0001B!\u0007\u0002N\u0002\u0007!1D\u0001\nI>\u001c7\u000b\u001e:fC6\u0004DA!\b\u0003,A9!q\u0004B\u0012E\n\u001dRB\u0001B\u0011\u0015\r\u0011i!P\u0005\u0005\u0005K\u0011\tC\u0001\u0004T_V\u00148-\u001a\t\u0005\u0005S\u0011Y\u0003\u0004\u0001\u0005\u0019\t5\"qCA\u0001\u0002\u0003\u0015\tAa\f\u0003\u0007}#\u0013'\u0005\u0003\u00032\u0005\u001d\u0002cA\t\u00034%\u0019!Q\u0007\n\u0003\u000f9{G\u000f[5oO\"A!\u0011\b\u0001\u0005R\u0019\u0011Y$\u0001\bsK\u0006$\u0017\t\u001e;bG\"lWM\u001c;\u0016\t\tu\"Q\t\u000b\t\u0005\u007f\u0011YE!\u0014\u0003PQ!!\u0011\tB%!\u0015y\u0015q\u001bB\"!\u0011\u0011IC!\u0012\u0005\u0011\t\u001d#q\u0007b\u0001\u0005_\u0011\u0011\u0001\u0016\u0005\t\u0003G\u00149\u0004q\u0001\u0002f\"A\u0011Q\u001eB\u001c\u0001\u0004\ty\u000fC\u0004\u0002~\n]\u0002\u0019\u0001\u000f\t\u0011\tE#q\u0007a\u0001\u0005'\nAa]5oWB9!q\u0004B+E\n\u0005\u0013\u0002\u0002B,\u0005C\u0011AaU5oW\"A!1\f\u0001\u0005R\u0019\u0011i&A\teK2,G/Z!ui\u0006\u001c\u0007.\\3oiN$BAa\u0018\u0003fQ!!\u0011\rB2!\u0015y\u0015q[A%\u0011!\t\u0019O!\u0017A\u0004\u0005\u0015\b\u0002CAw\u00053\u0002\r!a<\t\u0011\t%\u0004\u0001\"\u0015\u0007\u0005W\n\u0001\u0003Z3mKR,\u0017\t\u001e;bG\"lWM\u001c;\u0015\r\t5$\u0011\u000fB:)\u0011\u0011\tGa\u001c\t\u0011\u0005\r(q\ra\u0002\u0003KD\u0001\"!<\u0003h\u0001\u0007\u0011q\u001e\u0005\b\u0003{\u00149\u00071\u0001\u001d\u0011\u001d\u00119\b\u0001C\u0001\u00033\tq\"\u0019;uC\u000eDW.\u001a8u\u0007>,h\u000e\u001e\u0005\b\u0005w\u0002A\u0011AAY\u0003!I7o\u00117pg\u0016$\u0007b\u0002B@\u0001\u0011\u0005#\u0011Q\u0001\tg\",H\u000fZ8x]R\u0011\u0011\u0011\u0018\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u00035\tG\u000f^1dQ6,g\u000e^&fsR)AD!#\u0003\f\"A\u0011Q\u001eBB\u0001\u0004\ty\u000fC\u0004\u0002~\n\r\u0005\u0019\u0001\u000f")
public class MemoryAttachmentStore
implements AttachmentStore {
    private volatile MemoryAttachmentStore$Attachment$ Attachment$module;
    private final String dbName;
    private final Logging logging;
    private final ActorMaterializer materializer;
    private final ExecutionContext executionContext;
    private final TrieMap<String, Attachment> attachments;
    private boolean closed;
    private final String scheme;

    private MemoryAttachmentStore$Attachment$ Attachment() {
        if (this.Attachment$module == null) {
            this.Attachment$lzycompute$1();
        }
        return this.Attachment$module;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private TrieMap<String, Attachment> attachments() {
        return this.attachments;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public Future<AttachResult> attach(String docId, String name, ContentType contentType, Source<ByteString, ?> docStream, TransactionMetadata transid) {
        Predef$.MODULE$.require(name != null, (Function0 & Serializable & scala.Serializable)() -> "name undefined");
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATT_SAVE(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("[ATT_PUT] uploading attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        Sink uploadSink = Sink$.MODULE$.fold((Object)new ByteStringBuilder(), (Function2 & Serializable & scala.Serializable)(builder, b) -> builder.$plus$plus$eq((TraversableOnce)b));
        Future f = (Future)docStream.runWith(StoreUtils$.MODULE$.combinedSink(uploadSink, this.executionContext()), (Materializer)this.materializer);
        Future g = f.map((Function1 & Serializable & scala.Serializable)r -> {
            this.attachments().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.attachmentKey(docId, name)), (Object)new Attachment(this, (ByteString)((ByteStringBuilder)r.uploadResult()).result().compact())));
            TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("[ATT_PUT] '").append($this.dbName).append("' completed uploading attachment '").append(name).append("' of document '").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), $this.logging);
            return new AttachResult(r.digest(), r.length());
        }, this.executionContext());
        return StoreUtils$.MODULE$.reportFailure(g, start, (Function1<Throwable, String>)(Function1 & Serializable & scala.Serializable)failure -> new StringBuilder(63).append("[ATT_PUT] '").append($this.dbName).append("' internal error, name: '").append(name).append("', doc: 'id: ").append(new DocId(docId)).append("', failure: '").append(failure.getMessage()).append("'").toString(), transid, this.logging, this.executionContext());
    }

    @Override
    public <T> Future<T> readAttachment(String docId, String name, Sink<ByteString, Future<T>> sink, TransactionMetadata transid) {
        Future future;
        Some some;
        Attachment attachment;
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATT_GET(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("[ATT_GET] '").append($this.dbName).append("' finding attachment '").append(name).append("' of document 'id: ").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        Option option = this.attachments().get((Object)this.attachmentKey(docId, name));
        if (option instanceof Some && (attachment = (Attachment)(some = (Some)option).value()) != null) {
            ByteString bytes = attachment.bytes();
            Future r = (Future)Source$.MODULE$.single((Object)bytes).toMat(sink, Keep$.MODULE$.right()).run((Materializer)this.materializer);
            future = r.map((Function1 & Serializable & scala.Serializable)t -> {
                TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("[ATT_GET] '").append($this.dbName).append("' completed: found attachment '").append(name).append("' of document '").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), $this.logging);
                return t;
            }, this.executionContext());
        } else if (None$.MODULE$.equals(option)) {
            TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("[ATT_GET] '").append($this.dbName).append("', retrieving attachment '").append(name).append("' of document '").append(new DocId(docId)).append("'; not found.").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), this.logging);
            future = Future$.MODULE$.failed((Throwable)new NoDocumentException("Not found on 'readAttachment'."));
        } else {
            throw new MatchError((Object)option);
        }
        Future f = future;
        return StoreUtils$.MODULE$.reportFailure(f, start, (Function1<Throwable, String>)(Function1 & Serializable & scala.Serializable)failure -> new StringBuilder(59).append("[ATT_GET] '").append($this.dbName).append("' internal error, name: '").append(name).append("', doc: '").append(new DocId(docId)).append("', failure: '").append(failure.getMessage()).append("'").toString(), transid, this.logging, this.executionContext());
    }

    @Override
    public Future<Object> deleteAttachments(String docId, TransactionMetadata transid) {
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATTS_DELETE(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("[ATTS_DELETE] uploading attachment of document '").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        String prefix = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)new DocId(docId)), "/");
        this.attachments().$minus$minus$eq((TraversableOnce)this.attachments().keySet().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(prefix))));
        TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("[ATTS_DELETE] completed: delete attachment of document '").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), this.logging);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    @Override
    public Future<Object> deleteAttachment(String docId, String name, TransactionMetadata transid) {
        StartMarker start = TransactionId$.MODULE$.started$extension(transid, this, LoggingMarkers$.MODULE$.DATABASE_ATT_DELETE(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("[ATT_DELETE] uploading attachment of document '").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.started$default$4$extension(transid), this.logging);
        this.attachments().remove((Object)this.attachmentKey(docId, name));
        TransactionId$.MODULE$.finished$extension(transid, this, start, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("[ATT_DELETE] completed: delete attachment of document '").append(new DocId(docId)).append("'").toString(), TransactionId$.MODULE$.finished$default$4$extension(transid), TransactionId$.MODULE$.finished$default$5$extension(transid), this.logging);
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public int attachmentCount() {
        return this.attachments().size();
    }

    public boolean isClosed() {
        return this.closed();
    }

    @Override
    public void shutdown() {
        this.closed_$eq(true);
    }

    private String attachmentKey(String docId, String name) {
        return new StringBuilder(1).append(docId).append("/").append(name).toString();
    }

    private final void Attachment$lzycompute$1() {
        MemoryAttachmentStore memoryAttachmentStore = this;
        synchronized (memoryAttachmentStore) {
            if (this.Attachment$module == null) {
                this.Attachment$module = new MemoryAttachmentStore$Attachment$(this);
            }
        }
    }

    public MemoryAttachmentStore(String dbName, ActorSystem system, Logging logging, ActorMaterializer materializer) {
        this.dbName = dbName;
        this.logging = logging;
        this.materializer = materializer;
        this.executionContext = system.dispatcher();
        this.attachments = new TrieMap();
        this.closed = false;
        this.scheme = "mems";
    }

    public class Attachment
    implements Product,
    scala.Serializable {
        private final ByteString bytes;
        public final /* synthetic */ MemoryAttachmentStore $outer;

        public ByteString bytes() {
            return this.bytes;
        }

        public Attachment copy(ByteString bytes) {
            return new Attachment(this.org$apache$openwhisk$core$database$memory$MemoryAttachmentStore$Attachment$$$outer(), bytes);
        }

        public ByteString copy$default$1() {
            return this.bytes();
        }

        public String productPrefix() {
            return "Attachment";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.bytes();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Attachment;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Attachment)) return false;
            if (((Attachment)object).org$apache$openwhisk$core$database$memory$MemoryAttachmentStore$Attachment$$$outer() != this.org$apache$openwhisk$core$database$memory$MemoryAttachmentStore$Attachment$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Attachment attachment = (Attachment)x$1;
            ByteString byteString = this.bytes();
            ByteString byteString2 = attachment.bytes();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!byteString.equals(byteString2)) return false;
            if (!attachment.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MemoryAttachmentStore org$apache$openwhisk$core$database$memory$MemoryAttachmentStore$Attachment$$$outer() {
            return this.$outer;
        }

        public Attachment(MemoryAttachmentStore $outer, ByteString bytes) {
            this.bytes = bytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

