/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core.containerpool.logging;

import akka.NotUsed;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Sink$;
import akka.util.ByteString;
import java.io.Serializable;
import org.apache.openwhisk.common.TransactionMetadata;
import org.apache.openwhisk.core.containerpool.Container;
import org.apache.openwhisk.core.containerpool.logging.DockerToActivationLogStore$;
import org.apache.openwhisk.core.containerpool.logging.LogCollectingException;
import org.apache.openwhisk.core.containerpool.logging.LogStore;
import org.apache.openwhisk.core.database.UserContext;
import org.apache.openwhisk.core.entity.ActivationLogs;
import org.apache.openwhisk.core.entity.CodeExec;
import org.apache.openwhisk.core.entity.ExecutableWhiskAction;
import org.apache.openwhisk.core.entity.Identity;
import org.apache.openwhisk.core.entity.LogLimit$;
import org.apache.openwhisk.core.entity.WhiskActivation;
import org.apache.openwhisk.http.Messages$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015t!B\u0001\u0003\u0011\u0003y\u0011A\u0007#pG.,'\u000fV8BGRLg/\u0019;j_:dunZ*u_J,'BA\u0002\u0005\u0003\u001dawnZ4j]\u001eT!!\u0002\u0004\u0002\u001b\r|g\u000e^1j]\u0016\u0014\bo\\8m\u0015\t9\u0001\"\u0001\u0003d_J,'BA\u0005\u000b\u0003%y\u0007/\u001a8xQ&\u001c8N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u001b\t>\u001c7.\u001a:U_\u0006\u001bG/\u001b<bi&|g\u000eT8h'R|'/Z\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u001dq\u0012C1A\u0005\u0002}\t\u0011\u0003^8G_Jl\u0017\r\u001e;fIN#(/\u001b8h+\u0005\u0001\u0003#B\u0011)UAZT\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001C:dC2\fGm\u001d7\u000b\u0005\u00152\u0013AB:ue\u0016\fWNC\u0001(\u0003\u0011\t7n[1\n\u0005%\u0012#\u0001\u0002$m_^\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u0014\u0002\tU$\u0018\u000e\\\u0005\u0003_1\u0012!BQ=uKN#(/\u001b8h!\t\t\u0004H\u0004\u00023mA\u00111GF\u0007\u0002i)\u0011QGD\u0001\u0007yI|w\u000e\u001e \n\u0005]2\u0012A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!a\u000e\f\u0011\u0005qjT\"\u0001\u0014\n\u0005y2#a\u0002(piV\u001bX\r\u001a\u0005\u0007\u0001F\u0001\u000b\u0011\u0002\u0011\u0002%Q|gi\u001c:nCR$X\rZ*ue&tw\r\t\u0004\u0005%\t\u0001!iE\u0002B)\r\u0003\"\u0001\u0005#\n\u0005\u0015\u0013!\u0001\u0003'pON#xN]3\t\u0011\u001d\u000b%\u0011!Q\u0001\n!\u000baa]=ti\u0016l\u0007CA%M\u001b\u0005Q%BA&'\u0003\u0015\t7\r^8s\u0013\ti%JA\u0006BGR|'oU=ti\u0016l\u0007\"B\u000eB\t\u0003yEC\u0001)R!\t\u0001\u0012\tC\u0003H\u001d\u0002\u0007\u0001\nC\u0004T\u0003\n\u0007I1\u0001+\u0002\u0005\u0015\u001cW#A+\u0011\u0005YKV\"A,\u000b\u0005a3\u0012AC2p]\u000e,(O]3oi&\u0011!l\u0016\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDa\u0001X!!\u0002\u0013)\u0016aA3dA!9a,\u0011b\u0001\n\u0007y\u0016aA7biV\t\u0001\r\u0005\u0002bE6\tA%\u0003\u0002dI\t\t\u0012i\u0019;pe6\u000bG/\u001a:jC2L'0\u001a:\t\r\u0015\f\u0005\u0015!\u0003a\u0003\u0011i\u0017\r\u001e\u0011\t\u000f\u001d\f%\u0019!C!Q\u0006\u00192m\u001c8uC&tWM\u001d)be\u0006lW\r^3sgV\t\u0011\u000e\u0005\u0003k_FDX\"A6\u000b\u00051l\u0017!C5n[V$\u0018M\u00197f\u0015\tqg#\u0001\u0006d_2dWm\u0019;j_:L!\u0001]6\u0003\u00075\u000b\u0007\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!!O:\u0011\u0007)L\u0018/\u0003\u0002{W\n\u00191+\u001a;\t\rq\f\u0005\u0015!\u0003j\u0003Q\u0019wN\u001c;bS:,'\u000fU1sC6,G/\u001a:tA!)a0\u0011C!\u007f\u0006Ia-\u001a;dQ2{wm\u001d\u000b\u0007\u0003\u0003\t\u0019\"!\b\u0011\u000bY\u000b\u0019!a\u0002\n\u0007\u0005\u0015qK\u0001\u0004GkR,(/\u001a\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0004\u0002\r\u0015tG/\u001b;z\u0013\u0011\t\t\"a\u0003\u0003\u001d\u0005\u001bG/\u001b<bi&|g\u000eT8hg\"9\u0011QC?A\u0002\u0005]\u0011AC1di&4\u0018\r^5p]B!\u0011\u0011BA\r\u0013\u0011\tY\"a\u0003\u0003\u001f]C\u0017n]6BGRLg/\u0019;j_:Dq!a\b~\u0001\u0004\t\t#A\u0004d_:$X\r\u001f;\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n\u0007\u0003!!\u0017\r^1cCN,\u0017\u0002BA\u0016\u0003K\u00111\"V:fe\u000e{g\u000e^3yi\"9\u0011qF!\u0005B\u0005E\u0012aC2pY2,7\r\u001e'pON$B\"!\u0001\u00024\u0005\r\u0013QJA(\u00037B\u0001\"!\u000e\u0002.\u0001\u0007\u0011qG\u0001\biJ\fgn]5e!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f\u0011\u000511m\\7n_:LA!!\u0011\u0002<\tiAK]1og\u0006\u001cG/[8o\u0013\u0012D\u0001\"!\u0012\u0002.\u0001\u0007\u0011qI\u0001\u0005kN,'\u000f\u0005\u0003\u0002\n\u0005%\u0013\u0002BA&\u0003\u0017\u0011\u0001\"\u00133f]RLG/\u001f\u0005\t\u0003+\ti\u00031\u0001\u0002\u0018!A\u0011\u0011KA\u0017\u0001\u0004\t\u0019&A\u0005d_:$\u0018-\u001b8feB!\u0011QKA,\u001b\u0005!\u0011bAA-\t\tI1i\u001c8uC&tWM\u001d\u0005\t\u0003;\ni\u00031\u0001\u0002`\u00051\u0011m\u0019;j_:\u0004B!!\u0003\u0002b%!\u00111MA\u0006\u0005U)\u00050Z2vi\u0006\u0014G.Z,iSN\\\u0017i\u0019;j_:\u0004")
public class DockerToActivationLogStore
implements LogStore {
    private final ExecutionContext ec;
    private final ActorMaterializer mat;
    private final Map<String, Set<String>> containerParameters;

    public static Flow<ByteString, String, NotUsed> toFormattedString() {
        return DockerToActivationLogStore$.MODULE$.toFormattedString();
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ActorMaterializer mat() {
        return this.mat;
    }

    @Override
    public Map<String, Set<String>> containerParameters() {
        return this.containerParameters;
    }

    @Override
    public Future<Vector<String>> fetchLogs(WhiskActivation activation, UserContext context) {
        return Future$.MODULE$.successful((Object)new ActivationLogs((Vector<String>)activation.logs()));
    }

    @Override
    public Future<Vector<String>> collectLogs(TransactionMetadata transid, Identity user, WhiskActivation activation, Container container, ExecutableWhiskAction action) {
        return ((Future)container.logs(LogLimit$.MODULE$.asMegaBytes$extension(action.limits().logs()), ((CodeExec)action.exec()).sentinelledLogs(), transid).via(DockerToActivationLogStore$.MODULE$.toFormattedString()).runWith((Graph)Sink$.MODULE$.seq(), (Materializer)this.mat())).flatMap((Function1 & Serializable & scala.Serializable)seq -> {
            Set possibleErrors = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Messages$.MODULE$.logFailure(), Messages$.MODULE$.truncateLogs(LogLimit$.MODULE$.asMegaBytes$extension(action.limits().logs()))}));
            boolean errored = seq.lastOption().exists((Function1 & Serializable & scala.Serializable)last -> BoxesRunTime.boxToBoolean((boolean)possibleErrors.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)last.contains(x$1)))));
            Vector logs = seq.toVector();
            return !errored ? Future$.MODULE$.successful((Object)new ActivationLogs((Vector<String>)logs)) : Future$.MODULE$.failed((Throwable)new LogCollectingException(logs));
        }, this.ec());
    }

    public DockerToActivationLogStore(ActorSystem system) {
        this.ec = system.dispatcher();
        this.mat = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
        this.containerParameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"--log-driver"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"json-file"})))}));
    }
}

