/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openwhisk.core;

import java.io.File;
import java.io.Serializable;
import org.apache.openwhisk.common.Logging;
import org.apache.openwhisk.common.TransactionMetadata;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.sys.package$;

public final class WhiskConfig$ {
    public static WhiskConfig$ MODULE$;
    private final String servicePort;
    private final String dockerPort;
    private final String dockerEndpoint;
    private final String dbPrefix;
    private final String edgeHostName;
    private final String wskApiProtocol;
    private final String wskApiPort;
    private final String wskApiHostname;
    private final Map<String, String> wskApiHost;
    private final String mainDockerEndpoint;
    private final String controllerBlackboxFraction;
    private final String controllerInstances;
    private final String dbInstances;
    private final String kafkaHostList;
    private final String zookeeperHostList;
    private final String org$apache$openwhisk$core$WhiskConfig$$edgeHostApiPort;
    private final String invokerHostsList;
    private final String dbHostsList;
    private final Map<String, Null$> edgeHost;
    private final Map<String, Null$> invokerHosts;
    private final Map<String, Null$> kafkaHosts;
    private final Map<String, Null$> zookeeperHosts;
    private final String runtimesRegistry;
    private final String runtimesManifest;
    private final String actionSequenceMaxLimit;
    private final String actionInvokePerMinuteLimit;
    private final String actionInvokeConcurrentLimit;
    private final String triggerFirePerMinuteLimit;
    private final String controllerSeedNodes;

    static {
        new WhiskConfig$();
    }

    public Set<String> $lessinit$greater$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public File $lessinit$greater$default$3() {
        return null;
    }

    public Map<String, String> $lessinit$greater$default$4() {
        return package$.MODULE$.env();
    }

    public Option<String> readFromEnv(String key) {
        return package$.MODULE$.env().get((Object)this.asEnvVar(key));
    }

    public File org$apache$openwhisk$core$WhiskConfig$$whiskPropertiesFile() {
        Option dir = package$.MODULE$.props().get("user.dir");
        return dir.isDefined() ? this.propfile$1((String)dir.get(), true) : null;
    }

    public void readPropertiesFromFile(scala.collection.mutable.Map<String, String> properties, File file, Logging logging) {
        if (file != null && file.exists()) {
            WhiskConfig$ x$1 = this;
            Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("reading properties from file ").append(file).toString();
            TransactionMetadata x$3 = logging.info$default$3(x$1, (Function0<String>)x$2);
            logging.info(x$1, (Function0<String>)x$2, x$3);
            try (BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());){
                source.getLines().withFilter((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)WhiskConfig$.$anonfun$readPropertiesFromFile$2(line))).foreach((Function1 & Serializable & scala.Serializable)line -> {
                    WhiskConfig$.$anonfun$readPropertiesFromFile$3(properties, logging, line);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public String asEnvVar(String key) {
        return key != null ? key.replace('.', '_').toUpperCase() : null;
    }

    public String servicePort() {
        return this.servicePort;
    }

    public String dockerPort() {
        return this.dockerPort;
    }

    public String dockerEndpoint() {
        return this.dockerEndpoint;
    }

    public String dbPrefix() {
        return this.dbPrefix;
    }

    public String edgeHostName() {
        return this.edgeHostName;
    }

    public String wskApiProtocol() {
        return this.wskApiProtocol;
    }

    public String wskApiPort() {
        return this.wskApiPort;
    }

    public String wskApiHostname() {
        return this.wskApiHostname;
    }

    public Map<String, String> wskApiHost() {
        return this.wskApiHost;
    }

    public String mainDockerEndpoint() {
        return this.mainDockerEndpoint;
    }

    public String controllerBlackboxFraction() {
        return this.controllerBlackboxFraction;
    }

    public String controllerInstances() {
        return this.controllerInstances;
    }

    public String dbInstances() {
        return this.dbInstances;
    }

    public String kafkaHostList() {
        return this.kafkaHostList;
    }

    public String zookeeperHostList() {
        return this.zookeeperHostList;
    }

    public String org$apache$openwhisk$core$WhiskConfig$$edgeHostApiPort() {
        return this.org$apache$openwhisk$core$WhiskConfig$$edgeHostApiPort;
    }

    public String invokerHostsList() {
        return this.invokerHostsList;
    }

    public String dbHostsList() {
        return this.dbHostsList;
    }

    public Map<String, Null$> edgeHost() {
        return this.edgeHost;
    }

    public Map<String, Null$> invokerHosts() {
        return this.invokerHosts;
    }

    public Map<String, Null$> kafkaHosts() {
        return this.kafkaHosts;
    }

    public Map<String, Null$> zookeeperHosts() {
        return this.zookeeperHosts;
    }

    public String runtimesRegistry() {
        return this.runtimesRegistry;
    }

    public String runtimesManifest() {
        return this.runtimesManifest;
    }

    public String actionSequenceMaxLimit() {
        return this.actionSequenceMaxLimit;
    }

    public String actionInvokePerMinuteLimit() {
        return this.actionInvokePerMinuteLimit;
    }

    public String actionInvokeConcurrentLimit() {
        return this.actionInvokeConcurrentLimit;
    }

    public String triggerFirePerMinuteLimit() {
        return this.triggerFirePerMinuteLimit;
    }

    public String controllerSeedNodes() {
        return this.controllerSeedNodes;
    }

    private final File propfile$1(String dir, boolean recurse) {
        File file;
        block4: {
            while (dir != null) {
                File base = new File(dir);
                File file2 = new File(base, "whisk.properties");
                if (file2.exists()) {
                    file = file2;
                } else {
                    if (recurse) {
                        recurse = true;
                        dir = base.getParent();
                        continue;
                    }
                    file = null;
                }
                break block4;
            }
            file = null;
        }
        return file;
    }

    private static final boolean propfile$default$2$1() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$readPropertiesFromFile$2(String line) {
        String string = line.trim();
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$readPropertiesFromFile$3(scala.collection.mutable.Map properties$1, Logging logging$1, String line) {
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
        if (parts.length >= 1) {
            String v;
            String p = parts[0].trim();
            String string = v = parts.length == 2 ? parts[1].trim() : "";
            if (properties$1.contains((Object)p)) {
                properties$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), (Object)v));
                WhiskConfig$ x$4 = MODULE$;
                Function0 & Serializable & scala.Serializable x$5 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("properties file set value for ").append(p).toString();
                TransactionMetadata x$6 = logging$1.debug$default$3(x$4, (Function0<String>)x$5);
                logging$1.debug(x$4, (Function0<String>)x$5, x$6);
            }
        } else {
            WhiskConfig$ x$7 = MODULE$;
            Function0 & Serializable & scala.Serializable x$8 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("ignoring properties ").append(line).toString();
            TransactionMetadata x$9 = logging$1.warn$default$3(x$7, (Function0<String>)x$8);
            logging$1.warn(x$7, (Function0<String>)x$8, x$9);
        }
    }

    private WhiskConfig$() {
        MODULE$ = this;
        this.servicePort = "port";
        this.dockerPort = "docker.port";
        this.dockerEndpoint = "main.docker.endpoint";
        this.dbPrefix = "db.prefix";
        this.edgeHostName = "edge.host";
        this.wskApiProtocol = "whisk.api.host.proto";
        this.wskApiPort = "whisk.api.host.port";
        this.wskApiHostname = "whisk.api.host.name";
        this.wskApiHost = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.wskApiProtocol()), (Object)"https"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.wskApiPort()), (Object)((Object)BoxesRunTime.boxToInteger((int)443)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.wskApiHostname()), null)}));
        this.mainDockerEndpoint = "main.docker.endpoint";
        this.controllerBlackboxFraction = "controller.blackboxFraction";
        this.controllerInstances = "controller.instances";
        this.dbInstances = "db.instances";
        this.kafkaHostList = "kafka.hosts";
        this.zookeeperHostList = "zookeeper.hosts";
        this.org$apache$openwhisk$core$WhiskConfig$$edgeHostApiPort = "edge.host.apiport";
        this.invokerHostsList = "invoker.hosts";
        this.dbHostsList = "db.hostsList";
        this.edgeHost = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.edgeHostName()), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.org$apache$openwhisk$core$WhiskConfig$$edgeHostApiPort()), null)}));
        this.invokerHosts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.invokerHostsList()), null)}));
        this.kafkaHosts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.kafkaHostList()), null)}));
        this.zookeeperHosts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.zookeeperHostList()), null)}));
        this.runtimesRegistry = "runtimes.registry";
        this.runtimesManifest = "runtimes.manifest";
        this.actionSequenceMaxLimit = "limits.actions.sequence.maxLength";
        this.actionInvokePerMinuteLimit = "limits.actions.invokes.perMinute";
        this.actionInvokeConcurrentLimit = "limits.actions.invokes.concurrent";
        this.triggerFirePerMinuteLimit = "limits.triggers.fires.perMinute";
        this.controllerSeedNodes = "akka.cluster.seed.nodes";
    }
}

